/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.io.HTMLConverter;
import groove.io.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class ContributorsTable
extends JTable {
    private final URLRenderer urlRenderer = new URLRenderer();
    private static ContributorsTable instance = new ContributorsTable();

    private ContributorsTable() {
        this.addMouseListener(this.urlRenderer);
        this.addMouseMotionListener(this.urlRenderer);
        this.setModel(new TableModel(Util.readCSV("contributors", ';')));
        int i = 0;
        while (i < this.getColumnCount()) {
            int width = 0;
            int j = 0;
            while (j < this.getRowCount()) {
                Component renderer = this.prepareRenderer(this.getCellRenderer(j, i), j, i);
                width = Math.max(renderer.getPreferredSize().width, width);
                ++j;
            }
            this.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
    }

    public void showDialog(Component parent, String title) {
        JScrollPane scrollPane = new JScrollPane(this);
        scrollPane.getViewport().setPreferredSize(this.getPreferredSize());
        JOptionPane optionPane = new JOptionPane(scrollPane, -1);
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        ContributorsTable.instance().showDialog(null, "Contributors");
    }

    public static ContributorsTable instance() {
        return instance;
    }

    private class TableModel
    extends AbstractTableModel {
        private final List<String[]> data;

        TableModel(List<String[]> data) {
            assert (!data.isEmpty());
            this.data = data;
        }

        @Override
        public String getColumnName(int column) {
            return "Name";
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.data.get(0).length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.get(rowIndex)[columnIndex];
        }
    }

    private static class URLRenderer
    extends DefaultTableCellRenderer
    implements MouseListener,
    MouseMotionListener {
        private int row = -1;
        private int col = -1;
        private static final HTMLConverter.HTMLTag BLUE_TAG = HTMLConverter.createColorTag(Color.BLUE);

        private URLRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            StringBuilder text = new StringBuilder(value.toString());
            BLUE_TAG.on(text);
            if (this.row == row && this.col == column) {
                HTMLConverter.UNDERLINE_TAG.on(text);
            }
            this.setText(HTMLConverter.HTML_TAG.on(text).toString());
            return this;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Point pt = e.getPoint();
            int prev_row = this.row;
            int prev_col = this.col;
            this.row = table.rowAtPoint(pt);
            this.col = table.columnAtPoint(pt);
            if (this.row != prev_row || this.col != prev_col) {
                Rectangle r = table.getCellRect(this.row, this.col, false);
                r = r.union(table.getCellRect(prev_row, prev_col, false));
                table.repaint(r);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            table.repaint(table.getCellRect(this.row, this.col, false));
            this.row = -1;
            this.col = -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Point pt = e.getPoint();
            int ccol = table.columnAtPoint(pt);
            int crow = table.rowAtPoint(pt);
            Object value = table.getValueAt(crow, ccol);
            if (value instanceof URL) {
                URL url = (URL)value;
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(url.toURI());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }
}

