/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class NumberDialog {
    private JOptionPane optionPane;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel numberPanel;
    private JSpinner numberField;
    private final String prompt;
    private static String DEFAULT_TITLE = "Select rule name";

    public NumberDialog(String prompt) {
        this.prompt = prompt;
    }

    public boolean showDialog(JFrame frame, String title, int initial) {
        this.getNumberField().setValue(initial);
        JDialog dialog = this.getOptionPane().createDialog(frame, title == null ? DEFAULT_TITLE : title);
        dialog.setVisible(true);
        Object response = this.getOptionPane().getValue();
        return response == this.getOkButton();
    }

    public int getResult() {
        return ((Number)this.getNumberField().getValue()).intValue();
    }

    private JOptionPane getOptionPane() {
        if (this.optionPane == null) {
            this.optionPane = new JOptionPane(this.getNumberPanel(), -1, 2, null, new Object[]{this.getOkButton(), this.getCancelButton()});
        }
        return this.optionPane;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new CloseListener());
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new CloseListener());
        }
        return this.cancelButton;
    }

    private JPanel getNumberPanel() {
        if (this.numberPanel == null) {
            this.numberPanel = new JPanel(new FlowLayout(1, 10, 0));
            this.numberPanel.add(new JLabel(this.prompt));
            this.numberPanel.add(this.getNumberField());
        }
        return this.numberPanel;
    }

    private JSpinner getNumberField() {
        if (this.numberField == null) {
            this.numberField = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
            this.numberField.setPreferredSize(new Dimension(50, this.numberField.getPreferredSize().height));
        }
        return this.numberField;
    }

    private class CloseListener
    implements ActionListener {
        CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NumberDialog.this.getOptionPane().setValue(e.getSource());
            NumberDialog.this.getOptionPane().setVisible(false);
        }
    }
}

