/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.gui.dialog.PropertiesTable;
import groove.gui.dialog.PropertyKey;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.table.TableCellEditor;

public class PropertiesDialog {
    private final PropertiesTable table;
    private JOptionPane pane;
    private JButton okButton;
    public static final String DIALOG_TITLE = "Properties editor";
    public static final String PROPERTY_HEADER = "Property";
    public static final String VALUE_HEADER = "Value";

    public PropertiesDialog(Properties properties, Map<String, ? extends PropertyKey> defaultKeys) {
        this.table = new PropertiesTable(defaultKeys, true);
        this.table.setProperties(properties);
    }

    public boolean showDialog(Component frame) {
        boolean result;
        boolean stopDialog;
        do {
            this.getContentPane().setValue(null);
            this.getContentPane().setVisible(true);
            JDialog dialog = this.getContentPane().createDialog(frame, this.createTitle());
            dialog.setResizable(true);
            dialog.setVisible(true);
            dialog.dispose();
            Object selectedValue = this.getContentPane().getValue();
            if (this.table.isChanged()) {
                if (selectedValue == this.getOkButton()) {
                    stopDialog = true;
                    result = true;
                    continue;
                }
                int abandon = this.showAbandonDialog();
                result = abandon == 0;
                stopDialog = abandon != 2;
                continue;
            }
            result = false;
            stopDialog = true;
        } while (!stopDialog);
        return result;
    }

    public Map<String, String> getProperties() {
        return this.table.getProperties();
    }

    private int showAbandonDialog() {
        int response = JOptionPane.showConfirmDialog(this.getContentPane(), "Use changed properties?", null, 1);
        return response;
    }

    private String createTitle() {
        return DIALOG_TITLE;
    }

    JOptionPane getContentPane() {
        if (this.pane == null) {
            int mode = 2;
            Object[] buttons = new Object[]{this.getOkButton(), this.createCancelButton()};
            this.pane = new JOptionPane(this.createTablePane(), -1, mode, null, buttons);
        }
        return this.pane;
    }

    JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new CloseListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableCellEditor editor = PropertiesDialog.this.getInnerTable().getCellEditor();
                    if (editor == null || editor.stopCellEditing()) {
                        super.actionPerformed(e);
                    }
                }
            });
        }
        return this.okButton;
    }

    private JButton createCancelButton() {
        JButton result = new JButton("Cancel");
        result.addActionListener(new CloseListener());
        return result;
    }

    public Container createTablePane() {
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(new BevelBorder(1));
        return scrollPane;
    }

    public PropertiesTable getInnerTable() {
        return this.table;
    }

    private class CloseListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            PropertiesDialog.this.getContentPane().setValue(e.getSource());
            PropertiesDialog.this.getContentPane().setVisible(false);
        }
    }
}

