/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.control.parse.CtrlDoc;
import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.TitledPanel;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public final class ControlDisplay
extends ResourceDisplay {
    private JTree docPane;
    private Map<?, String> toolTipMap;

    ControlDisplay(Simulator simulator) {
        super(simulator, ResourceKind.CONTROL);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.GRAMMAR, SimulatorModel.Change.CONTROL);
    }

    @Override
    protected JComponent createInfoPanel() {
        return new TitledPanel("Control syntax", this.getDocPane(), null, true);
    }

    @Override
    protected void buildInfoPanel() {
    }

    private JTree getDocPane() {
        if (this.docPane == null) {
            this.docPane = this.createDocPane();
        }
        return this.docPane;
    }

    private JTree createDocPane() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        final JTree result = new JTree(root){

            @Override
            public String getToolTipText(MouseEvent evt) {
                if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
                    return null;
                }
                TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
                Object userObject = ((DefaultMutableTreeNode)curPath.getLastPathComponent()).getUserObject();
                return ControlDisplay.this.getToolTip(userObject);
            }
        };
        result.setRootVisible(false);
        result.setShowsRootHandles(true);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)result.getCellRenderer();
        renderer.setBackgroundNonSelectionColor(null);
        renderer.setBackgroundSelectionColor(null);
        renderer.setTextSelectionColor(null);
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        result.setCellRenderer(renderer);
        ToolTipManager.sharedInstance().registerComponent(result);
        result.addMouseListener(new MouseAdapter(){
            private final ToolTipManager manager = ToolTipManager.sharedInstance();
            private final int standardDelay = this.manager.getDismissDelay();

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == result) {
                    this.manager.setDismissDelay(Integer.MAX_VALUE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getSource() == result) {
                    this.manager.setDismissDelay(this.standardDelay);
                }
            }
        });
        CtrlDoc doc = new CtrlDoc();
        this.toolTipMap = doc.getToolTipMap();
        for (Map.Entry<?, List<?>> docEntry : doc.getItemTree().entrySet()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(docEntry.getKey());
            for (Object rule : docEntry.getValue()) {
                node.add(new DefaultMutableTreeNode(rule));
            }
            root.add(node);
        }
        ((DefaultTreeModel)result.getModel()).reload();
        int i = 0;
        while (i < root.getChildCount()) {
            result.expandPath(new TreePath(((DefaultMutableTreeNode)root.getChildAt(i)).getPath()));
            ++i;
        }
        result.setBackground(null);
        return result;
    }

    private String getToolTip(Object value) {
        String result = null;
        if (this.toolTipMap != null) {
            result = this.toolTipMap.get(value);
        }
        return result;
    }

    @Override
    protected JToolBar createListToolBar(int separation) {
        JToolBar result = super.createListToolBar(separation);
        result.add(this.getActions().getPreviewControlAction());
        return result;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        super.update(source, oldModel, changes);
        if (this.suspendListening()) {
            String selection = source.getSelected(ResourceKind.CONTROL);
            this.getDocPane().setBackground(selection == null ? null : Color.WHITE);
            this.activateListening();
        }
    }
}

