/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.action.ActionStore;
import groove.gui.display.ControlDisplay;
import groove.gui.display.DisplayKind;
import groove.gui.display.GroovyDisplay;
import groove.gui.display.LTSDisplay;
import groove.gui.display.PrologDisplay;
import groove.gui.display.PropertiesDisplay;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.RuleDisplay;
import groove.gui.display.StateDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;

public abstract class Display
extends JPanel {
    private final Simulator simulator;
    private final DisplayKind kind;
    private final ResourceKind resource;
    private ListPanel listPanel;
    private JComponent infoPanel;
    private JComponent resourceList;
    private JToolBar listToolBar;
    static final int START_LIST_MINIMUM_HEIGHT = 130;

    protected Display(Simulator simulator, DisplayKind kind) {
        super(new BorderLayout());
        this.setBorder(null);
        this.simulator = simulator;
        this.kind = kind;
        this.resource = kind.getResource();
    }

    public boolean isActive() {
        Container top = this.getParent();
        while (top != null && top.getParent() != null) {
            top = top.getParent();
        }
        return top instanceof Window && ((Window)top).isActive();
    }

    protected abstract void buildDisplay();

    protected abstract void installListeners();

    public final ListPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = this.createListPanel();
            if (this.listPanel != null) {
                ToolTipManager.sharedInstance().registerComponent(this.listPanel);
            }
        }
        return this.listPanel;
    }

    protected ListPanel createListPanel() {
        return new ListPanel(this.getList(), this.getListToolBar(), this.getKind());
    }

    protected final JToolBar getListToolBar() {
        if (this.listToolBar == null) {
            this.listToolBar = this.createListToolBar();
        }
        return this.listToolBar;
    }

    protected abstract JToolBar createListToolBar();

    public JComponent getList() {
        if (this.resourceList == null) {
            this.resourceList = this.createList();
        }
        return this.resourceList;
    }

    protected abstract JComponent createList();

    public JComponent getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = this.createInfoPanel();
            this.infoPanel.setEnabled(false);
        }
        return this.infoPanel;
    }

    protected abstract JComponent createInfoPanel();

    protected void resetList() {
        this.listPanel = null;
        this.resourceList = null;
    }

    public final DisplayKind getKind() {
        return this.kind;
    }

    public final ResourceKind getResourceKind() {
        return this.resource;
    }

    public String getTitle() {
        if (this.getResourceKind() == null) {
            return null;
        }
        return this.getSimulatorModel().getSelected(this.getResourceKind());
    }

    public final Simulator getSimulator() {
        return this.simulator;
    }

    public final SimulatorModel getSimulatorModel() {
        return this.getSimulator().getModel();
    }

    public final ActionStore getActions() {
        return this.getSimulator().getActions();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getInfoPanel().setEnabled(enabled);
    }

    public static Display newDisplay(Simulator simulator, DisplayKind kind) {
        Display result = null;
        switch (kind) {
            case CONTROL: {
                result = new ControlDisplay(simulator);
                break;
            }
            case LTS: {
                result = new LTSDisplay(simulator);
                break;
            }
            case PROLOG: {
                result = new PrologDisplay(simulator);
                break;
            }
            case RULE: {
                result = new RuleDisplay(simulator);
                break;
            }
            case STATE: {
                result = new StateDisplay(simulator);
                break;
            }
            case GROOVY: {
                result = new GroovyDisplay(simulator);
                break;
            }
            case HOST: 
            case TYPE: {
                result = new ResourceDisplay(simulator, kind.getResource());
                break;
            }
            case PROPERTIES: {
                result = new PropertiesDisplay(simulator);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        result.buildDisplay();
        result.installListeners();
        return result;
    }

    public static class ListPanel
    extends JPanel {
        private final JComponent list;
        private final JScrollPane scrollPane;
        private final DisplayKind kind;

        public ListPanel(JComponent list, JToolBar toolBar, DisplayKind kind) {
            super(new BorderLayout(), false);
            this.kind = kind;
            this.list = list;
            this.scrollPane = new JScrollPane(list){

                @Override
                public Dimension getPreferredSize() {
                    Dimension superSize = super.getPreferredSize();
                    return new Dimension((int)superSize.getWidth(), 130);
                }
            };
            this.scrollPane.setBackground(list.getBackground());
            if (toolBar != null) {
                this.add((Component)toolBar, "North");
            }
            this.add((Component)this.scrollPane, "Center");
        }

        public DisplayKind getDisplayKind() {
            return this.kind;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.scrollPane.getViewport().setBackground(this.list.getBackground());
        }
    }
}

