/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.model.ResourceKind;
import groove.graph.GraphRole;
import groove.gui.Icons;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.ImageIcon;

public enum DisplayKind {
    HOST(ResourceKind.HOST, Icons.GRAPH_FRAME_ICON, "Graphs", "Current graph state"),
    RULE(ResourceKind.RULE, Icons.RULE_FRAME_ICON, "Rules", "Selected rule"),
    TYPE(ResourceKind.TYPE, Icons.TYPE_FRAME_ICON, "Types", "Type graphs"),
    CONTROL(ResourceKind.CONTROL, Icons.CONTROL_FRAME_ICON, "Control", "Control specifications"),
    PROLOG(ResourceKind.PROLOG, Icons.PROLOG_FRAME_ICON, "Prolog", "Prolog programs"),
    GROOVY(ResourceKind.GROOVY, Icons.GROOVY_FRAME_ICON, "Groovy", "Groovy scripts"),
    STATE(null, Icons.STATE_FRAME_ICON, "State", "State panel"),
    LTS(null, Icons.LTS_FRAME_ICON, "Simulation", "Simulation panel"),
    PROPERTIES(null, Icons.PROPERTIES_FRAME_ICON, "Properties", "System properties");

    private final ResourceKind resource;
    private final ImageIcon tabIcon;
    private final String title;
    private final String tip;
    private static final Map<ResourceKind, DisplayKind> resourceMap;

    static {
        resourceMap = new EnumMap<ResourceKind, DisplayKind>(ResourceKind.class);
        DisplayKind[] displayKindArray = DisplayKind.values();
        int n = displayKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayKind kind = displayKindArray[n2];
            if (kind.hasResource()) {
                resourceMap.put(kind.getResource(), kind);
            }
            ++n2;
        }
    }

    private DisplayKind(ResourceKind resource, ImageIcon tabIcon, String title, String tip) {
        this.resource = resource;
        this.tabIcon = tabIcon;
        this.title = title;
        this.tip = tip;
    }

    public final ImageIcon getTabIcon() {
        return this.tabIcon;
    }

    public final ResourceKind getResource() {
        return this.resource;
    }

    public final boolean hasResource() {
        return this.getResource() != null;
    }

    public final boolean showDisplay() {
        return this != PROPERTIES;
    }

    public final int getListPanel() {
        int result;
        switch (this) {
            case RULE: 
            case STATE: 
            case PROPERTIES: {
                result = 0;
                break;
            }
            case HOST: 
            case TYPE: 
            case CONTROL: 
            case PROLOG: 
            case GROOVY: {
                result = 1;
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getTip() {
        return this.tip;
    }

    public final GraphRole getGraphRole() {
        return GraphRole.valueOf(this.name());
    }

    public final boolean isGraphBased() {
        return this == HOST || this == RULE || this == LTS || this == STATE || this == TYPE;
    }

    public static final DisplayKind toDisplay(ResourceKind resource) {
        return resourceMap.get((Object)resource);
    }
}

