/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectNode;
import groove.grammar.aspect.GraphConverter;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostGraphMorphism;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.HostModel;
import groove.grammar.rule.RuleNode;
import groove.graph.Edge;
import groove.graph.Node;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.display.Display;
import groove.gui.display.DisplayKind;
import groove.gui.display.JGraphPanel;
import groove.gui.display.TitledPanel;
import groove.gui.jgraph.AJCell;
import groove.gui.jgraph.AJVertex;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.jgraph.AspectJVertex;
import groove.gui.jgraph.JAttr;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.list.ErrorListPanel;
import groove.gui.look.LineStyle;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import groove.gui.tree.StateTree;
import groove.gui.tree.TypeTree;
import groove.io.HTMLConverter;
import groove.lts.GTS;
import groove.lts.GraphNextState;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.MatchResult;
import groove.lts.RecipeTransition;
import groove.lts.RuleTransition;
import groove.lts.StartGraphState;
import groove.transform.Proof;
import groove.transform.RuleApplication;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.GraphModel;

public class StateDisplay
extends Display
implements SimulatorListener {
    private JSplitPane displayPanel;
    private JGraphPanel<AspectGraph> stateGraphPanel;
    private ErrorListPanel errorPanel;
    private AspectJGraph jGraph;
    private TypeTree labelTree;
    private final Map<GraphState, AspectJModel> stateToJModel = new WeakHashMap<GraphState, AspectJModel>();
    private final Map<GraphState, GraphConverter.HostToAspectMap> stateToAspectMap = new WeakHashMap<GraphState, GraphConverter.HostToAspectMap>();
    private boolean listening;
    private GraphSelectionListener graphSelectionListener;
    private boolean matchSelected;

    public StateDisplay(Simulator simulator) {
        super(simulator, DisplayKind.STATE);
    }

    @Override
    protected void buildDisplay() {
        JToolBar toolBar = Options.createToolBar();
        this.fillToolBar(toolBar);
        this.add((Component)toolBar, "North");
        this.add(this.getDisplayPanel());
    }

    @Override
    protected JTree createList() {
        return new StateTree(this.getSimulator());
    }

    @Override
    protected JToolBar createListToolBar() {
        JToolBar result = Options.createToolBar();
        result.add(this.getActions().getEditStateAction());
        result.add(this.getActions().getSaveStateAction());
        result.addSeparator();
        result.add(this.getActions().getBackAction());
        result.add(this.getActions().getForwardAction());
        return result;
    }

    @Override
    protected JComponent createInfoPanel() {
        TypeTree labelTree = this.getLabelTree();
        TitledPanel result = new TitledPanel("Labels", labelTree, labelTree.createToolBar(), true);
        result.setEnabledBackground(JAttr.STATE_BACKGROUND);
        return result;
    }

    @Override
    protected void installListeners() {
        this.graphSelectionListener = new GraphSelectionListener(){

            public void valueChanged(GraphSelectionEvent e) {
                if (StateDisplay.this.matchSelected) {
                    boolean removed = false;
                    Object[] cells = e.getCells();
                    int i = 0;
                    while (!removed && i < cells.length) {
                        removed = !e.isAddedCell(i);
                        ++i;
                    }
                    if (removed) {
                        StateDisplay.this.clearSelectedMatch(false);
                    }
                }
            }
        };
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.GRAMMAR, SimulatorModel.Change.GTS, SimulatorModel.Change.STATE, SimulatorModel.Change.MATCH);
        this.activateListening();
    }

    private void activateListening() {
        if (this.listening) {
            throw new IllegalStateException();
        }
        this.getJGraph().addGraphSelectionListener(this.graphSelectionListener);
        this.listening = true;
    }

    private boolean suspendListening() {
        boolean result = this.listening;
        if (result) {
            this.getJGraph().removeGraphSelectionListener(this.graphSelectionListener);
            this.listening = false;
        }
        return result;
    }

    private void fillToolBar(JToolBar result) {
        result.removeAll();
        result.add(this.getActions().getExplorationDialogAction());
        result.addSeparator();
        result.add(this.getActions().getStartSimulationAction());
        result.add(this.getActions().getApplyMatchAction());
        result.add(this.getActions().getAnimateAction());
        result.add(this.getActions().getExploreAction());
        result.addSeparator();
        result.add(this.getActions().getBackAction());
        result.add(this.getActions().getForwardAction());
    }

    private JSplitPane getDisplayPanel() {
        JSplitPane result = this.displayPanel;
        if (result == null) {
            this.displayPanel = result = new JSplitPane(0);
            result.setTopComponent(this.getGraphPanel());
            result.setBottomComponent(this.getErrorPanel());
            result.setDividerSize(0);
            result.setContinuousLayout(true);
            result.setResizeWeight(0.9);
            result.resetToPreferredSizes();
            result.setBorder(null);
        }
        return result;
    }

    public AspectGraph getStateGraph() {
        return this.getJGraph().getModel().getGraph();
    }

    public JGraphPanel<AspectGraph> getGraphPanel() {
        JGraphPanel<AspectGraph> result = this.stateGraphPanel;
        if (result == null) {
            result = this.stateGraphPanel = new JGraphPanel<AspectGraph>((JGraph)this.getJGraph()){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    StateDisplay.this.getInfoPanel().setEnabled(enabled);
                }
            };
            result.initialise();
            result.setBorder(null);
            result.setEnabledBackground(JAttr.STATE_BACKGROUND);
            result.getJGraph().setToolTipEnabled(true);
        }
        return result;
    }

    private ErrorListPanel getErrorPanel() {
        if (this.errorPanel == null) {
            this.errorPanel = new ErrorListPanel("Errors in state graph");
            this.errorPanel.addSelectionListener(this.createErrorListener());
        }
        return this.errorPanel;
    }

    public final AspectJGraph getJGraph() {
        AspectJGraph result = this.jGraph;
        if (result == null) {
            result = this.jGraph = new AspectJGraph(this.getSimulator(), this.getKind(), false);
            result.setLabelTree(this.getLabelTree());
        }
        return result;
    }

    private TypeTree getLabelTree() {
        TypeTree result = this.labelTree;
        if (result == null) {
            result = this.labelTree = new TypeTree(this.getJGraph(), true);
        }
        return result;
    }

    private Observer createErrorListener() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AspectJCell errorCell;
                if (arg != null && (errorCell = StateDisplay.this.getJGraph().getModel().getErrorMap().get(arg)) != null) {
                    StateDisplay.this.getJGraph().setSelectionCell(errorCell);
                }
            }
        };
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        boolean transferLayout;
        if (!this.suspendListening()) {
            return;
        }
        GraphTransition oldTtrans = oldModel.getTransition();
        boolean bl = transferLayout = oldTtrans != null && oldTtrans != source.getTransition() && oldTtrans.target() == source.getState();
        if (changes.contains((Object)SimulatorModel.Change.GTS) && source.getGts() != oldModel.getGts()) {
            this.startSimulation(source.getGts());
        } else if (changes.contains((Object)SimulatorModel.Change.STATE)) {
            GraphState newState = source.getState();
            if (newState != null) {
                this.clearSelectedMatch(true);
            } else if (transferLayout) {
                this.transferLayout(oldTtrans);
                transferLayout = false;
            }
            this.displayState(newState);
        }
        if (changes.contains((Object)SimulatorModel.Change.MATCH)) {
            if (transferLayout) {
                this.transferLayout(oldTtrans);
            }
            if (source.getMatch() == null) {
                this.clearSelectedMatch(true);
            } else {
                this.selectMatch(source.getMatch().getEvent().getMatch(source.getState().getGraph()));
            }
            this.getJGraph().refreshAllCells();
        }
        this.updateStatus();
        this.activateListening();
    }

    private void startSimulation(GTS gts) {
        this.stateToJModel.clear();
        this.stateToAspectMap.clear();
        this.displayState(this.getSimulatorModel().getState());
    }

    private void selectMatch(Proof match) {
        AspectJCell jCell;
        assert (match != null) : "Match update should not be called with empty match";
        this.displayState(this.getSimulatorModel().getState());
        AspectJModel jModel = this.getJGraph().getModel();
        GraphConverter.HostToAspectMap aspectMap = this.getAspectMap(this.getSimulatorModel().getState());
        HashSet<AspectJVertex> emphElems = new HashSet<AspectJVertex>();
        for (HostNode matchedNode : match.getNodeValues()) {
            jCell = jModel.getJCellForNode((Node)aspectMap.getNode(matchedNode));
            if (jCell == null) continue;
            emphElems.add((AspectJVertex)jCell);
        }
        for (HostEdge matchedEdge : match.getEdgeValues()) {
            jCell = jModel.getJCellForEdge((Edge)aspectMap.getEdge(matchedEdge));
            if (jCell == null) continue;
            emphElems.add((AspectJVertex)jCell);
        }
        this.getJGraph().setSelectionCells(emphElems.toArray());
        this.matchSelected = true;
    }

    private void updateStatus() {
        StringBuilder result = new StringBuilder();
        result.append("Current state");
        if (this.getSimulatorModel().getState() != null) {
            MatchResult match;
            HostModel startGraph;
            result.append(": ");
            String stateID = this.getSimulatorModel().getState().toString();
            result.append(HTMLConverter.STRONG_TAG.on(stateID));
            if (stateID.equals("s0") && (startGraph = this.getSimulatorModel().getGrammar().getStartGraphModel()) != null) {
                result.append("=");
                result.append(startGraph.getLastName());
            }
            if ((match = this.getSimulatorModel().getMatch()) != null) {
                if (this.getJGraph().isShowAnchors()) {
                    result.append(String.format(" (with match %s)", match.getEvent()));
                } else {
                    result.append(String.format(" (with match of %s)", match.getEvent().getRule().getFullName()));
                }
            }
        }
        this.getGraphPanel().getStatusLabel().setText(HTMLConverter.HTML_TAG.on(result).toString());
    }

    public void displayState(GraphState state) {
        this.clearSelectedMatch(true);
        FormatErrorSet errors = null;
        if (state == null) {
            this.getJGraph().setModel(null);
        } else {
            AspectJModel model = this.getAspectJModel(state);
            this.getJGraph().setModel((GraphModel)model);
            errors = model.getResourceModel().getErrors();
        }
        if (state != null && state.isError()) {
            this.getErrorPanel().setEntries(errors);
            this.getDisplayPanel().setBottomComponent(this.getErrorPanel());
            this.getDisplayPanel().resetToPreferredSizes();
        } else {
            this.getErrorPanel().clearEntries();
            this.getDisplayPanel().remove(this.getErrorPanel());
        }
    }

    private boolean clearSelectedMatch(boolean clear) {
        boolean result;
        boolean bl = result = this.listening && this.matchSelected;
        if (result) {
            this.matchSelected = false;
            if (clear) {
                this.getJGraph().clearSelection();
            }
            this.getSimulatorModel().setMatch(this.getSimulatorModel().getState(), null);
            this.updateStatus();
        }
        return result;
    }

    private AspectJModel getAspectJModel(GraphState state) {
        GraphConverter.HostToAspectMap aspectMap = this.getAspectMap(state);
        AspectGraph aspectGraph = aspectMap.getAspectGraph();
        AspectJModel result = this.stateToJModel.get(state);
        if (result == null) {
            result = this.createAspectJModel(aspectGraph);
            assert (result != null);
            this.stateToJModel.put(state, result);
            if (state instanceof GraphNextState) {
                this.setNextStateLayout((GraphNextState)state, result);
            } else {
                assert (state instanceof StartGraphState);
                this.setStartGraphLayout(result);
            }
        }
        return result;
    }

    private void setNextStateLayout(GraphNextState state, AspectJModel result) {
        GraphTransition trans;
        Stack<GraphTransition> stack = new Stack<GraphTransition>();
        GraphState source = state;
        do {
            trans = source;
            stack.push(trans);
        } while ((source = trans.source()) instanceof GraphNextState && !this.stateToJModel.containsKey(source));
        AspectJModel model = this.getAspectJModel(source);
        AttributesMap map = this.extractAttributes(model, this.getAspectMap(source));
        while (!stack.isEmpty()) {
            GraphTransition trans2 = (GraphTransition)stack.pop();
            map = this.transferAttributes(map, trans2);
        }
        this.applyAttributes(map, result, this.getAspectMap(state));
    }

    private AttributesMap extractAttributes(AspectJModel model, GraphConverter.HostToAspectMap aspectMap) {
        AspectJCell jCell;
        AttributesMap result = new AttributesMap();
        for (Map.Entry entry : aspectMap.nodeMap().entrySet()) {
            AspectNode aspectNode = (AspectNode)entry.getValue();
            jCell = model.getJCellForNode(aspectNode);
            assert (jCell != null) : "Source element " + aspectNode + " unknown";
            result.nodeMap.put((HostNode)entry.getKey(), new Attributes((AspectJVertex)jCell));
        }
        for (Map.Entry<Object, Object> entry : aspectMap.edgeMap().entrySet()) {
            AspectEdge aspectEdge = (AspectEdge)entry.getValue();
            jCell = model.getJCellForEdge(aspectEdge);
            if (!(jCell instanceof AspectJEdge)) continue;
            result.edgeMap.put((HostEdge)entry.getKey(), new Attributes((AspectJEdge)jCell));
        }
        return result;
    }

    private AttributesMap transferAttributes(AttributesMap map, GraphTransition trans) {
        Attributes attr;
        AttributesMap result = new AttributesMap();
        HostGraphMorphism morphism = trans.getMorphism();
        Map<HostNode, Attributes> sourceNodeMap = map.nodeMap;
        Map<HostNode, Attributes> resultNodeMap = result.nodeMap;
        Map<HostNode, Color> newColorMap = this.extractNewColors(trans);
        HostNodeSet newNodes = new HostNodeSet(trans.target().getGraph().nodeSet());
        for (Map.Entry entry : morphism.nodeMap().entrySet()) {
            HostNode sourceNode = (HostNode)entry.getKey();
            attr = sourceNodeMap.get(sourceNode);
            HostNode targetNode = (HostNode)entry.getValue();
            assert (trans.target().getGraph().containsNode(targetNode));
            Color newColor = newColorMap.get(targetNode);
            if (newColor != null) {
                if (attr == null) {
                    attr = new Attributes(newColor);
                } else {
                    attr.color = newColor;
                }
            }
            if (attr != null) {
                resultNodeMap.put(targetNode, attr);
            }
            newNodes.remove(targetNode);
        }
        for (HostNode newNode : newNodes) {
            Color newColor = newColorMap.get(newNode);
            if (newColor == null) continue;
            attr = new Attributes(newColor);
            resultNodeMap.put(newNode, attr);
        }
        Map<HostEdge, Attributes> sourceEdgeMap = map.edgeMap;
        Map<HostEdge, Attributes> resultEdgeMap = result.edgeMap;
        for (Map.Entry entry : morphism.edgeMap().entrySet()) {
            HostEdge sourceEdge = (HostEdge)entry.getKey();
            Attributes attr2 = sourceEdgeMap.get(sourceEdge);
            if (attr2 == null) continue;
            HostEdge targetEdge = (HostEdge)entry.getValue();
            resultEdgeMap.put(targetEdge, attr2);
        }
        return result;
    }

    private void applyAttributes(AttributesMap map, AspectJModel result, GraphConverter.HostToAspectMap aspectMap) {
        AspectJCell jCell;
        result.setLayoutable(true);
        for (Map.Entry<HostNode, Attributes> entry : map.nodeMap.entrySet()) {
            AspectNode aspectNode = (AspectNode)aspectMap.getNode(entry.getKey());
            assert (aspectNode != null) : "Target element " + entry.getKey() + " unknown";
            jCell = result.getJCellForNode(aspectNode);
            assert (jCell != null) : "Target element " + aspectNode + " unknown";
            Attributes attrs = entry.getValue();
            ((AJCell)((Object)jCell)).putVisuals(attrs.toVisuals());
            ((AJCell)((Object)jCell)).setGrayedOut(attrs.grayedOut);
            ((AJCell)((Object)jCell)).setLayoutable(attrs.pos == null);
            result.synchroniseLayout(jCell);
            if (attrs.color == null) continue;
            for (JEdge jEdge : ((AJVertex)((Object)jCell)).getContext()) {
                if (jEdge.getSourceVertex() != jCell) continue;
                jEdge.putVisual(VisualKey.COLOR, attrs.color);
            }
        }
        for (Map.Entry<HostElement, Attributes> entry : map.edgeMap.entrySet()) {
            AspectEdge aspectEdge = (AspectEdge)aspectMap.getEdge((Edge)((Object)entry.getKey()));
            assert (aspectEdge != null) : "Target element " + entry.getKey() + " unknown";
            jCell = result.getJCellForEdge(aspectEdge);
            if (jCell instanceof AspectJVertex) continue;
            assert (jCell != null) : "Target element " + aspectEdge + " unknown";
            Attributes attr = entry.getValue();
            jCell.putVisuals(attr.toVisuals());
            jCell.setGrayedOut(attr.grayedOut);
            jCell.setLayoutable(attr.points == null);
            result.synchroniseLayout(jCell);
        }
    }

    private void transferLayout(GraphTransition trans) {
        AttributesMap map = this.extractAttributes(this.stateToJModel.get(trans.source()), this.getAspectMap(trans.source()));
        map = this.transferAttributes(map, trans);
        this.applyAttributes(map, this.stateToJModel.get(trans.target()), this.getAspectMap(trans.target()));
    }

    private Map<HostNode, Color> extractNewColors(GraphTransition trans) {
        Map<HostNode, Color> result = new HashMap<HostNode, Color>();
        if (trans instanceof RuleTransition) {
            result = this.transferColors(result, (RuleTransition)trans);
        } else {
            for (RuleTransition ruleTrans : ((RecipeTransition)trans).getPath()) {
                result = this.transferColors(result, ruleTrans);
            }
        }
        return result;
    }

    private Map<HostNode, Color> transferColors(Map<HostNode, Color> colorMap, RuleTransition trans) {
        HashMap<HostNode, Color> result = new HashMap<HostNode, Color>();
        RuleApplication application = trans.createRuleApplication();
        Map<RuleNode, HostNodeSet> comatch = application.getComatch();
        for (Map.Entry<RuleNode, Color> colorEntry : application.getRule().getColorMap().entrySet()) {
            HostNodeSet matches = comatch.get(colorEntry.getKey());
            if (matches == null) continue;
            for (HostNode hostNode : matches) {
                result.put(hostNode, colorEntry.getValue());
            }
        }
        HostGraphMorphism morphism = trans.getMorphism();
        for (Map.Entry<HostNode, Color> colorEntry : colorMap.entrySet()) {
            HostNode newNode = (HostNode)morphism.getNode(colorEntry.getKey());
            if (result.containsKey(newNode)) continue;
            result.put(newNode, colorEntry.getValue());
        }
        return result;
    }

    private void setStartGraphLayout(AspectJModel result) {
        AspectGraph startGraph = this.getGrammar().getStartGraphModel().getSource();
        AspectJModel startModel = this.createAspectJModel(startGraph);
        for (AspectNode node : startGraph.nodeSet()) {
            AspectJVertex stateVertex = result.getJCellForNode(node);
            if (stateVertex == null) continue;
            AspectJVertex graphVertex = startModel.getJCellForNode(node);
            stateVertex.putVisuals(graphVertex.getVisuals());
            stateVertex.setGrayedOut(graphVertex.isGrayedOut());
            result.synchroniseLayout(stateVertex);
            stateVertex.setLayoutable(false);
        }
        for (AspectEdge edge : startGraph.edgeSet()) {
            AspectJCell stateEdge = result.getJCellForEdge(edge);
            if (stateEdge == null) continue;
            AspectJCell graphEdge = startModel.getJCellForEdge(edge);
            stateEdge.putVisuals(graphEdge.getVisuals());
            stateEdge.setGrayedOut(graphEdge.isGrayedOut());
            result.synchroniseLayout(stateEdge);
            stateEdge.setLayoutable(false);
        }
    }

    private AspectJModel createAspectJModel(AspectGraph graph) {
        AspectJModel result = this.getJGraph().newModel();
        result.loadGraph(graph);
        return result;
    }

    private GrammarModel getGrammar() {
        return this.getSimulatorModel().getGrammar();
    }

    private GraphConverter.HostToAspectMap getAspectMap(GraphState state) {
        GraphConverter.HostToAspectMap result = this.stateToAspectMap.get(state);
        if (result == null) {
            result = GraphConverter.toAspectMap(state.getGraph());
            this.stateToAspectMap.put(state, result);
        }
        return result;
    }

    private static class Attributes {
        final Point2D pos;
        Color color;
        final boolean grayedOut;
        final List<Point2D> points;
        final Point2D labelPosition;
        final LineStyle lineStyle;

        Attributes(AspectJVertex jVertex) {
            VisualMap visuals = jVertex.getVisuals();
            this.pos = visuals.getNodePos();
            this.grayedOut = jVertex.isGrayedOut();
            this.color = visuals.getColor();
            this.points = null;
            this.labelPosition = null;
            this.lineStyle = null;
        }

        Attributes(Color color) {
            this.pos = null;
            this.grayedOut = false;
            this.color = color;
            this.points = null;
            this.labelPosition = null;
            this.lineStyle = LineStyle.DEFAULT_VALUE;
        }

        Attributes(AspectJEdge jEdge) {
            VisualMap visuals = jEdge.getVisuals();
            this.pos = null;
            this.grayedOut = jEdge.isGrayedOut();
            this.color = null;
            this.points = visuals.getPoints();
            this.labelPosition = visuals.getLabelPos();
            this.lineStyle = visuals.getLineStyle();
        }

        VisualMap toVisuals() {
            VisualMap result = new VisualMap();
            if (this.pos != null) {
                result.setNodePos(this.pos);
            }
            if (this.color != null) {
                result.setColor(this.color);
            }
            if (this.points != null) {
                result.setPoints(this.points);
            }
            if (this.labelPosition != null) {
                result.setLabelPos(this.labelPosition);
            }
            if (this.lineStyle != null) {
                result.setLineStyle(this.lineStyle);
            }
            return result;
        }
    }

    private static class AttributesMap {
        final Map<HostNode, Attributes> nodeMap = new HashMap<HostNode, Attributes>();
        final Map<HostEdge, Attributes> edgeMap = new HashMap<HostEdge, Attributes>();

        private AttributesMap() {
        }
    }
}

