/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Node;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJCellErrors;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JModel;
import groove.gui.layout.JEdgeLayout;
import groove.gui.layout.JVertexLayout;
import groove.gui.look.Look;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import groove.gui.look.VisualValue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;

public abstract class AJCell<G extends Graph, JG extends JGraph<G>, JM extends JModel<G>>
extends DefaultGraphCell
implements JCell<G> {
    private JM jModel;
    private Set<Edge> edges;
    private Set<Look> looks;
    private boolean looksChanged;
    private VisualMap visuals;
    private Set<VisualKey> staleKeys;
    private boolean layoutable;
    private AspectJCellErrors errors;

    protected AJCell() {
    }

    public JG getJGraph() {
        return (JG)((Object)(this.getJModel() == null ? null : ((JModel)((Object)this.getJModel())).getJGraph()));
    }

    @Override
    public void setJModel(JModel<G> jModel) {
        this.jModel = jModel;
        this.initialise();
    }

    public JM getJModel() {
        return this.jModel;
    }

    protected final JVertexLayout getLayout(Node node) {
        return ((JModel)((Object)this.getJModel())).getLayoutMap().getLayout(node);
    }

    protected final JEdgeLayout getLayout(Edge edge) {
        return ((JModel)((Object)this.getJModel())).getLayoutMap().getLayout(edge);
    }

    protected void initialise() {
        this.edges = null;
        this.looks = null;
        VisualMap oldVisuals = this.visuals;
        this.visuals = new VisualMap();
        if (oldVisuals != null) {
            this.visuals.putAll(oldVisuals);
        }
        this.looksChanged = true;
        this.staleKeys = EnumSet.noneOf(VisualKey.class);
        this.staleKeys.addAll(Arrays.asList(VisualKey.refreshables()));
        this.errors = null;
    }

    @Override
    public void addEdge(Edge edge) {
        Set<Edge> edges = this.getEdges();
        edges.remove(edge);
        edges.add(edge);
    }

    @Override
    public Set<? extends Edge> getEdges() {
        if (this.edges == null) {
            this.edges = this.createEdgeSet();
        }
        return this.edges;
    }

    @Override
    public boolean setLook(Look look, boolean set) {
        boolean change;
        assert (!look.isStructural());
        boolean bl = change = set ? this.getLooks().add(look) : this.getLooks().remove((Object)look);
        if (change) {
            this.looksChanged = true;
        }
        return change;
    }

    @Override
    public final Set<Look> getLooks() {
        if (this.looks == null) {
            this.looks = EnumSet.noneOf(Look.class);
            Look structuralLook = this.getStructuralLook();
            assert (structuralLook.isStructural());
            this.looks.add(structuralLook);
            this.looksChanged = true;
        }
        return this.looks;
    }

    protected Look getStructuralLook() {
        return Look.BASIC;
    }

    @Override
    public final void putVisual(VisualKey key, Object value) {
        assert (key.getNature() != VisualKey.Nature.DERIVED);
        this.visuals.put(key, value);
        this.staleKeys.remove((Object)key);
    }

    @Override
    public final void putVisuals(VisualMap map) {
        for (VisualKey key : map.keySet()) {
            if (key.getNature() == VisualKey.Nature.DERIVED) continue;
            this.putVisual(key, map.get(key));
        }
    }

    protected final void refreshVisual(VisualKey key) {
        VisualValue<?> refresher = this.getRefresher(key);
        if (refresher != null) {
            this.visuals.put(key, refresher.get(this));
            this.staleKeys.remove((Object)key);
        }
    }

    @Override
    public final VisualMap getVisuals() {
        if (this.looksChanged || this.looks == null) {
            this.visuals.setLooks(this.getLooks());
            this.looksChanged = false;
        }
        if (!this.staleKeys.isEmpty()) {
            VisualKey[] visualKeyArray = VisualKey.refreshables();
            int n = visualKeyArray.length;
            int n2 = 0;
            while (n2 < n) {
                VisualKey key = visualKeyArray[n2];
                if (this.staleKeys.contains((Object)key)) {
                    this.refreshVisual(key);
                }
                ++n2;
            }
        }
        return this.visuals;
    }

    protected final VisualValue<?> getRefresher(VisualKey key) {
        JG jGraph = this.getJGraph();
        return jGraph == null ? null : ((JGraph)((Object)jGraph)).getVisualValue(key);
    }

    @Override
    public void setStale(VisualKey ... keys) {
        VisualKey[] visualKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            VisualKey key = visualKeyArray[n2];
            assert (key.getNature() == VisualKey.Nature.REFRESHABLE);
            this.staleKeys.add(key);
            ++n2;
        }
    }

    @Override
    public boolean isStale(VisualKey key) {
        return this.staleKeys.contains((Object)key);
    }

    @Override
    public final boolean isLayoutable() {
        return this.layoutable;
    }

    @Override
    public final boolean setLayoutable(boolean layedOut) {
        boolean result = layedOut ^ this.layoutable;
        if (result) {
            this.layoutable = layedOut;
        }
        return result;
    }

    @Override
    public final boolean isGrayedOut() {
        return this.getLooks().contains((Object)Look.GRAYED_OUT);
    }

    @Override
    public final boolean setGrayedOut(boolean grayedOut) {
        return this.setLook(Look.GRAYED_OUT, grayedOut);
    }

    @Override
    public boolean hasErrors() {
        boolean result = false;
        if (this.errors != null) {
            result = !this.errors.isEmpty();
        }
        return result;
    }

    @Override
    public AspectJCellErrors getErrors() {
        if (this.errors == null) {
            this.errors = new AspectJCellErrors((AspectJCell)((Object)this));
        }
        return this.errors;
    }

    public AttributeMap getAttributes() {
        return this.getVisuals().getAttributes();
    }

    protected <E extends Edge> Set<E> createEdgeSet() {
        return new TreeSet(new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                int result = o1.label().compareTo(o2.label());
                if (result == 0 && (result = o1.source().getNumber() - o2.source().getNumber()) == 0) {
                    result = o1.target().getNumber() - o2.target().getNumber();
                }
                return result;
            }
        });
    }
}

