/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.control.CtrlAut;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.graph.Edge;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.gui.Simulator;
import groove.gui.jgraph.CtrlJEdge;
import groove.gui.jgraph.CtrlJVertex;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JGraphFactory;
import groove.gui.jgraph.JModel;
import groove.gui.layout.ForestLayouter;
import groove.gui.layout.Layouter;
import groove.gui.layout.SpringLayouter;
import groove.gui.menu.SetLayoutMenu;
import java.util.Collection;
import java.util.Collections;
import org.jgraph.graph.GraphModel;

public class CtrlJGraph
extends JGraph<CtrlAut> {
    public CtrlJGraph(Simulator simulator) {
        super(simulator);
        this.getGraphLayoutCache().setSelectsAllInsertedCells(false);
        this.getSetLayoutMenu().selectLayoutAction(this.createInitialLayouter().newInstance(this));
        this.setConnectable(false);
        this.setDisconnectable(false);
        this.setEnabled(true);
        this.setToolTipEnabled(true);
    }

    @Override
    public GraphRole getGraphRole() {
        return GraphRole.CTRL;
    }

    public void setModel(CtrlAut aut) {
        if (this.getModel() == null || this.getModel().getGraph() != aut) {
            JModel<CtrlAut> newModel = this.newModel();
            newModel.loadGraph(aut);
            this.setModel((GraphModel)newModel);
        }
    }

    @Override
    public boolean isShowNodeIdentities() {
        return true;
    }

    @Override
    public boolean isShowLoopsAsNodeLabels() {
        return false;
    }

    protected Layouter createInitialLayouter() {
        return new MyForestLayouter();
    }

    @Override
    public SetLayoutMenu createSetLayoutMenu() {
        SetLayoutMenu result = new SetLayoutMenu(this, new SpringLayouter());
        result.addLayoutItem(this.createInitialLayouter());
        return result;
    }

    @Override
    protected JGraphFactory<CtrlAut> createFactory() {
        return new MyFactory();
    }

    private class MyFactory
    extends JGraphFactory<CtrlAut> {
        public MyFactory() {
            super(CtrlJGraph.this);
        }

        public CtrlJVertex newJVertex(Node node) {
            assert (node instanceof CtrlState);
            return CtrlJVertex.newInstance();
        }

        public CtrlJEdge newJEdge(Edge edge) {
            assert (edge instanceof CtrlTransition);
            return CtrlJEdge.newInstance();
        }
    }

    private class MyForestLayouter
    extends ForestLayouter {
        public MyForestLayouter() {
        }

        public MyForestLayouter(String name, CtrlJGraph jgraph) {
            super(name, jgraph);
        }

        @Override
        protected Collection<?> getSuggestedRoots() {
            CtrlState start = ((CtrlAut)CtrlJGraph.this.getModel().getGraph()).getStart();
            return Collections.singleton(CtrlJGraph.this.getModel().getJCellForNode(start));
        }

        @Override
        public Layouter newInstance(JGraph<?> jGraph) {
            return new MyForestLayouter(this.getName(), (CtrlJGraph)jGraph);
        }
    }
}

