/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Node;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JModel;
import groove.gui.jgraph.JVertex;
import groove.gui.look.AdornmentValue;
import groove.gui.look.ColorValue;
import groove.gui.look.EdgeEndLabelValue;
import groove.gui.look.EdgeEndShapeValue;
import groove.gui.look.ErrorValue;
import groove.gui.look.LabelValue;
import groove.gui.look.VisibleValue;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualValue;

public abstract class JGraphFactory<G extends Graph> {
    private final JGraph<G> jGraph;

    public JGraphFactory(JGraph<G> jGraph) {
        this.jGraph = jGraph;
    }

    public JGraph<G> getJGraph() {
        return this.jGraph;
    }

    public abstract JVertex<G> newJVertex(Node var1);

    public abstract JEdge<G> newJEdge(Edge var1);

    public JModel<G> newModel() {
        return new JModel<G>(this.getJGraph()){};
    }

    public VisualValue<?> newVisualValue(VisualKey key) {
        switch (key) {
            case ADORNMENT: {
                return new AdornmentValue();
            }
            case COLOR: {
                return new ColorValue();
            }
            case EDGE_SOURCE_LABEL: {
                return new EdgeEndLabelValue(true);
            }
            case EDGE_SOURCE_SHAPE: {
                return new EdgeEndShapeValue(true);
            }
            case EDGE_TARGET_LABEL: {
                return new EdgeEndLabelValue(false);
            }
            case EDGE_TARGET_SHAPE: {
                return new EdgeEndShapeValue(false);
            }
            case ERROR: {
                return new ErrorValue();
            }
            case LABEL: {
                return new LabelValue(this.jGraph);
            }
            case NODE_SIZE: {
                return null;
            }
            case VISIBLE: {
                return new VisibleValue();
            }
        }
        assert (false);
        return null;
    }
}

