/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.gui.Options;
import groove.gui.jgraph.JAttr;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JVertex;
import groove.gui.jgraph.MultiLinedEditor;
import groove.gui.look.HTMLLineFormat;
import groove.gui.look.LineStyle;
import groove.gui.look.Look;
import groove.gui.look.MultiLabel;
import groove.gui.look.Values;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;

public class JVertexView
extends VertexView {
    private final JGraph<?> jGraph;
    private Color color;
    private MultiLabel label;
    private String text;
    private Insets insets;
    private boolean armed;
    private static final double DROP_FRACTION = 10.0;
    private static final double MAX_RATIO_DISTANCE = 250.0;
    private static final Insets DEFAULT_INSETS;
    private static final Insets EMPTY_INSETS;
    private static final MyRenderer renderer;
    private static final MultiLinedEditor editor;

    static {
        PortView.allowPortMagic = false;
        DEFAULT_INSETS = new Insets(2, 4, 2, 4);
        EMPTY_INSETS = new Insets(0, 0, 0, 0);
        renderer = new MyRenderer();
        editor = new MultiLinedEditor();
    }

    public JVertexView(JVertex<?> jNode, JGraph<?> jGraph) {
        super(jNode);
        this.jGraph = jGraph;
    }

    public JVertex<?> getCell() {
        return (JVertex)super.getCell();
    }

    public VisualMap getCellVisuals() {
        return this.getCell().getVisuals();
    }

    public MyRenderer getRenderer() {
        return renderer;
    }

    public GraphCellEditor getEditor() {
        return editor;
    }

    void setInsets(Insets insets) {
        this.insets = insets;
    }

    final Insets getInsets() {
        return this.insets;
    }

    final String getText() {
        MultiLabel label = this.getCellVisuals().getLabel();
        Color color = this.getCellVisuals().getForeground();
        if (label != this.label || color != this.color) {
            this.text = HTMLLineFormat.toHtml(label.toString(HTMLLineFormat.instance()), color);
            this.label = label;
            this.color = color;
        }
        return this.text;
    }

    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        Point2D result = null;
        Rectangle2D bounds = this.getAdornBounds();
        if (bounds == null || bounds.getMaxX() <= p.getX() || bounds.getMaxY() <= p.getY()) {
            bounds = this.getBounds();
            float extra = 6.0f - this.getCellVisuals().getLineWidth();
            bounds = new Rectangle2D.Double(bounds.getX() + (double)extra, bounds.getY() + (double)extra, bounds.getWidth() - (double)(2.0f * extra), bounds.getHeight() - (double)(2.0f * extra));
        }
        if (source == null) {
            boolean yAdjust;
            double xDrop = bounds.getWidth() / 10.0;
            double yDrop = bounds.getHeight() / 10.0;
            double minX = bounds.getMinX() + xDrop;
            double maxX = bounds.getMaxX() - xDrop;
            double minY = bounds.getMinY() + yDrop;
            double maxY = bounds.getMaxY() - yDrop;
            boolean xAdjust = p.getX() > minX && p.getX() < maxX;
            boolean bl = yAdjust = p.getY() > minY && p.getY() < maxY;
            if (xAdjust || yAdjust) {
                double x = xAdjust ? p.getX() : bounds.getCenterX();
                double y = yAdjust ? p.getY() : bounds.getCenterY();
                switch (this.getCellVisuals().getNodeShape()) {
                    case DIAMOND: {
                        result = this.getDiamondPerimeterPoint(bounds, x, y, p);
                        break;
                    }
                    case ROUNDED: 
                    case RECTANGLE: 
                    case OVAL: {
                        result = this.getRectanglePerimeterPoint(bounds, x, y, p);
                    }
                }
            }
        }
        if (result == null) {
            switch (this.getCellVisuals().getNodeShape()) {
                case ELLIPSE: {
                    result = this.getEllipsePerimeterPoint(bounds, p);
                    break;
                }
                case DIAMOND: {
                    result = this.getDiamondPerimeterPoint(bounds, p);
                    break;
                }
                default: {
                    result = this.getCellVisuals().getLineStyle() == LineStyle.MANHATTAN ? this.getRectanglePerimeterPoint(bounds, p, this == edge.getSource().getParentView()) : this.getRectanglePerimeterPoint(bounds, p);
                }
            }
        }
        return result;
    }

    private Rectangle2D getAdornBounds() {
        Rectangle2D result = null;
        String adornment = this.getCellVisuals().getAdornment();
        if (adornment != null) {
            result = this.getBounds();
            MyRenderer renderer = (MyRenderer)this.getRendererComponent(this.jGraph, false, false, false);
            result = new Rectangle2D.Double(result.getX(), result.getY(), renderer.adornWidth, renderer.adornHeight);
        }
        return result;
    }

    private Point2D getRectanglePerimeterPoint(Rectangle2D bounds, Point2D p) {
        double outY;
        double outX;
        double t;
        double pi;
        double xRadius = bounds.getWidth() / 2.0;
        double yRadius = bounds.getHeight() / 2.0;
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        double dx = p.getX() - centerX;
        double dy = p.getY() - centerY;
        double alpha = Math.atan2(dy, dx);
        if (alpha < -(pi = Math.PI) + (t = Math.atan2(yRadius, xRadius)) || alpha > pi - t) {
            outX = centerX - xRadius;
            outY = centerY - xRadius * Math.tan(alpha);
        } else if (alpha < -t) {
            outY = centerY - yRadius;
            outX = centerX - yRadius * Math.tan(pi / 2.0 - alpha);
        } else if (alpha < t) {
            outX = centerX + xRadius;
            outY = centerY + xRadius * Math.tan(alpha);
        } else {
            outY = centerY + yRadius;
            outX = centerX + yRadius * Math.tan(pi / 2.0 - alpha);
        }
        return new Point2D.Double(outX, outY);
    }

    private Point2D getRectanglePerimeterPoint(Rectangle2D bounds, Point2D p, boolean horizontal) {
        double outY;
        double outX;
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        double dx = p.getX() - centerX;
        double dy = p.getY() - centerY;
        if (horizontal) {
            outX = dx < 0.0 ? bounds.getMinX() : bounds.getMaxX();
            double room = bounds.getHeight() * 0.8 * 0.5;
            outY = centerY + room * Math.signum(dy) * Math.min(Math.abs(dy) / 250.0, 1.0);
        } else {
            outY = dy < 0.0 ? bounds.getMinY() : bounds.getMaxY();
            double room = bounds.getWidth() * 0.8 * 0.5;
            outX = centerX + room * Math.signum(dx) * Math.min(Math.abs(dx) / 250.0, 1.0);
        }
        return new Point2D.Double(outX, outY);
    }

    private Point2D getRectanglePerimeterPoint(Rectangle2D bounds, double fromX, double fromY, Point2D to) {
        double outY;
        double outX;
        double dx = to.getX() - fromX;
        double dy = to.getY() - fromY;
        if (dx < 0.0) {
            outX = bounds.getMinX();
            outY = fromY;
        } else if (dy < 0.0) {
            outX = fromX;
            outY = bounds.getMinY();
        } else if (dx > 0.0) {
            outX = bounds.getMaxX();
            outY = fromY;
        } else {
            outX = fromX;
            outY = bounds.getMaxY();
        }
        return new Point2D.Double(outX, outY);
    }

    private Point2D getEllipsePerimeterPoint(Rectangle2D bounds, Point2D p) {
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        double dx = p.getX() - centerX;
        double dy = p.getY() - centerY;
        double pDist = dx * dx + dy * dy;
        double xFrac = Math.sqrt(dx * dx / pDist) * bounds.getWidth() / 2.0;
        double yFrac = Math.sqrt(dy * dy / pDist) * bounds.getHeight() / 2.0;
        double outX = centerX + xFrac * Math.signum(dx);
        double outY = centerY + yFrac * Math.signum(dy);
        return new Point2D.Double(outX, outY);
    }

    private Point2D getDiamondPerimeterPoint(Rectangle2D bounds, Point2D to) {
        double endY;
        double endX;
        double startY;
        double startX;
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        double dx = to.getX() - centerX;
        double dy = to.getY() - centerY;
        if (dx <= 0.0 && dy <= 0.0) {
            startX = bounds.getMinX();
            startY = centerY;
            endX = centerX;
            endY = bounds.getMinY();
        } else if (dy <= 0.0) {
            startX = centerX;
            startY = bounds.getMinY();
            endX = bounds.getMaxX();
            endY = centerY;
        } else if (dx <= 0.0) {
            startX = bounds.getMinX();
            startY = centerY;
            endX = centerX;
            endY = bounds.getMaxY();
        } else {
            startX = centerX;
            startY = bounds.getMaxY();
            endX = bounds.getMaxX();
            endY = centerY;
        }
        return this.lineIntersection(centerX, centerY, dx, dy, startX, startY, endX - startX, endY - startY);
    }

    private Point2D getDiamondPerimeterPoint(Rectangle2D bounds, double fromX, double fromY, Point2D to) {
        double endY;
        double endX;
        double startY;
        double startX;
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        double toX = to.getX();
        double toY = to.getY();
        double dx = toX - fromX;
        double dy = toY - fromY;
        if (toX <= centerX && toY <= centerY) {
            startX = bounds.getMinX();
            startY = centerY;
            endX = centerX;
            endY = bounds.getMinY();
        } else if (toY <= centerY) {
            startX = centerX;
            startY = bounds.getMinY();
            endX = bounds.getMaxX();
            endY = centerY;
        } else if (toX <= centerX) {
            startX = bounds.getMinX();
            startY = centerY;
            endX = centerX;
            endY = bounds.getMaxY();
        } else {
            startX = centerX;
            startY = bounds.getMaxY();
            endX = bounds.getMaxX();
            endY = centerY;
        }
        return this.lineIntersection(fromX, fromY, dx, dy, startX, startY, endX - startX, endY - startY);
    }

    private Point2D lineIntersection(double x1, double y1, double dx1, double dy1, double x2, double y2, double dx2, double dy2) {
        double above = dx1 * (y2 - y1) - dy1 * (x2 - x1);
        double below = dx2 * dy1 - dx1 * dy2;
        if (below == 0.0) {
            return null;
        }
        double c2 = above / below;
        double x = x2 + dx2 * c2;
        double y = y2 + dy2 * c2;
        return new Point2D.Double(x, y);
    }

    public String toString() {
        return String.format("Vertex view for %s", this.getCell());
    }

    void paintArmed(Graphics g) {
        Graphics2D newG = (Graphics2D)g.create();
        double scale = this.jGraph.getScale();
        newG.scale(scale, scale);
        this.jGraph.getUI().paintCell(newG, (CellView)this, this.getBounds(), true);
        this.armed = true;
        this.jGraph.getUI().paintCell(newG, (CellView)this, this.getBounds(), true);
        this.armed = false;
        newG.dispose();
    }

    private static class MyRenderer
    extends JLabel
    implements CellViewRenderer {
        private JVertexView view;
        private JVertex<?> cell;
        private VisualMap visuals;
        private boolean nodeEdge;
        private Color selectionColor;
        private boolean selected;
        private Color lineColor;
        private float lineWidth;
        private float[] dash;
        private boolean twoLines = false;
        private Color line2color;
        private float[] line2dash;
        private float line2width;
        private boolean error;
        private String adornment;
        private int adornHeight;
        private int adornWidth;
        private final Map<String, Dimension> sizeMap = new HashMap<String, Dimension>();
        private final Map<String, Integer> adornWidthMap = new HashMap<String, Integer>();

        MyRenderer() {
            this.setMinimumSize(JAttr.DEFAULT_NODE_SIZE);
        }

        public MyRenderer getRendererComponent(org.jgraph.JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
            assert (view instanceof JVertexView) : String.format("This renderer is only meant for %s", JVertexView.class);
            this.view = (JVertexView)view;
            this.cell = this.view.getCell();
            VisualMap visuals = this.visuals = this.view.getCellVisuals();
            this.adornment = this.visuals.getAdornment();
            if (this.adornment == null) {
                this.adornHeight = 0;
                this.adornWidth = 0;
            } else {
                this.adornHeight = 12;
                this.adornWidth = this.getAdornWidth(this.adornment);
            }
            this.selectionColor = graph.getHighlightColor();
            this.dash = visuals.getDash();
            this.lineColor = visuals.getForeground();
            this.selected = visuals.isEmphasised();
            boolean emph = this.view.armed || this.selected;
            float lineWidth = visuals.getLineWidth();
            if (emph) {
                lineWidth += 2.0f;
            }
            this.lineWidth = lineWidth;
            Color innerLineColor = visuals.getInnerLine();
            if (innerLineColor != null) {
                this.twoLines = true;
                this.line2color = innerLineColor;
                this.line2width = 1.0f;
                this.line2dash = (float[])VisualKey.DASH.getDefaultValue();
            } else {
                this.twoLines = false;
            }
            this.setOpaque(visuals.isOpaque());
            Color foreground = visuals.getForeground();
            this.setForeground(foreground != null ? foreground : graph.getForeground());
            Color background = visuals.getBackground();
            Color color = background = background != null ? background : graph.getBackground();
            if (emph) {
                float darken = 0.95f;
                background = new Color(Math.max((int)((float)background.getRed() * darken), 0), Math.max((int)((float)background.getGreen() * darken), 0), Math.max((int)((float)background.getBlue() * darken), 0), background.getAlpha());
            }
            this.setBackground(background);
            Font font = Options.LABEL_FONT.deriveFont(visuals.getFont());
            this.setFont(font != null ? font : graph.getFont());
            this.setBorder(this.createEmptyBorder());
            this.setText(this.view.getText());
            this.error = visuals.isError();
            this.nodeEdge = this.cell.getLooks().contains((Object)Look.NODIFIED);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Shape shape = this.getShape(this.lineWidth / 2.0f);
            if (this.visuals.getLabel() == null) {
                this.paintBorder(g2, shape);
            } else {
                if (this.isOpaque()) {
                    this.paintBackground(g2, shape);
                }
                this.paintText(g2);
                this.paintBorder(g2, shape);
                this.paintErrorOverlay(g2);
                this.paintParameter(g2);
            }
        }

        private void paintErrorOverlay(Graphics2D g2) {
            if (this.error) {
                Shape shape = this.getShape(6.0);
                g2.setColor(Values.ERROR_COLOR);
                g2.fill(shape);
            }
        }

        private void paintParameter(Graphics2D g2) {
            if (this.adornment != null) {
                g2.setColor(this.getForeground());
                int offset = 2;
                int width = Math.max(this.adornWidth, 6) + offset;
                g2.fillRect(0, 0, width, this.adornHeight);
                g2.setFont(JAttr.ADORNMENT_FONT);
                g2.setColor(Color.white);
                g2.drawString(this.adornment, 1, this.adornHeight - offset);
            }
        }

        private void paintText(Graphics2D g) {
            boolean tmp = this.selected;
            try {
                this.setOpaque(false);
                this.selected = false;
                g.setColor(this.getForeground());
                super.paintComponent(g);
            }
            finally {
                this.selected = tmp;
            }
        }

        private void paintBorder(Graphics2D g, Shape shape) {
            g.setColor(this.lineColor);
            g.setStroke(JAttr.createStroke(this.lineWidth, this.dash));
            g.draw(shape);
            if (this.twoLines) {
                g.setColor(this.line2color);
                g.setStroke(JAttr.createStroke(this.line2width, this.line2dash));
                g.draw(shape);
            }
            if (this.selected) {
                this.paintSelectionBorder(g, shape);
            }
        }

        private void paintBackground(Graphics2D g, Shape shape) {
            Paint oldPaint = g.getPaint();
            Paint newPaint = JAttr.createPaint(shape.getBounds(), this.getBackground());
            g.setPaint(newPaint);
            g.fill(shape);
            g.setPaint(oldPaint);
        }

        private Border createEmptyBorder() {
            Insets i = this.view.getInsets();
            return i == null ? null : BorderFactory.createEmptyBorder(i.top + 6, i.left + 6, i.bottom + 6, i.right + 6);
        }

        private void paintSelectionBorder(Graphics2D g, Shape shape) {
            g.setStroke(GraphConstants.SELECTION_STROKE);
            g.setColor(this.selectionColor);
            g.draw(shape);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = null;
            if (this.cell.isStale(VisualKey.NODE_SIZE)) {
                result = this.computePreferredSize();
                this.cell.putVisual(VisualKey.NODE_SIZE, result);
            } else {
                result = new Dimension();
                result.setSize(this.visuals.getNodeSize());
            }
            Insets i = this.computeInsets(result.width, result.height);
            result = new Dimension(result.width + i.left + i.right + 12, result.height + i.top + i.bottom + 12);
            this.view.setInsets(i);
            return result;
        }

        private Dimension computePreferredSize() {
            Dimension result;
            if (this.nodeEdge) {
                result = JAttr.NODE_EDGE_DIMENSION;
            } else {
                String text = this.convertDigits(this.getText());
                result = this.sizeMap.get(text);
                if (result == null) {
                    if (text.length() == 0) {
                        result = JAttr.DEFAULT_NODE_SIZE;
                    } else {
                        Border border = this.getBorder();
                        this.setBorder(null);
                        result = super.getPreferredSize();
                        this.setBorder(border);
                    }
                    this.sizeMap.put(text, result);
                }
            }
            return result;
        }

        private int getAdornWidth(String text) {
            Integer result = this.adornWidthMap.get(text);
            if (result == null) {
                result = SwingUtilities.computeStringWidth(this.getFontMetrics(JAttr.ADORNMENT_FONT), text);
                this.adornWidthMap.put(text, result);
            }
            return result;
        }

        private String convertDigits(String original) {
            char[] array = original.toCharArray();
            boolean htmlTag = false;
            boolean htmlChar = false;
            int i = 0;
            while (i < array.length) {
                char c = array[i];
                if (htmlChar) {
                    htmlChar = c != ';';
                } else if (c == '&') {
                    htmlChar = true;
                } else if (htmlTag) {
                    htmlTag = c != '>';
                } else if (c == '<') {
                    htmlTag = true;
                } else if ('2' <= c && c <= '9') {
                    array[i] = 48;
                }
                ++i;
            }
            return String.valueOf(array).intern();
        }

        private Insets computeInsets(int textWidth, int textHeight) {
            Insets result = this.getText().length() == 0 ? (Insets)EMPTY_INSETS.clone() : (Insets)DEFAULT_INSETS.clone();
            result.left += Math.max(0, this.adornWidth - 6);
            int inset = this.visuals.getInset();
            result.left += inset;
            result.right += inset;
            result.top += inset;
            result.bottom += inset;
            switch (this.visuals.getNodeShape()) {
                case ELLIPSE: {
                    result.left += textWidth / 8;
                    result.right += textWidth / 8;
                    result.top += textHeight / 8;
                    result.bottom += textHeight / 8;
                    break;
                }
                case DIAMOND: {
                    result.left += textWidth / 3;
                    result.right += textWidth / 3;
                    result.top += textHeight / 3;
                    result.bottom += textHeight / 3;
                }
            }
            return result;
        }

        private Shape getShape(double extension) {
            double extra = 6.0 - extension;
            Dimension s = this.getSize();
            double x = extra;
            double y = extra;
            double width = s.getWidth() - 2.0 * extra;
            double height = s.getHeight() - 2.0 * extra;
            switch (this.visuals.getNodeShape()) {
                case ELLIPSE: {
                    return new Ellipse2D.Double(x, y, width, height);
                }
                case DIAMOND: {
                    return this.createDiamondShape(x, y, width, height);
                }
                case RECTANGLE: {
                    return new Rectangle2D.Double(x, y, width, height);
                }
                case ROUNDED: {
                    return new RoundRectangle2D.Double(x, y, width, height, 5.0, 5.0);
                }
                case OVAL: {
                    return new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
                }
            }
            assert (false);
            return null;
        }

        private Shape createDiamondShape(double x, double y, double width, double height) {
            GeneralPath result = new GeneralPath(1, 5);
            result.moveTo(x + width / 2.0, y);
            result.lineTo(x + width, y + height / 2.0);
            result.lineTo(x + width / 2.0, y + height);
            result.lineTo(x, y + height / 2.0);
            result.closePath();
            return result;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName)) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

