/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.control.CtrlState;
import groove.gui.jgraph.AJVertex;
import groove.gui.jgraph.LTSJCell;
import groove.gui.jgraph.LTSJEdge;
import groove.gui.jgraph.LTSJGraph;
import groove.gui.jgraph.LTSJModel;
import groove.gui.look.Look;
import groove.gui.look.VisualKey;
import groove.io.HTMLConverter;
import groove.lts.GTS;
import groove.lts.GraphState;

public class LTSJVertex
extends AJVertex<GTS, LTSJGraph, LTSJModel, LTSJEdge>
implements LTSJCell {
    private boolean visibleFlag;

    private LTSJVertex() {
    }

    @Override
    public GraphState getNode() {
        return (GraphState)super.getNode();
    }

    @Override
    protected void initialise() {
        super.initialise();
        this.visibleFlag = true;
        GraphState state = this.getNode();
        if (state != null) {
            this.setLook(Look.OPEN, !state.isClosed());
            this.setLook(Look.ABSENT, state.isAbsent());
            this.setLook(Look.TRANSIENT, state.isTransient());
            this.setLook(Look.FINAL, state.getGTS().isFinal(state));
            this.setLook(Look.RESULT, state.getGTS().isResult(state));
        }
    }

    @Override
    public void setVisibleFlag(boolean visible) {
        this.visibleFlag = visible;
        this.setStale(VisualKey.VISIBLE);
    }

    @Override
    public boolean hasVisibleFlag() {
        return this.visibleFlag;
    }

    @Override
    StringBuilder getNodeDescription() {
        StringBuilder result = new StringBuilder("State ");
        result.append(HTMLConverter.UNDERLINE_TAG.on(this.getNode()));
        CtrlState ctrlState = this.getNode().getCtrlState();
        if (!ctrlState.getAut().isDefault() || !ctrlState.isStart()) {
            result.append(" with control state ");
            result.append(HTMLConverter.UNDERLINE_TAG.on(ctrlState));
        }
        return result;
    }

    public boolean isResult() {
        return this.getNode().getGTS().isResult(this.getNode());
    }

    @Override
    public boolean hasErrors() {
        return this.getNode().isError();
    }

    public boolean isStart() {
        GTS gts = this.getNode().getGTS();
        return gts.startState().equals(this.getNode());
    }

    public boolean isClosed() {
        return this.getNode().isClosed();
    }

    public boolean isTransient() {
        return this.getNode().isTransient();
    }

    public boolean isFinal() {
        GTS gts = this.getNode().getGTS();
        return gts.isFinal(this.getNode());
    }

    @Override
    public String getNodeIdString() {
        String result = super.getNodeIdString();
        CtrlState ctrlState = this.getNode().getCtrlState();
        if (!ctrlState.getAut().isDefault() || !ctrlState.isStart()) {
            result = String.valueOf(result) + "|" + ctrlState.toString();
        }
        return result;
    }

    final boolean isActive() {
        return this.getLooks().contains((Object)Look.ACTIVE);
    }

    @Override
    public final boolean setActive(boolean active) {
        return this.setLook(Look.ACTIVE, active);
    }

    @Override
    protected Look getStructuralLook() {
        if (this.isStart()) {
            return Look.START;
        }
        return Look.STATE;
    }

    public static LTSJVertex newInstance() {
        return new LTSJVertex();
    }
}

