/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.layout;

import com.jgraph.layout.JGraphLayout;
import com.jgraph.layout.graph.JGraphSimpleLayout;
import com.jgraph.layout.hierarchical.JGraphHierarchicalLayout;
import com.jgraph.layout.organic.JGraphFastOrganicLayout;
import com.jgraph.layout.organic.JGraphOrganicLayout;
import com.jgraph.layout.organic.JGraphSelfOrganizingOrganicLayout;
import com.jgraph.layout.simple.SimpleGridLayout;
import com.jgraph.layout.tree.JGraphCompactTreeLayout;
import com.jgraph.layout.tree.JGraphRadialTreeLayout;
import com.jgraph.layout.tree.JGraphTreeLayout;
import groove.gui.layout.LayouterItem;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public enum LayoutKind {
    SIMPLE_CIRCLE("Simple Circle", (JGraphLayout)new JGraphSimpleLayout(0)),
    SIMPLE_TILT("Simple Tilt", (JGraphLayout)new JGraphSimpleLayout(1)),
    SIMPLE_RANDOM("Simple Randomized", (JGraphLayout)new JGraphSimpleLayout(2, 500, 500)),
    SIMPLE_GRID("Simple Grid", (JGraphLayout)new SimpleGridLayout()),
    COMPACT_TREE("Compact Tree", (JGraphLayout)new JGraphCompactTreeLayout()),
    RADIAL_TREE("Radial Tree", (JGraphLayout)new JGraphRadialTreeLayout()),
    BASIC_TREE("Basic Tree", (JGraphLayout)new JGraphTreeLayout()),
    ORGANIC("Organic", (JGraphLayout)new JGraphOrganicLayout()),
    FAST_ORGANIC("Fast Organic", (JGraphLayout)new JGraphFastOrganicLayout()),
    SELF_ORGANIZ("Self-Organizing", (JGraphLayout)new JGraphSelfOrganizingOrganicLayout()),
    HIERARCHICAL("Hierarchical", (JGraphLayout)new JGraphHierarchicalLayout());

    private String displayString;
    private JGraphLayout layout;
    private static Map<LayoutKind, LayouterItem> map;

    static {
        map = new HashMap<LayoutKind, LayouterItem>();
    }

    private LayoutKind(String displayString, JGraphLayout layout) {
        this.displayString = displayString;
        this.layout = layout;
    }

    public String getDisplayString() {
        return String.valueOf(this.displayString) + " Layout";
    }

    public JGraphLayout getLayout() {
        return this.layout;
    }

    public static LayouterItem getLayouterItemProto(LayoutKind kind) {
        LayouterItem result = map.get((Object)kind);
        if (result == null) {
            result = new LayouterItem(kind);
            map.put(kind, result);
        }
        return result;
    }

    public static JPanel createLayoutPanel(LayouterItem item) {
        JGraphLayout layout = item.getLayout();
        if (layout instanceof JGraphSimpleLayout) {
            return LayoutKind.createLayoutPanel(item, (JGraphSimpleLayout)layout);
        }
        if (layout instanceof SimpleGridLayout) {
            return LayoutKind.createLayoutPanel(item, (SimpleGridLayout)layout);
        }
        if (layout instanceof JGraphCompactTreeLayout) {
            return LayoutKind.createLayoutPanel(item, (JGraphCompactTreeLayout)layout);
        }
        if (layout instanceof JGraphRadialTreeLayout) {
            return LayoutKind.createLayoutPanel(item, (JGraphRadialTreeLayout)layout);
        }
        if (layout instanceof JGraphTreeLayout) {
            return LayoutKind.createLayoutPanel(item, (JGraphTreeLayout)layout);
        }
        if (layout instanceof JGraphOrganicLayout) {
            return LayoutKind.createLayoutPanel(item, (JGraphOrganicLayout)layout);
        }
        if (layout instanceof JGraphFastOrganicLayout) {
            return LayoutKind.createLayoutPanel(item, (JGraphFastOrganicLayout)layout);
        }
        if (layout instanceof JGraphSelfOrganizingOrganicLayout) {
            return LayoutKind.createLayoutPanel(item, (JGraphSelfOrganizingOrganicLayout)layout);
        }
        if (layout instanceof JGraphHierarchicalLayout) {
            return LayoutKind.createLayoutPanel(item, (JGraphHierarchicalLayout)layout);
        }
        return null;
    }

    private static JPanel createLayoutPanel(LayouterItem item, JGraphSimpleLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        panel.createSlider(LayoutKind.getMethod((JGraphLayout)layout, "setMaxx", Integer.TYPE), 0, 500, 20, "Maximum X");
        panel.createSlider(LayoutKind.getMethod((JGraphLayout)layout, "setMaxy", Integer.TYPE), 0, 500, 20, "Maximum Y");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static JPanel createLayoutPanel(LayouterItem item, SimpleGridLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        panel.createSlider(LayoutKind.getMethod((JGraphLayout)layout, "setNumCellsPerRow", Integer.TYPE), 0, 20, 0, "Nodes per row");
        panel.createSlider(LayoutKind.getMethod((JGraphLayout)layout, "setHeightSpacing", Integer.TYPE), 0, 100, 20, "Height space between nodes");
        panel.createSlider(LayoutKind.getMethod((JGraphLayout)layout, "setWidthSpacing", Integer.TYPE), 0, 100, 20, "Width space between nodes");
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setActOnUnconnectedVerticesOnly", Boolean.TYPE), "Act on unconnected vertices only", true);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static JPanel createLayoutPanel(LayouterItem item, JGraphCompactTreeLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        String[] labels = new String[]{"North", "West"};
        int[] values = new int[]{1, 7};
        panel.createRadioButtonGroup(LayoutKind.getMethod((JGraphLayout)layout, "setOrientation", Integer.TYPE), labels, values, 1, "Orientation");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setLevelDistance", Double.TYPE), 30.0, 1.0, 100.0, 1.0, "Level distance");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setNodeBorder", Double.TYPE), 5.0, 1.0, 100.0, 1.0, "Node distance");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static JPanel createLayoutPanel(LayouterItem item, JGraphRadialTreeLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setAutoRadius", Boolean.TYPE), "Auto radius", false);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setMinradiusx", Double.TYPE), 80.0, 1.0, 2000.0, 1.0, "Minimum radius X");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setMinradiusy", Double.TYPE), 80.0, 1.0, 2000.0, 1.0, "Minimum radius Y");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setMaxradiusx", Double.TYPE), 1000.0, 1.0, 2000.0, 1.0, "Maximum radius X");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setMaxradiusy", Double.TYPE), 1000.0, 1.0, 2000.0, 1.0, "Maximum radius Y");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static JPanel createLayoutPanel(LayouterItem item, JGraphTreeLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        String[] labels = new String[]{"Top", "Center", "Bottom"};
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 3;
        int[] values = nArray;
        panel.createRadioButtonGroup(LayoutKind.getMethod((JGraphLayout)layout, "setAlignment", Integer.TYPE), labels, values, 0, "Alignment");
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setCombineLevelNodes", Boolean.TYPE), "Combine level nodes", true);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static JPanel createLayoutPanel(LayouterItem item, JGraphOrganicLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setDeterministic", Boolean.TYPE), "Deterministic", true);
        panel.createSlider(LayoutKind.getMethod((JGraphLayout)layout, "setMaxIterations", Integer.TYPE), 1, 1000, 100, "Width space between nodes");
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setOptimizeNodeDistribution", Boolean.TYPE), "Optimize node distribution", true);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setNodeDistributionCostFactor", Double.TYPE), 300000.0, 1.0, 1.0E7, 10.0, "Node distribution cost factor");
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setOptimizeEdgeCrossing", Boolean.TYPE), "Optimize edge crossing", true);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setEdgeCrossingCostFactor", Double.TYPE), 2000.0, 1.0, 20000.0, 1.0, "Edge crossing cost factor");
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setOptimizeEdgeDistance", Boolean.TYPE), "Optimize edge distance", true);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setEdgeDistanceCostFactor", Double.TYPE), 4000.0, 1.0, 20000.0, 1.0, "Edge distance cost factor");
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setOptimizeEdgeLength", Boolean.TYPE), "Optimize edge length", true);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setEdgeLengthCostFactor", Double.TYPE), 0.02, 0.01, 1.0, 0.01, "Edge length cost factor");
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setOptimizeBorderLine", Boolean.TYPE), "Optimize border line", true);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setBorderLineCostFactor", Double.TYPE), 5.0, 0.1, 100.0, 1.0, "Border line cost factor");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static JPanel createLayoutPanel(LayouterItem item, JGraphFastOrganicLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setForceConstant", Double.TYPE), 50.0, 0.001, 500.0, 1.0, "Force constant");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setInitialTemp", Double.TYPE), 200.0, 1.0, 1000.0, 1.0, "Initial temperature");
        panel.createSlider(LayoutKind.getMethod((JGraphLayout)layout, "setMaxIterations", Integer.TYPE), 0, 500, 100, "Maximum number of interations");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static JPanel createLayoutPanel(LayouterItem item, JGraphSelfOrganizingOrganicLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setCoolingFactor", Double.TYPE), 1.0, 0.01, 10.0, 0.01, "Cooling factor");
        panel.createSlider(LayoutKind.getMethod((JGraphLayout)layout, "setStartRadius", Integer.TYPE), 0, 100, 0, "Start radius");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static JPanel createLayoutPanel(LayouterItem item, JGraphHierarchicalLayout layout) {
        LayoutPanel panel = new LayoutPanel((JGraphLayout)layout, item);
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setDeterministic", Boolean.TYPE), "Deterministic", false);
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setLayoutFromSinks", Boolean.TYPE), "Layout from sinks", true);
        panel.createCheckBox(LayoutKind.getMethod((JGraphLayout)layout, "setCompactLayout", Boolean.TYPE), "Compact layout", false);
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setInterHierarchySpacing", Double.TYPE), 60.0, 1.0, 200.0, 1.0, "Space between unconnected hierarchies");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setInterRankCellSpacing", Double.TYPE), 50.0, 1.0, 200.0, 1.0, "Space between cell on adjacent layers");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setIntraCellSpacing", Double.TYPE), 30.0, 1.0, 200.0, 1.0, "Space between cell on same layer");
        panel.createSpinner(LayoutKind.getMethod((JGraphLayout)layout, "setParallelEdgeSpacing", Double.TYPE), 10.0, 1.0, 200.0, 1.0, "Parallel edge spacing");
        String[] labels = new String[]{"North", "South", "East", "West"};
        int[] values = new int[]{1, 5, 3, 7};
        panel.createRadioButtonGroup(LayoutKind.getMethod((JGraphLayout)layout, "setOrientation", Integer.TYPE), labels, values, 0, "Orientation");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return panel;
    }

    private static Method getMethod(JGraphLayout layout, String name, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = layout.getClass().getMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return method;
    }

    private static class LayoutPanel
    extends JPanel
    implements ChangeListener,
    ItemListener,
    ActionListener {
        final JGraphLayout layout;
        final LayouterItem item;

        LayoutPanel(JGraphLayout layout, LayouterItem item) {
            this.layout = layout;
            this.item = item;
            this.setLayout(new BoxLayout(this, 1));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ((ReflectiveComponent)e.getSource()).setLayoutParameter();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ((ReflectiveComponent)e.getSource()).setLayoutParameter();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ReflectiveComponent)e.getSource()).setLayoutParameter();
        }

        void createSlider(Method methodToCall, int min, int max, int init, String label) {
            MyJSlider slider = new MyJSlider(methodToCall, min, max, init, this.layout, this.item);
            slider.addChangeListener(this);
            JLabel sliderLabel = new JLabel(label, 2);
            this.add(sliderLabel);
            this.add(slider);
        }

        void createCheckBox(Method methodToCall, String label, boolean selected) {
            MyCheckBox checkBox = new MyCheckBox(methodToCall, this.layout, this.item, label, selected);
            checkBox.addItemListener(this);
            this.add(checkBox);
        }

        void createRadioButtonGroup(Method methodToCall, String[] label, int[] value, int selectedValue, String title) {
            ButtonGroup group = new ButtonGroup();
            JPanel radioPanel = new JPanel(new GridLayout(0, 4));
            assert (label.length == value.length);
            int i = 0;
            while (i < label.length) {
                MyRadioButton button = new MyRadioButton(methodToCall, this.layout, this.item, label[i], value[i]);
                button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 4));
                button.addActionListener(this);
                group.add(button);
                radioPanel.add(button);
                if (i == selectedValue) {
                    group.setSelected(button.getModel(), true);
                }
                ++i;
            }
            radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
            this.add((Component)radioPanel, "Before");
        }

        void createSpinner(Method methodToCall, double value, double min, double max, double step, String label) {
            MySpinner spinner = new MySpinner(methodToCall, this.layout, this.item, value, min, max, step);
            spinner.addChangeListener(this);
            JLabel l = new JLabel(label);
            this.add(l);
            l.setLabelFor(spinner);
            this.add(spinner);
        }
    }

    private static class MyCheckBox
    extends JCheckBox
    implements ReflectiveComponent {
        final Method methodToCall;
        final JGraphLayout layout;
        final LayouterItem item;

        MyCheckBox(Method methodToCall, JGraphLayout layout, LayouterItem item, String label, boolean selected) {
            super(label);
            this.methodToCall = methodToCall;
            this.layout = layout;
            this.item = item;
            this.setSelected(selected);
        }

        @Override
        public void setLayoutParameter() {
            this.invoke();
            this.item.start();
        }

        void invoke() {
            try {
                this.methodToCall.invoke((Object)this.layout, this.isSelected());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static class MyJSlider
    extends JSlider
    implements ReflectiveComponent {
        final Method methodToCall;
        final JGraphLayout layout;
        final LayouterItem item;

        MyJSlider(Method methodToCall, int min, int max, int init, JGraphLayout layout, LayouterItem item) {
            super(0, min, max, init);
            this.methodToCall = methodToCall;
            this.layout = layout;
            this.item = item;
            this.setMajorTickSpacing((max - min) / 5);
            this.setMinorTickSpacing((max - min) / 50);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            Font font = new Font("Serif", 2, 10);
            this.setFont(font);
        }

        @Override
        public void setLayoutParameter() {
            if (!this.getValueIsAdjusting()) {
                this.invoke();
                this.item.start();
            }
        }

        void invoke() {
            try {
                this.methodToCall.invoke((Object)this.layout, this.getValue());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static class MyRadioButton
    extends JRadioButton
    implements ReflectiveComponent {
        final Method methodToCall;
        final JGraphLayout layout;
        final LayouterItem item;
        final int value;

        MyRadioButton(Method methodToCall, JGraphLayout layout, LayouterItem item, String label, int value) {
            super(label);
            this.methodToCall = methodToCall;
            this.layout = layout;
            this.item = item;
            this.value = value;
        }

        @Override
        public void setLayoutParameter() {
            this.invoke();
            this.item.start();
        }

        void invoke() {
            try {
                this.methodToCall.invoke((Object)this.layout, this.value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static class MySpinner
    extends JSpinner
    implements ReflectiveComponent {
        final Method methodToCall;
        final JGraphLayout layout;
        final LayouterItem item;

        MySpinner(Method methodToCall, JGraphLayout layout, LayouterItem item, double value, double min, double max, double step) {
            super(new SpinnerNumberModel(value, min, max, step));
            this.methodToCall = methodToCall;
            this.layout = layout;
            this.item = item;
        }

        @Override
        public void setLayoutParameter() {
            this.invoke();
            this.item.start();
        }

        @Override
        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)super.getModel();
        }

        void invoke() {
            try {
                this.methodToCall.invoke((Object)this.layout, this.getModel().getNumber().doubleValue());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static interface ReflectiveComponent {
        public void setLayoutParameter();
    }
}

