/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.layout;

import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JVertex;
import groove.gui.layout.AbstractLayouter;
import groove.gui.layout.Layouter;
import groove.util.Pair;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SpringLayouter
extends AbstractLayouter {
    private AbstractLayouter.Layoutable[] layoutables;
    private Point2D.Double[] positions;
    private Point2D.Float[] deltas;
    private final Map<AbstractLayouter.Layoutable, Point2D.Float> deltaMap = new HashMap<AbstractLayouter.Layoutable, Point2D.Float>();
    private AbstractLayouter.Layoutable[] edgeFragmentSources;
    private AbstractLayouter.Layoutable[] edgeFragmentTargets;
    double damper = 1.0;
    private double maxMotion = 0.0;
    private double lastMaxMotion = 0.0;
    private double motionRatio = 0.0;
    private float workingRigidity = 2.0f;
    private float rigidity = 2.0f;
    public static final String ACTION_NAME = "Spring layout";
    public static final String STOP_ACTION_NAME = "Stop layout";
    public static final float DEFAULT_RIGIDITY = 2.0f;
    public static final int DEFAULT_DURATION = 2000;
    private static final float SMALL_VALUE = 0.1f;
    private static final float SLOW_DAMPING = 1.0E-4f;
    private static final float MEDIUM_DAMPING = 0.003f;
    private static final float FAST_DAMPING = 0.01f;
    private static final float MEDIUM_DAMPING_MOTION_TRESHHOLD = 0.8f;
    private static final float FAST_DAMPING_MOTION_TRESHHOLD = 0.4f;
    private static final float FAST_DAMPING_DAMPER_TRESHHOLD = 0.9f;
    private static final boolean DEBUG = false;
    private static final boolean MOVE_NODES_DEBUG = false;
    private static final int TIMEOUT = 2000;

    public SpringLayouter() {
        super(ACTION_NAME);
    }

    private SpringLayouter(String name, JGraph<?> jgraph, float rigidity) {
        super(name, jgraph);
    }

    @Override
    public Layouter newInstance(JGraph<?> jgraph) {
        return new SpringLayouter(this.getName(), jgraph, this.rigidity);
    }

    @Override
    public void start() {
        this.damper = 1.0;
        this.prepare();
        long currentTime = System.currentTimeMillis();
        while (this.damper > 0.0 && System.currentTimeMillis() - currentTime < 2000L) {
            this.relax();
        }
        this.finish();
    }

    @Override
    protected void prepare() {
        super.prepare();
        this.deltaMap.clear();
        int layoutableIndex = 0;
        this.layoutables = new AbstractLayouter.Layoutable[this.toLayoutableMap.size()];
        this.positions = new Point2D.Double[this.toLayoutableMap.size()];
        this.deltas = new Point2D.Float[this.toLayoutableMap.size()];
        Iterator iterator = this.toLayoutableMap.values().iterator();
        while (iterator.hasNext()) {
            AbstractLayouter.Layoutable layoutable;
            this.layoutables[layoutableIndex] = layoutable = (AbstractLayouter.Layoutable)iterator.next();
            if (!this.immovableSet.contains(layoutable)) {
                this.deltas[layoutableIndex] = new Point2D.Float(0.0f, 0.0f);
                this.deltaMap.put(layoutable, this.deltas[layoutableIndex]);
            }
            double p2X = layoutable.getX() + layoutable.getWidth() / 2.0;
            double p2Y = layoutable.getY() + layoutable.getHeight() / 2.0;
            this.positions[layoutableIndex] = new Point2D.Double(p2X, p2Y);
            ++layoutableIndex;
        }
        LinkedList<AbstractLayouter.Layoutable> edgeFragmentSourceList = new LinkedList<AbstractLayouter.Layoutable>();
        LinkedList<AbstractLayouter.Layoutable> edgeFragmentTargetList = new LinkedList<AbstractLayouter.Layoutable>();
        int i = 0;
        while (i < this.jmodel.getRootCount()) {
            JCell jCell = (JCell)this.jmodel.getRootAt(i);
            if (jCell instanceof JEdge && jCell.getVisuals().isVisible() && !jCell.isGrayedOut()) {
                JEdge jEdge = (JEdge)jCell;
                List<Point2D> points = jEdge.getVisuals().getPoints();
                int j = 0;
                while (j < points.size() - 1) {
                    JVertex efs = j == 0 ? jEdge.getSourceVertex() : Pair.newPair(jEdge, j);
                    AbstractLayouter.Layoutable source = (AbstractLayouter.Layoutable)this.toLayoutableMap.get(efs);
                    JVertex eft = j == points.size() - 2 ? jEdge.getTargetVertex() : Pair.newPair(jEdge, j + 1);
                    AbstractLayouter.Layoutable target = (AbstractLayouter.Layoutable)this.toLayoutableMap.get(eft);
                    if (source == null || target == null) break;
                    edgeFragmentSourceList.add(source);
                    edgeFragmentTargetList.add(target);
                    ++j;
                }
            }
            ++i;
        }
        this.edgeFragmentSources = edgeFragmentSourceList.toArray(new AbstractLayouter.Layoutable[edgeFragmentSourceList.size()]);
        this.edgeFragmentTargets = edgeFragmentTargetList.toArray(new AbstractLayouter.Layoutable[edgeFragmentTargetList.size()]);
    }

    private void damp() {
        if (this.motionRatio <= 0.001) {
            if ((this.maxMotion < (double)0.4f || this.damper < (double)0.9f) && this.damper > (double)0.01f) {
                this.damper -= (double)0.01f;
            } else if (this.maxMotion < (double)0.8f && this.damper > (double)0.003f) {
                this.damper -= (double)0.003f;
            } else if (this.damper > (double)1.0E-4f) {
                this.damper -= (double)1.0E-4f;
            }
        }
        if (this.maxMotion <= (double)1.0E-4f) {
            this.damper = 0.0;
        }
    }

    private synchronized void relaxEdges() {
        int i = 0;
        while (i < this.edgeFragmentSources.length) {
            AbstractLayouter.Layoutable bf = this.edgeFragmentSources[i];
            AbstractLayouter.Layoutable bt = this.edgeFragmentTargets[i];
            double dx = (bt.getX() - bf.getX()) * (double)this.workingRigidity / 100.0;
            double dy = (bt.getY() - bf.getY()) * (double)this.workingRigidity / 100.0;
            this.shiftDelta(bt, -dx, -dy);
            this.shiftDelta(bf, dx, dy);
            ++i;
        }
    }

    private synchronized void avoidLabels() {
        int i = 0;
        while (i < this.layoutables.length) {
            AbstractLayouter.Layoutable from = this.layoutables[i];
            Point2D.Double bf = this.positions[i];
            float fromDx = 0.0f;
            float fromDy = 0.0f;
            int j = i + 1;
            while (j < this.layoutables.length) {
                AbstractLayouter.Layoutable to = this.layoutables[j];
                Point2D.Double bt = this.positions[j];
                double vx = bf.x - bt.x;
                double vy = bf.y - bt.y;
                if (Math.abs(vx) < 200.0 && Math.abs(vy) < 200.0) {
                    double dy;
                    double dx;
                    double len = (vx * vx + vy * vy) / 200.0;
                    if (len < (double)0.005f) {
                        dx = 200.0f * (float)Math.random();
                        dy = 200.0f * (float)Math.random();
                    } else {
                        if (from instanceof AbstractLayouter.PointLayoutable || to instanceof AbstractLayouter.PointLayoutable) {
                            len += 5.0;
                        }
                        dx = vx / len;
                        dy = vy / len;
                    }
                    fromDx = (float)((double)fromDx + dx);
                    fromDy = (float)((double)fromDy + dy);
                    this.shiftDelta(this.deltas[j], -dx, -dy);
                }
                ++j;
            }
            this.shiftDelta(this.deltas[i], (double)fromDx, (double)fromDy);
            ++i;
        }
    }

    private synchronized void moveNodes() {
        float shiftX = 0.0f;
        float shiftY = 0.0f;
        this.lastMaxMotion = this.maxMotion;
        this.maxMotion = 0.0;
        int i = 0;
        while (i < this.deltas.length) {
            AbstractLayouter.Layoutable key = this.layoutables[i];
            Point2D.Float delta = this.deltas[i];
            if (delta != null) {
                float dx = delta.x = (float)((double)delta.x * this.damper);
                float dy = delta.y = (float)((double)delta.y * this.damper);
                delta.setLocation(dx / 2.0f, dy / 2.0f);
                if (Math.abs(dx) > 0.1f || Math.abs(dy) > 0.1f) {
                    float distMoved = Math.abs(dx) + Math.abs(dy);
                    if ((double)distMoved > this.maxMotion) {
                        this.maxMotion = distMoved;
                    }
                    Point2D.Double position = this.positions[i];
                    position.x += (double)(Math.max(-5.0f, Math.min(5.0f, dx)) - shiftX);
                    position.y += (double)(Math.max(-5.0f, Math.min(5.0f, dy)) - shiftY);
                    if (position.x < 0.0) {
                        shiftX = (float)((double)shiftX + position.x);
                        position.x = 0.0;
                    }
                    if (position.y < 0.0) {
                        shiftY = (float)((double)shiftY + position.y);
                        position.y = 0.0;
                    }
                    key.setLocation(Math.max(0.0, (double)((int)position.x) - key.getWidth() / 2.0), Math.max(0.0, (double)((int)position.y) - key.getHeight() / 2.0));
                }
            }
            ++i;
        }
        this.motionRatio = this.maxMotion > 0.0 ? this.lastMaxMotion / this.maxMotion - 1.0 : 0.0;
        this.damp();
    }

    synchronized void relax() {
        int i = 0;
        while (i < 10) {
            this.relaxEdges();
            this.avoidLabels();
            this.moveNodes();
            ++i;
        }
        this.workingRigidity = this.rigidity;
    }

    private void shiftDelta(AbstractLayouter.Layoutable key, double dx, double dy) {
        this.shiftDelta(this.deltaMap.get(key), dx, dy);
    }

    private void shiftDelta(Point2D.Float delta, double dx, double dy) {
        if (delta != null) {
            delta.x = (float)((double)delta.x + dx);
            delta.y = (float)((double)delta.y + dy);
        }
    }
}

