/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.list;

import groove.gui.Icons;
import groove.gui.display.TabLabel;
import groove.gui.list.ErrorListPanel;
import groove.gui.list.SearchResultListPanel;
import groove.io.HTMLConverter;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public final class ListTabbedPane
extends JTabbedPane {
    private final ErrorListPanel errorList = new ErrorListPanel(null);
    private final SearchResultListPanel searchList = new SearchResultListPanel(null, this);
    private int errorTabIndex = -1;
    private TabLabel searchTitle;
    private int searchTabIndex = -1;

    public ListTabbedPane() {
        this.adjustVisibility();
    }

    private void addErrorTab() {
        this.errorTabIndex = 0;
        if (this.isSearchTabVisible()) {
            ++this.searchTabIndex;
        }
        this.insertTab(this.getErrorTitle(), Icons.ERROR_ICON, this.errorList, "Errors", this.errorTabIndex);
    }

    private void addSearchTab() {
        this.searchTabIndex = this.getTabCount();
        this.add(this.searchList);
        this.setTabComponentAt(this.searchTabIndex, this.getSearchTitle());
    }

    private void removeErrorTab() {
        this.removeTabAt(this.errorTabIndex);
        this.errorTabIndex = -1;
        if (this.isSearchTabVisible()) {
            --this.searchTabIndex;
        }
    }

    private void removeSearchTab() {
        this.removeTabAt(this.searchTabIndex);
        this.searchTabIndex = -1;
    }

    public void closeSearchTab() {
        this.searchList.setEntries(Collections.emptySet());
        this.adjustVisibility();
    }

    private String getErrorTitle() {
        return HTMLConverter.HTML_TAG.on(HTMLConverter.STRONG_TAG.on("Errors in grammar"));
    }

    private TabLabel getSearchTitle() {
        if (this.searchTitle == null) {
            this.searchTitle = new TabLabel(this, (Icon)Icons.SEARCH_ICON, "Search results");
        }
        return this.searchTitle;
    }

    private boolean isErrorTabVisible() {
        return this.errorTabIndex >= 0;
    }

    private boolean isSearchTabVisible() {
        return this.searchTabIndex >= 0;
    }

    public ErrorListPanel getErrorListPanel() {
        return this.errorList;
    }

    public SearchResultListPanel getSearchResultListPanel() {
        return this.searchList;
    }

    public void adjustVisibility() {
        if (this.errorList.hasContent() && !this.isErrorTabVisible()) {
            this.addErrorTab();
        }
        if (!this.errorList.hasContent() && this.isErrorTabVisible()) {
            this.removeErrorTab();
        }
        if (this.searchList.hasContent() && !this.isSearchTabVisible()) {
            this.addSearchTab();
        }
        if (!this.searchList.hasContent() && this.isSearchTabVisible()) {
            this.removeSearchTab();
        }
        if (this.isSearchTabVisible()) {
            this.setSelectedIndex(this.searchTabIndex);
        }
        this.setVisible(this.isErrorTabVisible() || this.isSearchTabVisible());
    }
}

