/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.list;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.graph.Element;
import groove.gui.list.ListPanel;
import java.util.ArrayList;
import java.util.List;

public class SearchResult
implements ListPanel.SelectableListEntry {
    private AspectGraph graph;
    private ResourceKind resourceKind;
    private String resourceName;
    private final List<Element> elements = new ArrayList<Element>();
    private final String message;

    public SearchResult(String message) {
        this.message = message;
    }

    public SearchResult(String message, Object ... pars) {
        this(String.format(message, pars));
        Object[] objectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            Object par = objectArray[n2];
            this.addContext(par);
            ++n2;
        }
    }

    private void addContext(Object par) {
        if (par instanceof AspectGraph) {
            this.graph = (AspectGraph)par;
            this.resourceName = this.graph.getName();
            this.resourceKind = ResourceKind.toResource(this.graph.getRole());
        } else if (par instanceof Element) {
            this.elements.add((Element)par);
        } else if (par instanceof Object[]) {
            Object[] objectArray = (Object[])par;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object subpar = objectArray[n2];
                this.addContext(subpar);
                ++n2;
            }
        }
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof SearchResult;
        if (result) {
            SearchResult err = (SearchResult)obj;
            result = this.toString().equals(err.toString());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.message;
    }

    public final AspectGraph getGraph() {
        return this.graph;
    }

    @Override
    public final List<Element> getElements() {
        return this.elements;
    }

    @Override
    public final ResourceKind getResourceKind() {
        return this.resourceKind;
    }

    @Override
    public final String getResourceName() {
        return this.resourceName;
    }
}

