/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import java.util.HashMap;
import java.util.Map;
import org.jgraph.graph.GraphConstants;

public enum EdgeEnd {
    ARROW(1),
    DOUBLE_LINE(8),
    NONE(0),
    SUBTYPE(2, GraphConstants.DEFAULTDECORATIONSIZE + 5, false),
    COMPOSITE(9, 15),
    NESTING(4, GraphConstants.DEFAULTDECORATIONSIZE - 5),
    SIMPLE(4),
    UNFILLED(1, false);

    private final int code;
    private final int size;
    private final boolean filled;
    private static Map<Integer, EdgeEnd> codeMap;

    static {
        codeMap = new HashMap<Integer, EdgeEnd>();
        EdgeEnd[] edgeEndArray = EdgeEnd.values();
        int n = edgeEndArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeEnd style = edgeEndArray[n2];
            codeMap.put(style.getCode(), style);
            ++n2;
        }
    }

    private EdgeEnd(int code) {
        this(code, GraphConstants.DEFAULTDECORATIONSIZE, true);
    }

    private EdgeEnd(int code, int size) {
        this(code, size, true);
    }

    private EdgeEnd(int code, boolean filled) {
        this(code, GraphConstants.DEFAULTDECORATIONSIZE, filled);
    }

    private EdgeEnd(int code, int size, boolean filled) {
        this.code = code;
        this.size = size;
        this.filled = filled;
    }

    public int getCode() {
        return this.code;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public static EdgeEnd getEdgeEnd(int code) {
        EdgeEnd result = codeMap.get(code);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unknown edge style code %s", code));
        }
        return result;
    }
}

