/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.look.Line;
import java.awt.Color;

public abstract class LineFormat<R extends Builder<R>> {
    public String toString(Line line) {
        return line.toString(this).toString();
    }

    public R applyMulti(R[] sublines) {
        R result;
        if (sublines.length == 0) {
            result = this.createResult();
        } else {
            result = sublines[0];
            int i = 1;
            while (i < sublines.length) {
                result.appendLineBreak();
                result.append(sublines[i]);
                ++i;
            }
        }
        return result;
    }

    public R applyComposed(R[] fragments) {
        R result;
        if (fragments.length == 0) {
            result = this.createResult();
        } else {
            result = fragments[0];
            int i = 1;
            while (i < fragments.length) {
                result.append(fragments[i]);
                ++i;
            }
        }
        return result;
    }

    public abstract R applyColored(Line.ColorType var1, Color var2, R var3);

    public abstract R applyStyled(Line.Style var1, R var2);

    public abstract R applyAtomic(String var1);

    protected abstract R createResult();

    public static interface Builder<R extends Builder<R>> {
        public boolean isEmpty();

        public StringBuilder getResult();

        public void append(R var1);

        public void appendLineBreak();
    }
}

