/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.grammar.aspect.AspectKind;
import groove.gui.look.EdgeEnd;
import groove.gui.look.NodeShape;
import groove.gui.look.Values;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import groove.util.Colors;
import java.awt.Color;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Look
extends Enum<Look> {
    public static final /* enum */ Look BASIC = new Look(true, new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.OPAQUE, true);
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.ROUNDED);
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.ARROW);
            this.add(VisualKey.FONT, 0);
        }
    };
    public static final /* enum */ Look BIDIRECTIONAL = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.EDGE_SOURCE_SHAPE, (Object)EdgeEnd.ARROW);
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.ARROW);
        }
    };
    public static final /* enum */ Look NODIFIED = new Look(true, new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.OPAQUE, true);
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.ELLIPSE);
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.NONE);
        }
    };
    public static final /* enum */ Look NO_ARROW = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.NONE);
        }
    };
    public static final /* enum */ Look REGULAR = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.FONT, 2);
        }
    };
    public static final /* enum */ Look TYPE = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.RECTANGLE);
        }
    };
    public static final /* enum */ Look SUBTYPE = new Look(true, new Look[]{TYPE}){

        @Override
        void init() {
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.SUBTYPE);
        }
    };
    public static final /* enum */ Look COMPOSITE = new Look(new Look[]{TYPE}){

        @Override
        void init() {
            this.add(VisualKey.EDGE_SOURCE_SHAPE, (Object)EdgeEnd.COMPOSITE);
        }
    };
    public static final /* enum */ Look ABSTRACT = new Look(true, new Look[]{TYPE}){

        @Override
        void init() {
            this.add(VisualKey.DASH, Values.ABSTRACT_DASH);
            this.add(VisualKey.FONT, 2);
        }
    };
    public static final /* enum */ Look REMARK = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.FOREGROUND, Values.REMARK_FOREGROUND);
            this.add(VisualKey.BACKGROUND, Values.REMARK_BACKGROUND);
        }
    };
    public static final /* enum */ Look EMBARGO = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.FOREGROUND, Values.EMBARGO_FOREGROUND);
            this.add(VisualKey.BACKGROUND, Values.EMBARGO_BACKGROUND);
            this.add(VisualKey.LINE_WIDTH, Float.valueOf(5.0f));
            this.add(VisualKey.DASH, Values.EMBARGO_DASH);
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.UNFILLED);
        }
    };
    public static final /* enum */ Look CONNECT = new Look(true, new Look[]{EMBARGO}){

        @Override
        void init() {
            this.add(VisualKey.LINE_WIDTH, Float.valueOf(4.0f));
            this.add(VisualKey.DASH, Values.CONNECT_DASH);
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.NONE);
        }
    };
    public static final /* enum */ Look ERASER = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.FOREGROUND, Values.ERASER_FOREGROUND);
            this.add(VisualKey.BACKGROUND, Values.ERASER_BACKGROUND);
            this.add(VisualKey.DASH, Values.ERASER_DASH);
        }
    };
    public static final /* enum */ Look CREATOR = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.FOREGROUND, Values.CREATOR_FOREGROUND);
            this.add(VisualKey.BACKGROUND, Values.CREATOR_BACKGROUND);
            this.add(VisualKey.LINE_WIDTH, Float.valueOf(3.0f));
        }
    };
    public static final /* enum */ Look ADDER = new Look(true, new Look[]{CREATOR, EMBARGO}){

        @Override
        void init() {
            this.add(VisualKey.LINE_WIDTH, Float.valueOf(6.0f));
            this.add(VisualKey.INNER_LINE, Values.CREATOR_FOREGROUND);
        }
    };
    public static final /* enum */ Look NESTING = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.DASH, Values.NESTED_DASH);
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.SIMPLE);
        }
    };
    public static final /* enum */ Look PRODUCT = new Look(false, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.DIAMOND);
        }
    };
    public static final /* enum */ Look DATA = new Look(false, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.ELLIPSE);
        }
    };
    public static final /* enum */ Look CTRL_TRANSIENT_STATE = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.DIAMOND);
        }
    };
    public static final /* enum */ Look CTRL_OMEGA_TRANS = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.FOREGROUND, Color.RED);
        }
    };
    public static final /* enum */ Look CTRL_EXIT_TRANS = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.EDGE_SOURCE_SHAPE, (Object)EdgeEnd.DOUBLE_LINE);
        }
    };
    public static final /* enum */ Look CTRL_OMEGA_EXIT_TRANS = new Look(true, CTRL_OMEGA_TRANS, CTRL_EXIT_TRANS);
    public static final /* enum */ Look STATE = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.OVAL);
        }
    };
    public static final /* enum */ Look START = new Look(true, new Look[]{STATE}){

        @Override
        void init() {
            this.add(VisualKey.FOREGROUND, Values.START_FOREGROUND);
            this.add(VisualKey.BACKGROUND, Values.START_BACKGROUND);
        }
    };
    public static final /* enum */ Look TRANS = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.EDGE_TARGET_SHAPE, (Object)EdgeEnd.SIMPLE);
        }
    };
    public static final /* enum */ Look OPEN = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.BACKGROUND, Values.OPEN_BACKGROUND);
        }

        @Override
        public void apply(VisualMap map) {
            boolean isStart = map.getBackground() == Values.START_BACKGROUND;
            super.apply(map);
            if (isStart) {
                map.put(VisualKey.BACKGROUND, Values.START_OPEN_BACKGROUND, false);
            }
        }
    };
    public static final /* enum */ Look FINAL = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.BACKGROUND, Values.FINAL_BACKGROUND);
        }
    };
    public static final /* enum */ Look RESULT = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.BACKGROUND, Values.RESULT_BACKGROUND);
        }
    };
    public static final /* enum */ Look TRANSIENT = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.DIAMOND);
            this.add(VisualKey.FOREGROUND, Values.TRANSIENT_COLOR);
        }
    };
    public static final /* enum */ Look ABSENT = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.DASH, Values.ABSENT_DASH);
        }
    };
    public static final /* enum */ Look ACTIVE = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.FOREGROUND, Values.ACTIVE_COLOR);
            this.add(VisualKey.LINE_WIDTH, Float.valueOf(3.0f));
        }

        @Override
        public void apply(VisualMap map) {
            boolean isTransient = map.getForeground() == Values.TRANSIENT_COLOR;
            boolean isStart = map.getForeground() == Values.START_FOREGROUND;
            super.apply(map);
            if (isTransient || isStart) {
                map.put(VisualKey.FOREGROUND, isTransient ? Values.TRANSIENT_ACTIVE_COLOR : Values.ACTIVE_START_COLOR, false);
            }
        }
    };
    public static final /* enum */ Look PATTERN = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.BACKGROUND, Values.NORMAL_BACKGROUND);
            this.add(VisualKey.DASH, Values.NESTED_DASH);
            this.add(VisualKey.INSET, 8);
            this.add(VisualKey.FONT, 0);
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.RECTANGLE);
        }
    };
    public static final /* enum */ Look EQUIV_CLASS = new Look(true, new Look[]{BASIC}){

        @Override
        void init() {
            this.add(VisualKey.OPAQUE, false);
            this.add(VisualKey.DASH, Values.NESTED_DASH);
            this.add(VisualKey.INSET, 8);
            this.add(VisualKey.NODE_SHAPE, (Object)NodeShape.RECTANGLE);
            this.add(VisualKey.FOREGROUND, Values.DEFAULT_FOREGROUND);
        }
    };
    public static final /* enum */ Look GRAYED_OUT = new Look(new Look[0]){

        @Override
        void init() {
            this.add(VisualKey.FOREGROUND, Colors.findColor("200 200 200 100"));
            this.add(VisualKey.OPAQUE, false);
        }
    };
    private final VisualMap visuals;
    private final boolean structural;
    private static final Map<Set<Look>, VisualMap> looksMap;
    private static final Map<AspectKind, Look> aspectLookMap;
    private static final /* synthetic */ Look[] ENUM$VALUES;

    static {
        ENUM$VALUES = new Look[]{BASIC, BIDIRECTIONAL, NODIFIED, NO_ARROW, REGULAR, TYPE, SUBTYPE, COMPOSITE, ABSTRACT, REMARK, EMBARGO, CONNECT, ERASER, CREATOR, ADDER, NESTING, PRODUCT, DATA, CTRL_TRANSIENT_STATE, CTRL_OMEGA_TRANS, CTRL_EXIT_TRANS, CTRL_OMEGA_EXIT_TRANS, STATE, START, TRANS, OPEN, FINAL, RESULT, TRANSIENT, ABSENT, ACTIVE, PATTERN, EQUIV_CLASS, GRAYED_OUT};
        looksMap = new HashMap<Set<Look>, VisualMap>();
        aspectLookMap = new EnumMap<AspectKind, Look>(AspectKind.class);
        aspectLookMap.put(AspectKind.REMARK, REMARK);
        aspectLookMap.put(AspectKind.CREATOR, CREATOR);
        aspectLookMap.put(AspectKind.EMBARGO, EMBARGO);
        aspectLookMap.put(AspectKind.ERASER, ERASER);
        aspectLookMap.put(AspectKind.CONNECT, CONNECT);
        aspectLookMap.put(AspectKind.CREATOR, CREATOR);
        aspectLookMap.put(AspectKind.ADDER, ADDER);
        aspectLookMap.put(AspectKind.FORALL, NESTING);
        aspectLookMap.put(AspectKind.FORALL_POS, NESTING);
        aspectLookMap.put(AspectKind.EXISTS, NESTING);
        aspectLookMap.put(AspectKind.EXISTS_OPT, NESTING);
        aspectLookMap.put(AspectKind.NESTED, NESTING);
        aspectLookMap.put(AspectKind.COMPOSITE, COMPOSITE);
        aspectLookMap.put(AspectKind.SUBTYPE, SUBTYPE);
        aspectLookMap.put(AspectKind.ABSTRACT, ABSTRACT);
        aspectLookMap.put(AspectKind.BOOL, DATA);
        aspectLookMap.put(AspectKind.INT, DATA);
        aspectLookMap.put(AspectKind.STRING, DATA);
        aspectLookMap.put(AspectKind.REAL, DATA);
        aspectLookMap.put(AspectKind.PRODUCT, PRODUCT);
    }

    private Look(Look ... templates) {
        this(false, templates);
    }

    private Look(boolean structural, Look ... templates) {
        this.structural = structural;
        this.visuals = new VisualMap();
        Look[] lookArray = templates;
        int n2 = templates.length;
        int n3 = 0;
        while (n3 < n2) {
            Look template = lookArray[n3];
            template.apply(this.visuals);
            ++n3;
        }
        this.init();
        this.visuals.setFixed();
    }

    void init() {
    }

    void add(VisualKey key, Object value) {
        assert (key.getNature() == VisualKey.Nature.DERIVED || key.getNature() == VisualKey.Nature.REFRESHABLE);
        this.visuals.put(key, value, false);
    }

    public VisualMap getVisuals() {
        return this.visuals;
    }

    public void apply(VisualMap map) {
        map.putAll(this.getVisuals());
    }

    public boolean isStructural() {
        return this.structural;
    }

    public static VisualMap getVisualsFor(Set<Look> looks) {
        VisualMap result = looksMap.get(looks);
        if (result == null) {
            result = new VisualMap();
            looksMap.put(looks, result);
            for (Look look : looks) {
                look.apply(result);
            }
            result.setFixed();
        }
        return result;
    }

    public static Look getLookFor(AspectKind aspect) {
        Look result = aspectLookMap.get((Object)aspect);
        if (result == null) {
            result = BASIC;
        }
        return result;
    }

    public static Look[] values() {
        Look[] lookArray = ENUM$VALUES;
        int n = lookArray.length;
        Look[] lookArray2 = new Look[n];
        System.arraycopy(ENUM$VALUES, 0, lookArray2, 0, n);
        return lookArray2;
    }

    public static Look valueOf(String string) {
        return Enum.valueOf(Look.class, string);
    }

    /* synthetic */ Look(String string, int n, boolean bl, Look[] lookArray, Look look) {
        this(bl, lookArray);
    }

    /* synthetic */ Look(String string, int n, Look[] lookArray, Look look) {
        this(lookArray);
    }
}

