/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.menu;

import groove.gui.action.LayoutAction;
import groove.gui.jgraph.JGraph;
import groove.gui.layout.ForestLayouter;
import groove.gui.layout.LayoutKind;
import groove.gui.layout.Layouter;
import groove.gui.layout.SpringLayouter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SetLayoutMenu
extends JMenu {
    private final JGraph<?> jgraph;
    private final JMenuItem layoutItem = new JMenuItem(){

        @Override
        public String getText() {
            Action action = this.getAction();
            if (action == null) {
                return super.getText();
            }
            return (String)action.getValue("Name");
        }
    };

    public SetLayoutMenu(JGraph<?> jgraph, Layouter initialLayout) {
        super("Set layouter");
        this.jgraph = jgraph;
        this.addLayoutItem(initialLayout);
    }

    public SetLayoutMenu(JGraph<?> jgraph) {
        this(jgraph, new ForestLayouter());
        this.addLayoutItem(new SpringLayouter());
        this.addSeparator();
        LayoutKind[] layoutKindArray = LayoutKind.values();
        int n = layoutKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutKind kind = layoutKindArray[n2];
            this.addLayoutItem(LayoutKind.getLayouterItemProto(kind));
            ++n2;
        }
    }

    public JMenuItem getCurrentLayoutItem() {
        return this.layoutItem;
    }

    public JMenuItem addLayoutItem(Layouter prototypeLayout) {
        JMenuItem result = this.add(this.createLayoutItem(prototypeLayout));
        if (this.getItemCount() == 1) {
            this.selectLayoutAction(prototypeLayout);
        }
        return result;
    }

    public LayoutAction selectLayoutAction(Layouter prototypeLayout) {
        this.jgraph.setLayouter(prototypeLayout);
        LayoutAction result = this.jgraph.getLayoutAction();
        this.layoutItem.setAction(result);
        int i = 0;
        while (i < this.getMenuComponentCount()) {
            Component item = this.getMenuComponent(i);
            if (item instanceof LayoutItem) {
                LayoutItem layoutItem = (LayoutItem)item;
                layoutItem.setSelected(layoutItem.layouter.getName().equals(prototypeLayout.getName()));
            }
            ++i;
        }
        return result;
    }

    protected LayoutItem createLayoutItem(Layouter prototypeLayout) {
        return new LayoutItem(prototypeLayout);
    }

    private class LayoutItem
    extends JCheckBoxMenuItem {
        final Layouter layouter;

        LayoutItem(Layouter layouter) {
            this.layouter = layouter;
            this.setAction(new AbstractAction(layouter.getName()){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SetLayoutMenu.this.selectLayoutAction(LayoutItem.this.layouter).actionPerformed(null);
                }
            });
        }
    }
}

