/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.model.ResourceModel;
import groove.gui.display.ResourceDisplay;
import groove.gui.tree.DisplayTreeNode;
import groove.io.HTMLConverter;
import javax.swing.Icon;

public class ResourceTreeNode
extends DisplayTreeNode {
    private final ResourceDisplay display;

    public ResourceTreeNode(ResourceDisplay display, String resourceName) {
        this(display, resourceName, false);
    }

    protected ResourceTreeNode(ResourceDisplay display, String resourceName, boolean allowsChildren) {
        super(resourceName, allowsChildren);
        this.display = display;
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    @Override
    public Icon getIcon() {
        return this.getDisplay().getListIcon(this.getName());
    }

    @Override
    public boolean isError() {
        return this.getDisplay().hasError(this.getName());
    }

    @Override
    public boolean isEnabled() {
        return this.getDisplay().getResource(this.getName()).isEnabled();
    }

    @Override
    public String getText() {
        return this.getDisplay().getLabelText(this.getName());
    }

    @Override
    public String getTip() {
        StringBuilder result = new StringBuilder();
        switch (this.getDisplay().getResourceKind()) {
            case HOST: {
                result.append("Host graph ");
                break;
            }
            case RULE: {
                result.append("Rule ");
                break;
            }
            case TYPE: {
                result.append("Type graph ");
            }
        }
        result.append(HTMLConverter.STRONG_TAG.on(this.getName()));
        HTMLConverter.HTML_TAG.on(result);
        return result.toString();
    }

    protected ResourceModel<?> getResource() {
        return this.getDisplay().getResource(this.getName());
    }

    protected ResourceDisplay getDisplay() {
        return this.display;
    }
}

