/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeNode;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.action.CollapseAllAction;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.jgraph.JModel;
import groove.gui.tree.CheckboxTree;
import groove.gui.tree.LabelFilter;
import groove.gui.tree.LabelTree;
import groove.gui.tree.TypeFilter;
import groove.io.HTMLConverter;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jgraph.event.GraphModelEvent;

public class TypeTree
extends LabelTree<AspectGraph> {
    private Observer jModelChangeListener;
    private TypeGraph typeGraph;
    private boolean showsAllLabels = false;
    private boolean showsSubtypes = true;
    private JToggleButton showSubtypesButton;
    private JToggleButton showSupertypesButton;
    private JToggleButton showAllLabelsButton;
    private JButton collapseAllButton;

    public TypeTree(AspectJGraph jGraph, boolean filtering) {
        super(jGraph, filtering);
    }

    @Override
    void installJModelListeners(JModel<AspectGraph> jModel) {
        super.installJModelListeners(jModel);
        ((AspectJModel)jModel).addGraphChangeListener(this.getJModelChangeListener());
    }

    @Override
    void removeJModelListeners(JModel<AspectGraph> jModel) {
        super.removeJModelListeners(jModel);
        ((AspectJModel)jModel).removeGraphChangeListener(this.getJModelChangeListener());
    }

    private Observer getJModelChangeListener() {
        if (this.jModelChangeListener == null) {
            this.jModelChangeListener = new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    TypeTree.this.updateModel();
                }
            };
        }
        return this.jModelChangeListener;
    }

    public JToolBar createToolBar() {
        JToolBar result = Options.createToolBar();
        result.add(this.getShowSubtypesButton());
        result.add(this.getShowSupertypesButton());
        result.addSeparator();
        result.add(this.getShowAllLabelsButton());
        result.add(this.getCollapseAllButton());
        ButtonGroup modeButtonGroup = new ButtonGroup();
        modeButtonGroup.add(this.getShowSubtypesButton());
        modeButtonGroup.add(this.getShowSupertypesButton());
        return result;
    }

    TypeFilter createLabelFilter() {
        return new TypeFilter();
    }

    TypeFilter getFilter() {
        return (TypeFilter)super.getFilter();
    }

    private JToggleButton getShowSubtypesButton() {
        if (this.showSubtypesButton == null) {
            this.showSubtypesButton = Options.createToggleButton(new ShowModeAction(true));
            this.showSubtypesButton.setSelected(true);
        }
        return this.showSubtypesButton;
    }

    private JToggleButton getShowSupertypesButton() {
        if (this.showSupertypesButton == null) {
            this.showSupertypesButton = Options.createToggleButton(new ShowModeAction(false));
        }
        return this.showSupertypesButton;
    }

    private JToggleButton getShowAllLabelsButton() {
        if (this.showAllLabelsButton == null) {
            this.showAllLabelsButton = Options.createToggleButton(new ShowAllLabelsAction());
        }
        return this.showAllLabelsButton;
    }

    private JButton getCollapseAllButton() {
        if (this.collapseAllButton == null) {
            CollapseAllAction action = new CollapseAllAction(null, this);
            this.collapseAllButton = Options.createButton(action);
        }
        return this.collapseAllButton;
    }

    private TypeGraph getTypeGraph() {
        TypeGraph result = null;
        if (this.getJGraph().getModel() != null) {
            result = ((AspectJGraph)this.getJGraph()).getModel().getTypeGraph();
        }
        return result;
    }

    @Override
    boolean isModelStale() {
        return super.isModelStale() || this.typeGraph != this.getTypeGraph();
    }

    @Override
    void clearFilter() {
        if (this.typeGraph == this.getTypeGraph()) {
            this.getFilter().clearJCells();
        } else {
            this.typeGraph = this.getTypeGraph();
            this.getFilter().clear();
        }
    }

    @Override
    void updateFilter() {
        for (TypeNode node : this.getTypeGraph().nodeSet()) {
            this.getFilter().addEntry(node);
        }
        for (TypeEdge edge : this.getTypeGraph().edgeSet()) {
            this.getFilter().addEntry(edge);
        }
        super.updateFilter();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getShowAllLabelsButton().setEnabled(enabled);
        this.getShowSubtypesButton().setEnabled(enabled);
        this.getShowSupertypesButton().setEnabled(enabled);
        this.getCollapseAllButton().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void graphChanged(GraphModelEvent e) {
        if (this.isModelStale()) {
            this.updateModel();
        } else {
            super.graphChanged(e);
        }
    }

    @Override
    List<CheckboxTree.TreeNode> fillTree() {
        List<CheckboxTree.TreeNode> result = new ArrayList<CheckboxTree.TreeNode>();
        TypeGraph typeGraph = this.getTypeGraph();
        if (typeGraph != null) {
            Collection<TypeGraph.Sub> typeGraphMap = typeGraph.getComponentMap().values();
            if (typeGraphMap.isEmpty()) {
                result = this.fillTree(this.getTopNode(), this.getTypeGraph().nodeSet(), this.getTypeGraph().edgeSet());
            } else if (typeGraphMap.size() == 1) {
                TypeGraph.Sub subTypeGraph = typeGraphMap.iterator().next();
                result = this.fillTree(this.getTopNode(), subTypeGraph.getNodes(), subTypeGraph.getEdges());
            } else {
                result = new ArrayList();
                for (TypeGraph.Sub subTypeGraph : typeGraphMap) {
                    TypeGraphTreeNode typeGraphNode = new TypeGraphTreeNode(subTypeGraph);
                    result.addAll(this.fillTree(typeGraphNode, subTypeGraph.getNodes(), subTypeGraph.getEdges()));
                    if (typeGraphNode.getChildCount() <= 0) continue;
                    this.getTopNode().add(typeGraphNode);
                    result.add(typeGraphNode);
                }
            }
        }
        return result;
    }

    private List<CheckboxTree.TreeNode> fillTree(DefaultMutableTreeNode topNode, Set<? extends TypeNode> typeNodes, Set<? extends TypeEdge> typeEdges) {
        ArrayList<CheckboxTree.TreeNode> result = new ArrayList<CheckboxTree.TreeNode>();
        Map<TypeNode, Set<TypeNode>> relatedMap = this.isShowsSubtypes() ? this.getTypeGraph().getDirectSubtypeMap() : this.getTypeGraph().getDirectSupertypeMap();
        for (TypeNode typeNode : new TreeSet<TypeNode>(typeNodes)) {
            if (typeNode.isDataType()) continue;
            TypeFilter.TypeEntry entry = this.getFilter().getEntry(typeNode);
            if (!this.isShowsAllLabels() && !this.getFilter().hasJCells(entry)) continue;
            TypedEntryNode nodeTypeNode = new TypedEntryNode(this, entry, true);
            topNode.add(nodeTypeNode);
            result.add(nodeTypeNode);
            this.addRelatedTypes(typeNodes, nodeTypeNode, relatedMap, result);
            if (typeNode.isTopType()) continue;
            HashSet<TypeFilter.TypeEntry> entries = new HashSet<TypeFilter.TypeEntry>();
            for (TypeEdge edge : new TreeSet(this.getTypeGraph().outEdgeSet(typeNode))) {
                TypeFilter.TypeEntry edgeEntry;
                if (!typeEdges.contains(edge) || !entries.add(edgeEntry = this.getFilter().getEntry(edge))) continue;
                TypedEntryNode edgeTypeNode = new TypedEntryNode(this, edgeEntry, true);
                nodeTypeNode.add(edgeTypeNode);
                result.add(edgeTypeNode);
            }
        }
        if (this.getTypeGraph().isImplicit()) {
            HashSet<TypeFilter.TypeEntry> hashSet = new HashSet<TypeFilter.TypeEntry>();
            for (TypeEdge typeEdge : typeEdges) {
                TypeFilter.TypeEntry edgeEntry = this.getFilter().getEntry(typeEdge);
                if (!this.isShowsAllLabels() && !this.getFilter().hasJCells(edgeEntry) || !hashSet.add(edgeEntry)) continue;
                TypedEntryNode edgeTypeNode = new TypedEntryNode(this, edgeEntry, true);
                topNode.add(edgeTypeNode);
                result.add(edgeTypeNode);
            }
        }
        return result;
    }

    private void addRelatedTypes(Set<? extends TypeNode> typeNodes, TypedEntryNode typeNode, Map<TypeNode, Set<TypeNode>> map, List<CheckboxTree.TreeNode> newNodes) {
        TypeNode type = (TypeNode)typeNode.getEntry().getType();
        Set<TypeNode> relatedTypes = map.get(type);
        assert (relatedTypes != null) : String.format("Node type '%s' does not occur in type graph '%s'", type, map.keySet());
        for (TypeNode relType : relatedTypes) {
            if (!typeNodes.contains(relType)) continue;
            TypedEntryNode subTypeNode = new TypedEntryNode(this, relType, false);
            typeNode.add(subTypeNode);
            if (newNodes != null) {
                newNodes.add(typeNode);
            }
            this.addRelatedTypes(typeNodes, subTypeNode, map, null);
        }
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof TypeGraphTreeNode) {
            StringBuilder result = new StringBuilder();
            result.append("Type graph '");
            result.append(((TypeGraphTreeNode)value).getName());
            result.append("'");
            return HTMLConverter.HTML_TAG.on(HTMLConverter.ITALIC_TAG.on(HTMLConverter.STRONG_TAG.on(result))).toString();
        }
        return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    private boolean isShowsSubtypes() {
        return this.showsSubtypes;
    }

    private void setShowsSubtypes(boolean show) {
        this.showsSubtypes = show;
    }

    private boolean isShowsAllLabels() {
        return this.showsAllLabels;
    }

    private void setShowsAllLabels(boolean show) {
        this.showsAllLabels = show;
    }

    static Icon getModeIcon(boolean subtypes) {
        return subtypes ? Icons.ARROW_OPEN_UP_ICON : Icons.ARROW_OPEN_DOWN_ICON;
    }

    private class ShowAllLabelsAction
    extends AbstractAction {
        public ShowAllLabelsAction() {
            super(null, Icons.E_A_CHOICE_ICON);
            this.putValue("ShortDescription", this.computeName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TypeTree.this.setShowsAllLabels(!TypeTree.this.isShowsAllLabels());
            TypeTree.this.setName(this.computeName());
            this.putValue("ShortDescription", this.computeName());
            TypeTree.this.updateTree();
        }

        private String computeName() {
            return TypeTree.this.isShowsAllLabels() ? "Show only existing labels" : "Show all labels";
        }
    }

    private class ShowModeAction
    extends AbstractAction {
        private final boolean subtypes;

        public ShowModeAction(boolean subtypes) {
            super(null, TypeTree.getModeIcon(subtypes));
            this.subtypes = subtypes;
            this.putValue("ShortDescription", this.computeName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TypeTree.this.isShowsSubtypes() != this.subtypes) {
                TypeTree.this.setShowsSubtypes(this.subtypes);
                TypeTree.this.updateTree();
            }
        }

        private String computeName() {
            return this.subtypes ? "Show subtypes" : "Show supertypes";
        }
    }

    public class TypeGraphTreeNode
    extends CheckboxTree.TreeNode {
        private final String name;
        private final Set<LabelFilter.Entry> entries = new HashSet<LabelFilter.Entry>();

        TypeGraphTreeNode(TypeGraph.Sub subTypeGraph) {
            this.name = subTypeGraph.getName();
            for (TypeNode node : subTypeGraph.getNodes()) {
                this.entries.add(TypeTree.this.getFilter().getEntry(node));
            }
            for (TypeEdge edge : subTypeGraph.getEdges()) {
                this.entries.add(TypeTree.this.getFilter().getEntry(edge));
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeGraphTreeNode)) {
                return false;
            }
            TypeGraphTreeNode other = (TypeGraphTreeNode)obj;
            return this.name.equals(other.name);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public boolean hasCheckbox() {
            return true;
        }

        @Override
        public boolean isSelected() {
            return TypeTree.this.getFilter().isSelected(this.entries);
        }

        @Override
        public void setSelected(boolean selected) {
            TypeTree.this.getFilter().setSelected(this.entries, selected);
        }

        @Override
        public final String toString() {
            return String.format("Type graph '%s'", this.name);
        }
    }

    public class TypedEntryNode
    extends LabelTree.EntryNode {
        TypedEntryNode(TypeTree tree, TypeElement key, boolean topNode) {
            this(tree, typeTree.getFilter().getEntry(key), topNode);
        }

        TypedEntryNode(TypeTree tree, TypeFilter.TypeEntry entry, boolean topNode) {
            super(tree, entry, topNode);
        }

        @Override
        public TypeFilter.TypeEntry getEntry() {
            return (TypeFilter.TypeEntry)super.getEntry();
        }

        @Override
        public Icon getIcon() {
            if (!this.isTopNode()) {
                return TypeTree.getModeIcon(TypeTree.this.isShowsSubtypes());
            }
            return super.getIcon();
        }
    }
}

