/*
 * Decompiled with CFR 0.152.
 */
package groove.io;

import groove.io.ExtensionFilter;
import groove.io.FileType;
import java.io.File;
import java.util.EnumSet;

public final class CompositeExtensionFilter
extends ExtensionFilter {
    private final ExtensionFilter[] filters;

    public CompositeExtensionFilter(EnumSet<FileType> fileTypes, String description, boolean acceptDir) {
        super(description, acceptDir);
        int size = fileTypes.size();
        FileType[] fileType = new FileType[size];
        fileTypes.toArray(fileType);
        this.filters = new ExtensionFilter[size];
        int i = 0;
        while (i < size) {
            this.filters[i] = FileType.getFilter(fileType[i]);
            ++i;
        }
    }

    @Override
    public boolean accept(File file) {
        boolean result;
        boolean bl = result = this.isAcceptDirectories() && file.isDirectory();
        if (!result) {
            ExtensionFilter[] extensionFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                ExtensionFilter filter = extensionFilterArray[n2];
                if (filter.acceptExtension(file)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public boolean acceptExtension(File file) {
        boolean result = false;
        ExtensionFilter[] extensionFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            ExtensionFilter filter = extensionFilterArray[n2];
            if (filter.acceptExtension(file)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String getExtension() {
        return this.filters[0].getExtension();
    }

    @Override
    public String stripExtension(String fileName) {
        File file = new File(fileName);
        ExtensionFilter[] extensionFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            ExtensionFilter filter = extensionFilterArray[n2];
            if (filter.acceptExtension(file)) {
                return filter.stripExtension(fileName);
            }
            ++n2;
        }
        return fileName;
    }
}

