/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.configuration;

import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.schema.Configuration;
import groove.io.conceptual.configuration.schema.Global;
import groove.io.conceptual.configuration.schema.IdModeType;
import groove.io.conceptual.configuration.schema.NullableType;
import groove.io.conceptual.configuration.schema.OrderType;
import groove.io.conceptual.configuration.schema.StringsType;
import groove.io.conceptual.lang.groove.GrooveUtil;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.property.Property;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.xml.sax.InputSource;

public class Config {
    private String m_xmlPath;
    private Configuration m_xmlConfig;
    private JAXBContext jaxbContext = null;
    private Unmarshaller unmarshaller = null;
    public static final String CONFIG_SCHEMA = "groove/io/conceptual/configuration/ConfigSchema.xsd";
    private HashMap<Id, String> m_mappedIds = new HashMap();
    private HashMap<String, Id> m_mappedNames = new HashMap();
    private Set<String> m_suffixList = new HashSet<String>();
    private TypeModel m_activeTypeModel;

    public Config(GrammarModel grammar, String xml) {
        this.m_xmlPath = xml;
        try {
            Configuration xmlCfg;
            this.jaxbContext = JAXBContext.newInstance((String)"groove.io.conceptual.configuration.schema");
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
            String xmlString = (String)grammar.getResource(ResourceKind.CONFIG, this.m_xmlPath).toResource();
            Object obj = this.unmarshaller.unmarshal(new InputSource(new StringReader(xmlString)));
            this.m_xmlConfig = xmlCfg = (Configuration)obj;
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to parse configuration " + this.m_xmlPath, e);
        }
        catch (FormatException formatException) {}
        this.loadIdInfo();
    }

    public Config(String xml) {
        this.m_xmlPath = xml;
        try {
            Configuration xmlCfg;
            Object obj = this.unmarshaller.unmarshal(new InputSource(new StringReader(xml)));
            this.m_xmlConfig = xmlCfg = (Configuration)obj;
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to parse configuration " + this.m_xmlPath, e);
        }
        this.loadIdInfo();
    }

    public void setTypeModel(TypeModel typeModel) {
        this.m_activeTypeModel = typeModel;
    }

    public TypeModel getTypeModel() {
        return this.m_activeTypeModel;
    }

    private void loadIdInfo() {
        for (Global.IdOverrides idOvr : this.m_xmlConfig.getGlobal().getIdOverrides()) {
            String name = idOvr.getName();
            String[] idStr = idOvr.getId().split("\\.");
            Id id = Id.ROOT;
            String[] stringArray = idStr;
            int n = idStr.length;
            int n2 = 0;
            while (n2 < n) {
                String idName = stringArray[n2];
                id = Id.getId(id, Name.getName(idName));
                ++n2;
            }
            this.m_mappedIds.put(id, name);
            this.m_mappedNames.put(name, id);
        }
        if (!this.m_xmlConfig.getTypeModel().isMetaSchema()) {
            if (!this.m_xmlConfig.getGlobal().getStrings().getProperPostfix().isEmpty()) {
                this.m_suffixList.add(this.m_xmlConfig.getGlobal().getStrings().getProperPostfix());
            }
            if (!this.m_xmlConfig.getGlobal().getStrings().getNullablePostfix().isEmpty()) {
                this.m_suffixList.add(this.m_xmlConfig.getGlobal().getStrings().getNullablePostfix());
            }
            if (!this.m_xmlConfig.getGlobal().getStrings().getEnumPostfix().isEmpty()) {
                this.m_suffixList.add(this.m_xmlConfig.getGlobal().getStrings().getEnumPostfix());
            }
            if (!this.m_xmlConfig.getGlobal().getStrings().getDataPostfix().isEmpty()) {
                this.m_suffixList.add(this.m_xmlConfig.getGlobal().getStrings().getDataPostfix());
            }
            if (!this.m_xmlConfig.getGlobal().getStrings().getTuplePostfix().isEmpty()) {
                this.m_suffixList.add(this.m_xmlConfig.getGlobal().getStrings().getTuplePostfix());
            }
        }
    }

    public Configuration getConfig() {
        return this.m_xmlConfig;
    }

    public String idToName(Id id) {
        if (this.m_mappedIds.containsKey(id)) {
            return this.m_mappedIds.get(id);
        }
        id = GrooveUtil.getSafeId(id);
        String name = id.getName().toString();
        IdModeType mode = this.m_xmlConfig.getGlobal().getIdMode();
        if (mode.equals((Object)IdModeType.FLAT)) {
            return id.getName().toString();
        }
        if (mode.equals((Object)IdModeType.DISAMBIGUATE) && this.m_activeTypeModel != null) {
            id = this.m_activeTypeModel.getShortId(id);
        }
        String sep = this.m_xmlConfig.getGlobal().getIdSeparator();
        while (id.getNamespace() != Id.ROOT) {
            if (this.m_mappedIds.containsKey(id.getNamespace())) {
                name = String.valueOf(this.m_mappedIds.get(id)) + sep + name;
                return name;
            }
            name = String.valueOf(id.getNamespace().getName().toString()) + sep + name;
            id = id.getNamespace();
        }
        return name;
    }

    public Id nameToId(String name) {
        for (String suffix : this.m_suffixList) {
            if (!name.endsWith(suffix)) continue;
            int end = name.length() - suffix.length() + 1;
            name = name.substring(0, end);
            break;
        }
        String sep = this.m_xmlConfig.getGlobal().getIdSeparator();
        String[] names = name.split("\\Q" + sep + "\\E");
        Id result = Id.ROOT;
        if (names.length > 0 && this.m_mappedNames.containsKey(names[0])) {
            result = this.m_mappedNames.get(names[0]);
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            Name n3 = Name.getName(part);
            result = Id.getId(result, n3);
            ++n2;
        }
        return result;
    }

    public boolean useIntermediate(Field f) {
        return this.useIntermediate(f, true);
    }

    public boolean useIntermediate(Field f, boolean recursive) {
        switch (this.m_xmlConfig.getTypeModel().getFields().getIntermediates().getWhen()) {
            case ALWAYS: {
                return true;
            }
            case CONTAINER: {
                if (f.getType() instanceof Container) {
                    return true;
                }
            }
            case REQUIRED: {
                if (this.m_xmlConfig.getTypeModel().getFields().isOpposites() && this.m_activeTypeModel != null) {
                    for (Property p : this.m_activeTypeModel.getProperties()) {
                        if (!(p instanceof OppositeProperty) || ((OppositeProperty)p).getField1() != f) continue;
                        return true;
                    }
                }
                if (this.getConfig().getGlobal().getNullable() == NullableType.NONE && f.getType() instanceof Container && ((Container)f.getType()).getType() instanceof Class && f.getLowerBound() == 0 && f.getUpperBound() == 1) {
                    return true;
                }
                if (recursive && f.getType() instanceof Container) {
                    return this.useIntermediate((Container)f.getType());
                }
                return false;
            }
        }
        return true;
    }

    public boolean useIntermediate(Container c) {
        switch (this.m_xmlConfig.getTypeModel().getFields().getIntermediates().getWhen()) {
            case ALWAYS: {
                return true;
            }
            case CONTAINER: {
                return true;
            }
            case REQUIRED: {
                boolean unique;
                boolean useIndex = this.useIndex(c);
                boolean bl = unique = c.getContainerType() == Container.Kind.SET || c.getContainerType() == Container.Kind.ORD;
                if (!unique) {
                    return true;
                }
                if (useIndex) {
                    return true;
                }
                if (c.getType() instanceof Container) {
                    return true;
                }
                if (c.getParent() != null) {
                    return true;
                }
                if (c.getField() != null) {
                    return this.useIntermediate(c.getField(), false);
                }
                return false;
            }
        }
        return false;
    }

    public boolean useIndex(Container c) {
        boolean useIndex = this.m_xmlConfig.getTypeModel().getFields().getContainers().getOrdering().getType() != OrderType.NONE;
        return useIndex &= c.getContainerType() == Container.Kind.ORD || c.getContainerType() == Container.Kind.SEQ;
    }

    public String getName(Type type) {
        boolean usePostfix = true;
        if (this.m_xmlConfig.getTypeModel().isMetaSchema()) {
            usePostfix = false;
        }
        String name = "type:";
        if (type instanceof Class) {
            Class cmClass = (Class)type;
            name = String.valueOf(name) + this.idToName(cmClass.getId());
            if (cmClass.isProper()) {
                if (usePostfix) {
                    name = String.valueOf(name) + this.m_xmlConfig.getGlobal().getStrings().getProperPostfix();
                }
            } else {
                name = String.valueOf(name) + this.m_xmlConfig.getGlobal().getStrings().getNullablePostfix();
            }
        } else if (type instanceof Enum) {
            name = String.valueOf(name) + this.idToName(((Enum)type).getId());
            if (usePostfix) {
                name = String.valueOf(name) + this.m_xmlConfig.getGlobal().getStrings().getEnumPostfix();
            }
        } else if (type instanceof CustomDataType) {
            name = String.valueOf(name) + this.idToName(((CustomDataType)type).getId());
            if (usePostfix) {
                name = String.valueOf(name) + this.m_xmlConfig.getGlobal().getStrings().getDataPostfix();
            }
        } else if (type instanceof Tuple) {
            name = this.m_activeTypeModel != null ? String.valueOf(name) + this.m_activeTypeModel.getTupleName((Tuple)type) : String.valueOf(name) + "tup";
            if (usePostfix) {
                name = String.valueOf(name) + this.m_xmlConfig.getGlobal().getStrings().getTuplePostfix();
            }
        } else if (type instanceof DataType) {
            name = String.valueOf(name) + ((DataType)type).typeString();
        } else if (type instanceof Container) {
            return null;
        }
        return name;
    }

    public String getName(Field field) {
        String classId = this.idToName(field.getDefiningClass().getId());
        return "type:" + classId + this.m_xmlConfig.getGlobal().getIdSeparator() + field.getName();
    }

    public String getContainerName(String base, Container c) {
        return String.valueOf(base) + this.m_xmlConfig.getGlobal().getIdSeparator() + this.getStrings().getIntermediateName();
    }

    public String getContainerPostfix(Container c) {
        String postfix = "";
        if (!this.getConfig().getTypeModel().isMetaSchema() && this.getConfig().getTypeModel().getFields().getContainers().isUseTypeName()) {
            postfix = "_";
            switch (c.getContainerType()) {
                case SET: {
                    postfix = String.valueOf(postfix) + this.getStrings().getMetaContainerSet();
                    break;
                }
                case BAG: {
                    postfix = String.valueOf(postfix) + this.getStrings().getMetaContainerBag();
                    break;
                }
                case ORD: {
                    postfix = String.valueOf(postfix) + this.getStrings().getMetaContainerOrd();
                    break;
                }
                case SEQ: {
                    postfix = String.valueOf(postfix) + this.getStrings().getMetaContainerSeq();
                }
            }
        }
        return postfix;
    }

    public StringsType getStrings() {
        return this.m_xmlConfig.getGlobal().getStrings();
    }

    public Collection<String> getSuffixes() {
        return this.m_suffixList;
    }
}

