/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.ecore;

import groove.io.Util;
import groove.io.conceptual.Timer;
import groove.io.conceptual.lang.ExportException;
import groove.io.conceptual.lang.ExportableResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class EcoreResource
extends ExportableResource {
    private ResourceSet m_resourceSet;
    private Map<String, Resource> m_typeResources = new HashMap<String, Resource>();
    private Map<String, Resource> m_instanceResources = new HashMap<String, Resource>();
    private File m_typeFile;
    private File m_instanceFile;
    private String relPath;

    public EcoreResource(File typeTarget, File instanceTarget) {
        this.m_resourceSet = new ResourceSetImpl();
        this.m_resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.m_typeFile = typeTarget;
        this.m_instanceFile = instanceTarget;
        this.relPath = this.m_typeFile == this.m_instanceFile || this.m_typeFile == null || this.m_instanceFile == null ? "" : Util.getRelativePath(new File(this.m_instanceFile.getAbsoluteFile().getParent()), this.m_typeFile.getAbsoluteFile()).toString();
    }

    public ResourceSet getResourceSet() {
        return this.m_resourceSet;
    }

    public String getTypePath() {
        return this.relPath;
    }

    public Resource getTypeResource(String resourceName) {
        if (this.m_typeFile != null) {
            resourceName = this.m_typeFile.toString();
        }
        if (this.m_typeResources.containsKey(resourceName)) {
            this.m_typeResources.get(resourceName);
        }
        Resource newResource = this.m_resourceSet.createResource(URI.createURI((String)resourceName));
        this.m_typeResources.put(resourceName, newResource);
        return newResource;
    }

    public Resource getInstanceResource(String resourceName) {
        if (this.m_instanceResources.containsKey(resourceName)) {
            this.m_instanceResources.get(resourceName);
        }
        Resource newResource = this.m_resourceSet.createResource(URI.createURI((String)resourceName));
        this.m_instanceResources.put(resourceName, newResource);
        return newResource;
    }

    @Override
    public boolean export() throws ExportException {
        try {
            FileOutputStream out;
            if (this.m_typeFile != null) {
                for (Map.Entry<String, Resource> resourceEntry : this.m_typeResources.entrySet()) {
                    out = new FileOutputStream(this.m_typeFile);
                    try {
                        int timer = Timer.cont("Ecore save");
                        resourceEntry.getValue().save((OutputStream)out, null);
                        Timer.stop(timer);
                    }
                    finally {
                        out.close();
                    }
                }
            }
            if (this.m_instanceFile != null) {
                for (Map.Entry<String, Resource> resourceEntry : this.m_instanceResources.entrySet()) {
                    out = new FileOutputStream(this.m_instanceFile);
                    try {
                        HashMap<String, Boolean> opts = new HashMap<String, Boolean>();
                        if (this.m_typeFile != null) {
                            opts.put("SCHEMA_LOCATION", true);
                        }
                        int timer = Timer.cont("Ecore save");
                        resourceEntry.getValue().save((OutputStream)out, opts);
                        Timer.stop(timer);
                    }
                    finally {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
        return true;
    }
}

