/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.ecore;

import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.InvalidTypeException;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.lang.TypeImporter;
import groove.io.conceptual.lang.ecore.EcoreUtil;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.IdentityProperty;
import groove.io.conceptual.property.KeysetProperty;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.Value;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class EcoreToType
extends TypeImporter {
    private Resource r = null;
    private ResourceSet rs = null;
    private String m_typeName = "ecore";
    private Map<String, Id> m_customDatatypeInstances = new HashMap<String, Id>();

    public EcoreToType(String typeModel) throws ImportException {
        this.rs = new ResourceSetImpl();
        this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        try {
            this.r = this.rs.createResource(URI.createURI((String)typeModel));
            FileInputStream in = new FileInputStream(typeModel);
            int timer = Timer.start("Load Ecore");
            try {
                this.r.load((InputStream)in, null);
            }
            finally {
                in.close();
            }
            org.eclipse.emf.ecore.util.EcoreUtil.resolveAll((ResourceSet)this.rs);
            Timer.stop(timer);
        }
        catch (FileNotFoundException e) {
            throw new ImportException("Cannot find file " + typeModel, e);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        int timer = Timer.start("Ecore to TM");
        this.buildTypeModel();
        Timer.stop(timer);
    }

    public ResourceSet getResourceSet() {
        return this.rs;
    }

    @Override
    public TypeModel getTypeModel(String modelName) {
        return (TypeModel)this.m_typeModels.get(modelName);
    }

    private void buildTypeModel() {
        TypeModel tm = new TypeModel(this.m_typeName);
        TreeIterator it = this.r.getAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj.eClass().getName().equals("EClass")) {
                this.visitClass(tm, (EClass)obj);
                continue;
            }
            if (obj.eClass().getName().equals("EEnum")) {
                this.visitEnum(tm, (EEnum)obj);
                continue;
            }
            if (obj.eClass().getName().equals("EPackage")) {
                this.visitPackage((EPackage)obj);
                continue;
            }
            if (!obj.eClass().getName().equals("EDataType")) continue;
            this.visitDataType(tm, (EDataType)obj);
        }
        tm.resolve();
        this.m_typeModels.put(this.m_typeName, tm);
    }

    private Class visitClass(TypeModel mm, EClass eClass) {
        if (eClass.eIsProxy()) {
            return mm.getClass(Id.getId(Id.ROOT, Name.getName("Proxy")), true);
        }
        Id clsID = EcoreUtil.idFromClassifier((EClassifier)eClass);
        if (mm.hasClass(clsID)) {
            return mm.getClass(clsID);
        }
        Class cmClass = mm.getClass(clsID, true);
        if (eClass.isAbstract() || eClass.isInterface()) {
            AbstractProperty p = new AbstractProperty(cmClass);
            mm.addProperty(p);
        }
        for (EAttribute eAttribute : eClass.getEAttributes()) {
            this.visitAttribute(mm, cmClass, eAttribute);
        }
        for (EReference eReference : eClass.getEReferences()) {
            this.visitReference(mm, cmClass, eReference);
        }
        for (EClass eSuperClass : eClass.getESuperTypes()) {
            Class superClass = this.visitClass(mm, eSuperClass);
            cmClass.addSuperClass(superClass);
        }
        if (eClass.getEIDAttribute() != null && eClass.getEIDAttribute().getEContainingClass() == eClass) {
            Name attrName = Name.getName(eClass.getEIDAttribute().getName());
            IdentityProperty p = new IdentityProperty(cmClass, attrName);
            mm.addProperty(p);
        }
        return cmClass;
    }

    private Type visitDataType(TypeModel mm, EDataType eDataType) {
        if (eDataType instanceof EEnum) {
            return this.visitEnum(mm, (EEnum)eDataType);
        }
        Id dataID = EcoreUtil.idFromClassifier((EClassifier)eDataType);
        if (mm.hasDatatype(dataID)) {
            return mm.getDatatype(dataID);
        }
        if (EcoreUtil.g_knownTypes.containsKey(eDataType.getName())) {
            return EcoreUtil.g_knownTypes.get(eDataType.getName());
        }
        CustomDataType cmDatatype = mm.getDatatype(dataID, true);
        this.m_customDatatypeInstances.put(eDataType.getInstanceClassName(), dataID);
        return cmDatatype;
    }

    private Enum visitEnum(TypeModel mm, EEnum eEnum) {
        Id enumID = EcoreUtil.idFromClassifier((EClassifier)eEnum);
        if (mm.hasEnum(enumID)) {
            return mm.getEnum(enumID);
        }
        Enum cmEnum = mm.getEnum(enumID, true);
        for (EEnumLiteral eEnumLiteral : eEnum.getELiterals()) {
            Name litName = Name.getName(eEnumLiteral.getName());
            cmEnum.addLiteral(litName);
        }
        return cmEnum;
    }

    private void visitAttribute(TypeModel mm, Class cmClass, EAttribute eAttribute) {
        Object value;
        Name attrName = Name.getName(eAttribute.getName());
        Type attribType = null;
        if (eAttribute.getEType() instanceof EEnum) {
            attribType = this.visitEnum(mm, (EEnum)eAttribute.getEType());
        } else if (eAttribute.getEType() instanceof EDataType) {
            attribType = this.visitDataType(mm, (EDataType)eAttribute.getEType());
            if (attribType == null) {
                this.addMessage(new Message("Unsupported EDataType " + eAttribute.getEType().getName(), Message.MessageType.ERROR));
            }
        } else {
            this.addMessage(new Message("Invalid type as attribute " + eAttribute, Message.MessageType.ERROR));
        }
        if (eAttribute.getUpperBound() > 1 || eAttribute.getUpperBound() == -1) {
            Container.Kind type = eAttribute.isUnique() ? (eAttribute.isOrdered() ? Container.Kind.ORD : Container.Kind.SET) : (eAttribute.isOrdered() ? Container.Kind.SEQ : Container.Kind.BAG);
            attribType = new Container(type, attribType);
        }
        if (eAttribute.getDefaultValue() != null && (value = eAttribute.getDefaultValue()) != eAttribute.getEType().getDefaultValue()) {
            try {
                Value defaultVal = this.objectToDataType(mm, attribType, value);
                if (!attribType.acceptValue(defaultVal)) {
                    this.addMessage(new Message("Incorrect value type of default value " + defaultVal, Message.MessageType.ERROR));
                } else {
                    mm.addProperty(new DefaultValueProperty(cmClass, attrName, defaultVal));
                }
            }
            catch (InvalidTypeException e) {
                this.addMessage(new Message(e.getMessage(), Message.MessageType.ERROR));
            }
        }
        cmClass.addField(new Field(Name.getName(eAttribute.getName()), attribType, eAttribute.getLowerBound(), eAttribute.getUpperBound()));
    }

    private void visitReference(TypeModel mm, Class cmClass, EReference eReference) {
        Name refName = Name.getName(eReference.getName());
        Type fieldType = null;
        if (eReference.getEType() instanceof EClass) {
            fieldType = this.visitClass(mm, (EClass)eReference.getEType());
        } else {
            this.addMessage(new Message("Invalid type as reference " + eReference, Message.MessageType.ERROR));
        }
        if (eReference.getEKeys().size() > 0) {
            ArrayList<Name> keyNames = new ArrayList<Name>();
            for (EAttribute attr : eReference.getEKeys()) {
                keyNames.add(Name.getName(attr.getName()));
            }
            KeysetProperty p = new KeysetProperty(cmClass, refName, (Class)fieldType, keyNames.toArray(new Name[keyNames.size()]));
            mm.addProperty(p);
        }
        if (eReference.getEOpposite() != null) {
            EReference eOpposite = eReference.getEOpposite();
            Name oppositeName = Name.getName(eOpposite.getName());
            Class oppositeClass = this.visitClass(mm, eOpposite.getEContainingClass());
            OppositeProperty p = new OppositeProperty(cmClass, refName, oppositeClass, oppositeName);
            mm.addProperty(p);
        }
        if (eReference.isContainment()) {
            ContainmentProperty p = new ContainmentProperty(cmClass, refName);
            mm.addProperty(p);
        }
        if (eReference.getDefaultValue() != null) {
            this.addMessage(new Message("eReference default value not supported"));
        }
        if (eReference.getUpperBound() > 1 || eReference.getUpperBound() == -1) {
            Container.Kind type = eReference.isUnique() ? (eReference.isOrdered() ? Container.Kind.ORD : Container.Kind.SET) : (eReference.isOrdered() ? Container.Kind.SEQ : Container.Kind.BAG);
            fieldType = new Container(type, fieldType);
        }
        cmClass.addField(new Field(refName, fieldType, eReference.getLowerBound(), eReference.getUpperBound()));
    }

    private void visitPackage(EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        if (nsURI == null) {
            nsURI = ePackage.getName();
            ePackage.setNsURI(nsURI);
        }
        this.rs.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value objectToDataType(TypeModel tm, Type type, Object ecoreValue) throws InvalidTypeException {
        void var4_8;
        if (!(type instanceof DataType)) {
            throw new InvalidTypeException("Cannot convert Ecore object to non-datatype in type model");
        }
        Object var4_4 = null;
        if (ecoreValue instanceof EEnumLiteral) {
            if (!(type instanceof Enum)) throw new InvalidTypeException("Type error in ecore type model");
            EnumValue enumValue = new EnumValue((Enum)type, Name.getName(((EEnumLiteral)ecoreValue).getName()));
            return var4_8;
        } else {
            if (ecoreValue instanceof EObject) {
                throw new InvalidTypeException("Unsupported value type: Object");
            }
            String className = ecoreValue.getClass().getCanonicalName();
            if (type instanceof CustomDataType) {
                if (!this.m_customDatatypeInstances.containsKey(className)) throw new InvalidTypeException("Unknown custom type: " + type);
                Id dataId = this.m_customDatatypeInstances.get(className);
                CustomDataType dt = tm.getDatatype(dataId);
                if (dt == null || !dt.equals(type)) {
                    throw new InvalidTypeException("Unknown type class: " + className);
                }
                Value value = dt.valueFromString(ecoreValue.toString());
                return var4_8;
            } else {
                if (!EcoreUtil.g_knownInstanceTypes.containsKey(className)) throw new InvalidTypeException("Unknown datatype requested: " + type);
                String typeString = EcoreUtil.g_knownInstanceTypes.get(className);
                Type knownType = EcoreUtil.g_knownTypes.get(typeString);
                if (!type.equals(knownType)) throw new InvalidTypeException("Type error in ecore type model");
                Value value = ((DataType)type).valueFromString(ecoreValue.toString());
            }
        }
        return var4_8;
    }
}

