/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.ecore;

import groove.io.conceptual.Acceptor;
import groove.io.conceptual.Field;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Timer;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.lang.InstanceExporter;
import groove.io.conceptual.lang.ecore.EcoreResource;
import groove.io.conceptual.lang.ecore.TypeToEcore;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.value.BoolValue;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.StringValue;
import groove.io.conceptual.value.TupleValue;
import groove.io.conceptual.value.Value;
import groove.io.external.PortException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class InstanceToEcore
extends InstanceExporter<Object>
implements Visitor {
    private TypeToEcore m_typeToEcore;
    private EcoreResource m_ecoreResource;
    private Set<EObject> m_eObjects = new HashSet<EObject>();

    public InstanceToEcore(TypeToEcore typeToEcore) {
        this.m_ecoreResource = (EcoreResource)typeToEcore.getResource();
        this.m_typeToEcore = typeToEcore;
    }

    @Override
    public void addInstanceModel(InstanceModel instanceModel) throws PortException {
        int timer = Timer.start("IM to Ecore");
        this.m_eObjects.clear();
        this.visitInstanceModel(instanceModel);
        ArrayList<EObject> rootObjects = new ArrayList<EObject>();
        for (EObject object : this.m_eObjects) {
            if (object.eContainer() != null) continue;
            rootObjects.add(object);
        }
        if (rootObjects.size() == 0) {
            throw new PortException("Unable to find any root object");
        }
        Timer.stop(timer);
        timer = Timer.cont("Ecore save");
        Resource typeResource = this.m_ecoreResource.getInstanceResource(String.valueOf(instanceModel.getName()) + "bababa");
        EList contents = typeResource.getContents();
        contents.addAll(rootObjects);
        Timer.stop(timer);
    }

    @Override
    public void visit(groove.io.conceptual.value.Object object, Object param) {
        if (this.hasElement(object)) {
            return;
        }
        Class cmClass = (Class)object.getType();
        EClass eClass = this.m_typeToEcore.getEClass(cmClass);
        EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.setElement(object, eObject);
        this.m_eObjects.add(eObject);
        for (Map.Entry fieldValue : object.getValue().entrySet()) {
            EStructuralFeature eFeature = this.m_typeToEcore.getEStructuralFeature((Field)fieldValue.getKey());
            if (fieldValue.getValue() == null || fieldValue.getValue() == groove.io.conceptual.value.Object.NIL) continue;
            if (eFeature.isMany()) {
                ContainerValue cv = (ContainerValue)fieldValue.getValue();
                EList objectList = (EList)eObject.eGet(eFeature);
                Iterator iterator = cv.getValue().iterator();
                while (iterator.hasNext()) {
                    Value subValue = (Value)iterator.next();
                    Object eSubValue = this.getElement(subValue);
                    assert (eSubValue != null);
                    if (objectList.contains(eSubValue)) continue;
                    objectList.add(eSubValue);
                }
                continue;
            }
            Object eValue = null;
            eValue = fieldValue.getValue() instanceof ContainerValue ? this.getElement((Acceptor)((ContainerValue)fieldValue.getValue()).getValue().get(0)) : this.getElement((Acceptor)fieldValue.getValue());
            eObject.eSet(eFeature, eValue);
        }
    }

    @Override
    public void visit(RealValue realval, Object param) {
        if (this.hasElement(realval)) {
            return;
        }
        EDataType eDataType = this.m_typeToEcore.getEDataType((DataType)realval.getType());
        Object eDoubleVal = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, realval.toString());
        this.setElement(realval, eDoubleVal);
    }

    @Override
    public void visit(StringValue stringval, Object param) {
        if (this.hasElement(stringval)) {
            return;
        }
        EDataType eDataType = this.m_typeToEcore.getEDataType((DataType)stringval.getType());
        Object eStringVal = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, stringval.toString());
        this.setElement(stringval, eStringVal);
    }

    @Override
    public void visit(IntValue intval, Object param) {
        if (this.hasElement(intval)) {
            return;
        }
        EDataType eDataType = this.m_typeToEcore.getEDataType((DataType)intval.getType());
        Object eIntVal = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, intval.toString());
        this.setElement(intval, eIntVal);
    }

    @Override
    public void visit(BoolValue boolval, Object param) {
        if (this.hasElement(boolval)) {
            return;
        }
        EDataType eDataType = this.m_typeToEcore.getEDataType((DataType)boolval.getType());
        Object eBoolVal = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, boolval.toString());
        this.setElement(boolval, eBoolVal);
    }

    @Override
    public void visit(EnumValue enumval, Object param) {
        if (this.hasElement(enumval)) {
            return;
        }
        EEnum eEnum = (EEnum)this.m_typeToEcore.getEDataType((Enum)enumval.getType());
        Object eEnumVal = eEnum.getEPackage().getEFactoryInstance().createFromString((EDataType)eEnum, enumval.getValue().toString());
        this.setElement(enumval, eEnumVal);
    }

    @Override
    public void visit(ContainerValue containerval, Object param) {
        Container container = (Container)containerval.getType();
        EClass containerClass = this.m_typeToEcore.getContainerClass(container);
        EObject containerObject = containerClass.getEPackage().getEFactoryInstance().create(containerClass);
        this.setElement(containerval, containerObject);
        this.m_eObjects.add(containerObject);
        EStructuralFeature eFeature = containerClass.getEStructuralFeature("value");
        EList objectList = (EList)containerObject.eGet(eFeature);
        Iterator iterator = containerval.getValue().iterator();
        while (iterator.hasNext()) {
            Value val = (Value)iterator.next();
            Object eSubValue = this.getElement(val);
            objectList.add(eSubValue);
        }
    }

    @Override
    public void visit(TupleValue tupleval, Object param) {
        if (this.hasElement(tupleval)) {
            return;
        }
        Tuple tuple = (Tuple)tupleval.getType();
        EClass tupleClass = this.m_typeToEcore.getTupleClass(tuple);
        EObject tupleObject = tupleClass.getEPackage().getEFactoryInstance().create(tupleClass);
        this.setElement(tupleval, tupleObject);
        this.m_eObjects.add(tupleObject);
        for (Map.Entry entry : tupleval.getValue().entrySet()) {
            String indexName = this.m_typeToEcore.getTupleElementName(tuple, (Integer)entry.getKey());
            EStructuralFeature eFeature = tupleClass.getEStructuralFeature(indexName);
            Value tupValue = (Value)entry.getValue();
            if (eFeature.isMany()) {
                ContainerValue cv = (ContainerValue)tupValue;
                EList objectList = (EList)tupleObject.eGet(eFeature);
                Iterator iterator = cv.getValue().iterator();
                while (iterator.hasNext()) {
                    Value subValue = (Value)iterator.next();
                    Object eSubValue = this.getElement(subValue);
                    objectList.add(eSubValue);
                }
                continue;
            }
            Object eValue = this.getElement(tupValue);
            tupleObject.eSet(eFeature, eValue);
        }
    }

    @Override
    public void visit(CustomDataValue dataval, Object param) {
        if (this.hasElement(dataval)) {
            return;
        }
        CustomDataType dataType = (CustomDataType)dataval.getType();
        EDataType eDataType = this.m_typeToEcore.getEDataType(dataType);
        Object eDataValue = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, dataval.getValue());
        this.setElement(dataval, eDataValue);
    }
}

