/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.ecore;

import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.lang.TypeExporter;
import groove.io.conceptual.lang.ecore.EcoreResource;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.IdentityProperty;
import groove.io.conceptual.property.KeysetProperty;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.type.BoolType;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.IntType;
import groove.io.conceptual.type.RealType;
import groove.io.conceptual.type.StringType;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.external.PortException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;

public class TypeToEcore
extends TypeExporter<EObject> {
    private static final EcoreFactory g_EcoreFactory = EcoreFactory.eINSTANCE;
    private static final EcorePackage g_EcorePackage = EcorePackage.eINSTANCE;
    private EcoreResource m_ecoreResource;
    private TypeModel m_currentTypeModel;
    private Map<Id, EPackage> m_packages = new HashMap<Id, EPackage>();
    private Set<EPackage> m_rootPackages = new HashSet<EPackage>();
    private int nrContainer = 0;

    public TypeToEcore(EcoreResource resource) {
        this.m_ecoreResource = resource;
    }

    @Override
    public ExportableResource getResource() {
        return this.m_ecoreResource;
    }

    @Override
    public void addTypeModel(TypeModel typeModel) throws PortException {
        int timer = Timer.start("TM to Ecore");
        this.m_currentTypeModel = typeModel;
        this.visitTypeModel(typeModel);
        Timer.stop(timer);
        timer = Timer.start("Ecore save");
        Resource typeResource = this.m_ecoreResource.getTypeResource(typeModel.getName());
        EList contents = typeResource.getContents();
        for (EPackage pkg : this.m_rootPackages) {
            contents.add((Object)pkg);
        }
        Timer.stop(timer);
    }

    public String getTupleName(Tuple tuple) {
        return this.m_currentTypeModel.getTupleName(tuple);
    }

    public String getTupleElementName(Tuple tuple, int index) {
        return "_" + index;
    }

    public EClass getTupleClass(Tuple tuple) {
        return (EClass)this.getElement(tuple);
    }

    public EClass getContainerClass(Container container) {
        return (EClass)this.getElement(container);
    }

    public EDataType getEDataType(DataType dataType) {
        return (EDataType)this.getElement(dataType);
    }

    public EClass getEClass(Class cmClass) {
        return (EClass)this.getElement(cmClass);
    }

    public EStructuralFeature getEStructuralFeature(Field field) {
        EStructuralFeature eFeature = (EStructuralFeature)this.getElement(field);
        return eFeature;
    }

    private EPackage packageFromId(Id id) {
        if (this.m_packages.containsKey(id)) {
            return this.m_packages.get(id);
        }
        if (id == Id.ROOT) {
            EPackage idPackage = g_EcoreFactory.createEPackage();
            idPackage.setName("ROOT");
            this.m_packages.put(id, idPackage);
            this.addMessage(new Message("A package (ROOT) was generated for the root namespace, please check your identifiers", Message.MessageType.WARNING));
            this.m_rootPackages.add(idPackage);
            return idPackage;
        }
        EPackage idPackage = g_EcoreFactory.createEPackage();
        idPackage.setName(id.getName().toString());
        idPackage.setNsPrefix(id.getName().toString());
        idPackage.setNsURI(id.getName().toString());
        this.m_packages.put(id, idPackage);
        if (id.getNamespace() != Id.ROOT) {
            EPackage topLevel = this.packageFromId(id.getNamespace());
            topLevel.getESubpackages().add((Object)idPackage);
        } else {
            this.m_rootPackages.add(idPackage);
        }
        return idPackage;
    }

    @Override
    public void visit(DataType t, Object param) {
        if (this.hasElement(t)) {
            return;
        }
        if (t instanceof StringType) {
            this.setElement(t, g_EcorePackage.getEString());
        } else if (t instanceof BoolType) {
            this.setElement(t, g_EcorePackage.getEBoolean());
        } else if (t instanceof IntType) {
            this.setElement(t, g_EcorePackage.getEInt());
        } else if (t instanceof RealType) {
            this.setElement(t, g_EcorePackage.getEFloat());
        } else if (t instanceof CustomDataType) {
            EDataType eDataType = g_EcoreFactory.createEDataType();
            this.setElement(t, eDataType);
            CustomDataType cmDataType = (CustomDataType)t;
            eDataType.setName(cmDataType.getId().getName().toString());
            eDataType.setInstanceClass(String.class);
            EPackage typePackage = this.packageFromId(cmDataType.getId().getNamespace());
            typePackage.getEClassifiers().add((Object)eDataType);
        }
    }

    @Override
    public void visit(Class cmClass, Object param) {
        if (this.hasElement(cmClass)) {
            return;
        }
        if (!cmClass.isProper()) {
            EObject propElem = (EObject)this.getElement(cmClass.getProperClass());
            if (!this.hasElement(cmClass)) {
                this.setElement(cmClass, propElem);
            }
            return;
        }
        EClass eClass = g_EcoreFactory.createEClass();
        this.setElement(cmClass, eClass);
        eClass.setName(cmClass.getId().getName().toString());
        EPackage classPackage = this.packageFromId(cmClass.getId().getNamespace());
        classPackage.getEClassifiers().add((Object)eClass);
        for (Class superClass : cmClass.getSuperClasses()) {
            EObject eObj = (EObject)this.getElement(superClass);
            eClass.getESuperTypes().add((Object)((EClass)eObj));
        }
        for (Field field : cmClass.getFields()) {
            EStructuralFeature eStructFeat = (EStructuralFeature)this.getElement(field);
            eClass.getEStructuralFeatures().add((Object)eStructFeat);
        }
    }

    @Override
    public void visit(Field field, Object param) {
        if (this.hasElement(field)) {
            return;
        }
        Type fieldType = field.getType();
        boolean ordered = true;
        boolean unique = true;
        if (fieldType instanceof Container) {
            Container cmContainer = (Container)fieldType;
            fieldType = cmContainer.getType();
            if (cmContainer.getContainerType() == Container.Kind.SET || cmContainer.getContainerType() == Container.Kind.BAG) {
                ordered = false;
            }
            if (cmContainer.getContainerType() == Container.Kind.BAG || cmContainer.getContainerType() == Container.Kind.SEQ) {
                unique = false;
            }
        }
        Object eFieldFeature = null;
        eFieldFeature = fieldType instanceof Class || fieldType instanceof Tuple || fieldType instanceof Container ? g_EcoreFactory.createEReference() : g_EcoreFactory.createEAttribute();
        this.setElement(field, eFieldFeature);
        eFieldFeature.setName(field.getName().toString());
        eFieldFeature.setOrdered(ordered);
        eFieldFeature.setUnique(unique);
        EObject eType = (EObject)this.getElement(fieldType);
        eFieldFeature.setEType((EClassifier)eType);
        if (field.getUpperBound() == -1) {
            eFieldFeature.setUpperBound(-1);
        } else {
            eFieldFeature.setUpperBound(field.getUpperBound());
        }
        if (field.getType() instanceof Class && !((Class)field.getType()).isProper()) {
            eFieldFeature.setLowerBound(0);
        } else {
            eFieldFeature.setLowerBound(field.getLowerBound());
        }
    }

    @Override
    public void visit(Container container, Object param) {
        if (this.hasElement(container)) {
            return;
        }
        EClass eContainerClass = g_EcoreFactory.createEClass();
        this.setElement(container, eContainerClass);
        ++this.nrContainer;
        eContainerClass.setName("ContainerClass_" + this.nrContainer);
        EPackage containerPackage = null;
        Container topContainer = container;
        while (topContainer.getParent() != null) {
            topContainer = topContainer.getParent();
        }
        if (topContainer.getField() != null) {
            Field f = topContainer.getField();
            Class c = f.getDefiningClass();
            EClass eClass = (EClass)this.getElement(c);
            containerPackage = eClass.getEPackage();
        } else {
            containerPackage = this.packageFromId(Id.ROOT);
        }
        containerPackage.getEClassifiers().add((Object)eContainerClass);
        Object eContainerFeature = null;
        eContainerFeature = container.getType() instanceof Class || container.getType() instanceof Tuple || container.getType() instanceof Container ? g_EcoreFactory.createEReference() : g_EcoreFactory.createEAttribute();
        eContainerFeature.setName("value");
        if (container.getType() instanceof Container) {
            Container subType = (Container)container.getType();
            eContainerFeature.setOrdered(subType.getContainerType() == Container.Kind.ORD || subType.getContainerType() == Container.Kind.SEQ);
            eContainerFeature.setUnique(subType.getContainerType() == Container.Kind.SET || subType.getContainerType() == Container.Kind.ORD);
        } else {
            eContainerFeature.setOrdered(false);
            eContainerFeature.setUnique(true);
        }
        EObject eType = (EObject)this.getElement(container.getType());
        eContainerFeature.setEType((EClassifier)eType);
        eContainerFeature.setUpperBound(-1);
        eContainerFeature.setLowerBound(0);
        eContainerClass.getEStructuralFeatures().add(eContainerFeature);
    }

    @Override
    public void visit(Enum enum1, Object param) {
        if (this.hasElement(enum1)) {
            return;
        }
        EEnum eEnum = g_EcoreFactory.createEEnum();
        this.setElement(enum1, eEnum);
        eEnum.setName(enum1.getId().getName().toString());
        EPackage enumPackage = this.packageFromId(enum1.getId().getNamespace());
        enumPackage.getEClassifiers().add((Object)eEnum);
        EList eLiterals = eEnum.getELiterals();
        for (Name litName : enum1.getLiterals()) {
            EEnumLiteral eEnumLit = g_EcoreFactory.createEEnumLiteral();
            eEnumLit.setName(litName.toString());
            eLiterals.add(eEnumLit);
        }
    }

    @Override
    public void visit(Tuple tuple, Object param) {
        if (this.hasElement(tuple)) {
            return;
        }
        EPackage firstRoot = this.m_rootPackages.iterator().next();
        EClass eClass = g_EcoreFactory.createEClass();
        this.setElement(tuple, eClass);
        eClass.setName(this.getTupleName(tuple));
        firstRoot.getEClassifiers().add((Object)eClass);
        int typeIndex = 1;
        for (Type type : tuple.getTypes()) {
            Field typeField = new Field(Name.getName(this.getTupleElementName(tuple, typeIndex++)), type, 1, 1);
            EStructuralFeature eStructFeat = (EStructuralFeature)this.getElement(typeField);
            eClass.getEStructuralFeatures().add((Object)eStructFeat);
        }
    }

    @Override
    public void visit(AbstractProperty abstractProperty, Object param) {
        if (this.hasElement(abstractProperty)) {
            return;
        }
        EClass eClass = (EClass)this.getElement(abstractProperty.getAbstractClass());
        eClass.setAbstract(true);
        this.setElement(abstractProperty, null);
    }

    @Override
    public void visit(ContainmentProperty containmentProperty, Object param) {
        if (this.hasElement(containmentProperty)) {
            return;
        }
        EObject obj = (EObject)this.getElement(containmentProperty.getField());
        if (!(obj instanceof EReference)) {
            return;
        }
        EReference eRef = (EReference)obj;
        eRef.setContainment(true);
        eRef.setUnique(true);
        this.setElement(containmentProperty, null);
    }

    @Override
    public void visit(IdentityProperty identityProperty, Object param) {
        if (this.hasElement(identityProperty)) {
            return;
        }
        Field[] fieldArray = identityProperty.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            EObject obj = (EObject)this.getElement(field);
            if (obj instanceof EAttribute) {
                EAttribute eAttr = (EAttribute)obj;
                eAttr.setID(true);
                break;
            }
            ++n2;
        }
        this.setElement(identityProperty, null);
    }

    @Override
    public void visit(KeysetProperty keysetProperty, Object param) {
        if (this.hasElement(keysetProperty)) {
            return;
        }
        EObject objRef = (EObject)this.getElement(keysetProperty.getRelField());
        boolean cfr_ignored_0 = objRef instanceof EReference;
        EReference eRef = (EReference)objRef;
        EList keyAttribs = eRef.getEKeys();
        Field[] fieldArray = keysetProperty.getKeyFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            EObject obj = (EObject)this.getElement(field);
            boolean cfr_ignored_1 = obj instanceof EAttribute;
            EAttribute eAttr = (EAttribute)obj;
            keyAttribs.add(eAttr);
            ++n2;
        }
        this.setElement(keysetProperty, null);
    }

    @Override
    public void visit(OppositeProperty oppositeProperty, Object param) {
        if (this.hasElement(oppositeProperty)) {
            return;
        }
        EObject obj1 = (EObject)this.getElement(oppositeProperty.getField1());
        EObject obj2 = (EObject)this.getElement(oppositeProperty.getField2());
        if (obj1 instanceof EReference) {
            boolean cfr_ignored_0 = obj2 instanceof EReference;
        }
        EReference eRef1 = (EReference)obj1;
        EReference eRef2 = (EReference)obj2;
        eRef1.setEOpposite(eRef2);
        this.setElement(oppositeProperty, null);
    }

    @Override
    public void visit(DefaultValueProperty defaultValueProperty, Object param) {
        if (this.hasElement(defaultValueProperty)) {
            return;
        }
        EObject obj = (EObject)this.getElement(defaultValueProperty.getField());
        if (!(obj instanceof EAttribute)) {
            return;
        }
        EAttribute eAttr = (EAttribute)obj;
        eAttr.setDefaultValueLiteral(defaultValueProperty.getDefaultValue().toString());
        this.setElement(defaultValueProperty, null);
    }
}

