/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.graphviz;

import com.alexmerz.graphviz.objects.Edge;
import com.alexmerz.graphviz.objects.Graph;
import com.alexmerz.graphviz.objects.Node;
import com.alexmerz.graphviz.objects.PortNode;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.TypeExporter;
import groove.io.conceptual.lang.graphviz.GraphvizResource;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.Property;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.external.PortException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TypeToGraphviz
extends TypeExporter<Node> {
    private Map<Id, Graph> m_packageGraphs = new HashMap<Id, Graph>();
    private Map<TypeModel, Graph> m_typeGraphs = new HashMap<TypeModel, Graph>();
    private TypeModel m_currentTypeModel;
    private int m_nodeId;
    private GraphvizResource m_resource;

    public TypeToGraphviz(GraphvizResource resource) {
        this.m_resource = resource;
    }

    @Override
    public void addTypeModel(TypeModel typeModel) throws PortException {
        int timer = Timer.start("TM to DOT");
        Graph typeGraph = this.m_resource.getTypeGraph(typeModel.getName());
        this.m_typeGraphs.put(typeModel, typeGraph);
        this.m_packageGraphs.put(Id.ROOT, typeGraph);
        this.m_currentTypeModel = typeModel;
        this.visitTypeModel(typeModel);
        Timer.stop(timer);
    }

    @Override
    public ExportableResource getResource() {
        return this.m_resource;
    }

    @Override
    protected void visitTypeModel(TypeModel typeModel) {
        for (Class cmClass : typeModel.getClasses()) {
            this.getElement(cmClass);
        }
        for (Enum cmEnum : typeModel.getEnums()) {
            this.getElement(cmEnum);
        }
    }

    @Override
    public void visit(Class class1, Object param) {
        if (this.hasElement(class1)) {
            return;
        }
        if (!class1.isProper()) {
            this.setElement(class1, (Node)this.getElement(class1.getProperClass()));
            return;
        }
        Graph classGraph = this.getPackageGraph(class1.getId().getNamespace());
        Node classNode = new Node();
        classGraph.addNode(classNode);
        classNode.setId(new com.alexmerz.graphviz.objects.Id());
        classNode.getId().setId(this.getNodeId());
        for (Property p : this.m_currentTypeModel.getProperties()) {
            if (!(p instanceof AbstractProperty) || ((AbstractProperty)p).getAbstractClass() != class1) continue;
            classNode.setAttribute("style", "dashed");
        }
        this.setElement(class1, classNode);
        HashSet<Field> edgeFields = new HashSet<Field>();
        for (Field f : class1.getFields()) {
            Node fieldNode = null;
            Type fieldType = f.getType();
            if (fieldType instanceof Container) {
                fieldType = ((Container)fieldType).getType();
            }
            if (fieldType instanceof Class || fieldType instanceof Tuple || fieldType instanceof Enum) {
                fieldNode = (Node)this.getElement(fieldType);
            }
            if (fieldNode == null) continue;
            Edge fieldEdge = new Edge();
            fieldEdge.setSource(new PortNode(classNode));
            fieldEdge.setTarget(new PortNode(fieldNode));
            fieldEdge.setAttribute("label", f.getName().toString());
            fieldEdge.setType(2);
            fieldEdge.setAttribute("headlabel", String.valueOf(f.getLowerBound()) + ".." + f.getUpperBound());
            for (Property p : this.m_currentTypeModel.getProperties()) {
                if (!(p instanceof ContainmentProperty) || ((ContainmentProperty)p).getField() != f) continue;
                fieldEdge.setAttribute("arrowtail", "diamond");
            }
            this.getPackageGraph(Id.ROOT).addEdge(fieldEdge);
            edgeFields.add(f);
        }
        String label = class1.getId().getName() + "\\n";
        for (Field f : class1.getFields()) {
            if (edgeFields.contains(f)) continue;
            label = String.valueOf(label) + f.getName();
            for (Property p : this.m_currentTypeModel.getProperties()) {
                if (!(p instanceof DefaultValueProperty) || ((DefaultValueProperty)p).getField() != f) continue;
                label = String.valueOf(label) + " = " + ((DefaultValueProperty)p).getDefaultValue();
            }
            label = String.valueOf(label) + " : " + f.getLowerBound() + ".." + f.getUpperBound() + "\\n";
        }
        classNode.setAttribute("label", label);
        for (Class supClass : class1.getSuperClasses()) {
            Node supNode = (Node)this.getElement(supClass);
            Edge supEdge = new Edge();
            supEdge.setSource(new PortNode(classNode));
            supEdge.setTarget(new PortNode(supNode));
            supEdge.setAttribute("arrowhead", "empty");
            supEdge.setType(2);
            this.getPackageGraph(Id.ROOT).addEdge(supEdge);
        }
    }

    @Override
    public void visit(Container container, Object param) {
    }

    @Override
    public void visit(Enum enum1, Object param) {
        if (this.hasElement(enum1)) {
            return;
        }
        Graph enumGraph = this.getPackageGraph(enum1.getId().getNamespace());
        Node enumNode = new Node();
        enumGraph.addNode(enumNode);
        enumNode.setId(new com.alexmerz.graphviz.objects.Id());
        enumNode.getId().setId(this.getNodeId());
        enumNode.setAttribute("shape", "record");
        String label = "{" + enum1.getId().getName();
        for (Name literal : enum1.getLiterals()) {
            label = String.valueOf(label) + " | " + literal;
        }
        label = String.valueOf(label) + "}";
        enumNode.setAttribute("label", label);
        this.setElement(enum1, enumNode);
    }

    @Override
    public void visit(Tuple tuple, Object param) {
        if (this.hasElement(tuple)) {
            return;
        }
        Graph tupleGraph = this.getPackageGraph(Id.ROOT);
        Node tupleNode = new Node();
        tupleGraph.addNode(tupleNode);
        tupleNode.setId(new com.alexmerz.graphviz.objects.Id());
        tupleNode.getId().setId(this.getNodeId());
        tupleNode.setAttribute("shape", "record");
        String label = "";
        boolean first = true;
        for (Type type : tuple.getTypes()) {
            if (!first) {
                label = String.valueOf(label) + "|";
            }
            label = String.valueOf(label) + type.toString();
            first = false;
        }
        tupleNode.setAttribute("label", label);
        this.setElement(tuple, tupleNode);
    }

    private Graph getPackageGraph(Id namespace) {
        if (this.m_packageGraphs.containsKey(namespace)) {
            return this.m_packageGraphs.get(namespace);
        }
        Graph parent = this.getPackageGraph(namespace.getNamespace());
        Graph packageGraph = new Graph();
        parent.addSubgraph(packageGraph);
        com.alexmerz.graphviz.objects.Id graphId = new com.alexmerz.graphviz.objects.Id();
        graphId.setId("\"cluster_" + namespace.getName().toString() + "\"");
        packageGraph.addAttribute("label", namespace.getName().toString());
        packageGraph.setId(graphId);
        this.m_packageGraphs.put(namespace, packageGraph);
        return packageGraph;
    }

    private String getNodeId() {
        return "N" + this.m_nodeId++;
    }
}

