/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.graph.GraphRole;
import groove.io.conceptual.Acceptor;
import groove.io.conceptual.Field;
import groove.io.conceptual.Name;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.configuration.schema.EnumModeType;
import groove.io.conceptual.configuration.schema.OrderType;
import groove.io.conceptual.graph.AbsEdge;
import groove.io.conceptual.graph.AbsNode;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.TypeExporter;
import groove.io.conceptual.lang.groove.GrammarGraph;
import groove.io.conceptual.lang.groove.GrooveResource;
import groove.io.conceptual.lang.groove.GrooveUtil;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.IdentityProperty;
import groove.io.conceptual.property.KeysetProperty;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.property.Property;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.BoolValue;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.StringValue;
import groove.io.external.PortException;
import java.util.HashSet;
import java.util.Set;

public class ConstraintToGroove
extends TypeExporter<AbsNode> {
    private static final String CONSTRAINT_NS = "constraint";
    private GrooveResource m_grooveResource;
    private Config m_cfg;
    private Set<Property> m_properties = new HashSet<Property>();
    private GrammarGraph m_currentGraph;
    private boolean m_allowDuplicates;
    private boolean m_recursiveTypes;

    public ConstraintToGroove(GrooveResource grooveResource) {
        this.m_grooveResource = grooveResource;
        this.m_cfg = this.m_grooveResource.getConfig();
        this.m_allowDuplicates = false;
        this.m_recursiveTypes = true;
    }

    @Override
    public void addTypeModel(TypeModel typeModel) throws PortException {
        this.m_properties.clear();
        this.visitTypeModel(typeModel, this.m_cfg);
    }

    @Override
    public ExportableResource getResource() {
        return this.m_grooveResource;
    }

    @Override
    protected void visitTypeModel(TypeModel typeModel) {
        for (Property p : typeModel.getProperties()) {
            p.doVisit(this, null);
        }
        for (Class cmClass : typeModel.getClasses()) {
            for (Field f : cmClass.getFields()) {
                this.createConstraints(f);
            }
        }
        for (Enum cmEnum : typeModel.getEnums()) {
            this.createConstraints(cmEnum);
        }
    }

    @Override
    protected void setElement(Acceptor o, AbsNode n) {
        this.m_currentGraph.m_nodes.put(o, n);
        if (this.m_allowDuplicates && super.hasElement(o)) {
            this.m_elements.put(o, n);
        } else {
            super.setElement(o, n);
        }
    }

    @Override
    protected boolean hasElement(Acceptor o) {
        if (this.m_allowDuplicates) {
            return false;
        }
        return super.hasElement(o);
    }

    @Override
    protected AbsNode getElement(Acceptor o, Object param, boolean allowNull) {
        if (this.m_allowDuplicates) {
            o.doVisit(this, param);
        }
        return (AbsNode)super.getElement(o, param, allowNull);
    }

    private void setPropertyVisited(Property o) {
        this.m_properties.add(o);
    }

    private boolean propertyVisited(Property o) {
        return this.m_properties.contains(o);
    }

    private GrammarGraph getUniqueGraph(String name, GraphRole role) {
        return this.getUniqueGraph(name, role, null);
    }

    private GrammarGraph getUniqueGraph(String name, GraphRole role, String ns) {
        this.m_elements.clear();
        name = GrooveUtil.getSafeId(name);
        if (ns != null) {
            name = String.valueOf(ns) + "." + name;
        }
        int index = 0;
        while (this.m_grooveResource.hasGraph(index == 0 ? name : String.valueOf(name) + index, role)) {
            ++index;
        }
        return this.m_grooveResource.getGraph(index == 0 ? name : String.valueOf(name) + index, role);
    }

    @Override
    public void visit(Class c, Object param) {
        if (this.hasElement(c)) {
            return;
        }
        if (!c.isProper()) {
            AbsNode classNode = (AbsNode)this.getElement(c.getProperClass());
            this.setElement((Acceptor)c, classNode);
        } else {
            AbsNode classNode = new AbsNode(this.m_cfg.getName(c));
            this.setElement((Acceptor)c, classNode);
        }
    }

    @Override
    public void visit(Field field, Object param) {
        if (this.hasElement(field)) {
            return;
        }
        AbsNode fieldNode = null;
        if (field.getType() instanceof Container) {
            fieldNode = (AbsNode)this.getElement(field.getType(), this.m_cfg.getName(field));
        } else if (this.m_cfg.useIntermediate(field)) {
            AbsNode interNode = new AbsNode(this.m_cfg.getName(field));
            String valName = this.m_cfg.getStrings().getValueEdge();
            if (this.m_recursiveTypes) {
                fieldNode = (AbsNode)this.getElement(field.getType());
                new AbsEdge(interNode, fieldNode, valName);
            }
            fieldNode = interNode;
        } else {
            fieldNode = (AbsNode)this.getElement(field.getType());
        }
        this.setElement((Acceptor)field, fieldNode);
    }

    @Override
    public void visit(DataType dt, Object param) {
        if (this.hasElement(dt)) {
            return;
        }
        AbsNode typeNode = new AbsNode(this.m_cfg.getName(dt));
        this.setElement((Acceptor)dt, typeNode);
    }

    @Override
    public void visit(Enum e, Object param) {
        if (this.hasElement(e)) {
            return;
        }
        AbsNode enumNode = new AbsNode(this.m_cfg.getName(e));
        this.setElement((Acceptor)e, enumNode);
    }

    @Override
    public void visit(Container c, Object param) {
        if (this.hasElement(c)) {
            return;
        }
        if (param == null || !(param instanceof String)) {
            throw new IllegalArgumentException("Container visitor requires String argument");
        }
        String containerId = (String)param;
        AbsNode containerNode = null;
        if (this.m_cfg.useIntermediate(c)) {
            containerNode = new AbsNode(String.valueOf(containerId) + this.m_cfg.getContainerPostfix(c));
        }
        AbsNode typeNode = null;
        if (this.m_recursiveTypes || !this.m_cfg.useIntermediate(c)) {
            typeNode = !(c.getType() instanceof Container) ? (AbsNode)this.getElement(c.getType()) : (AbsNode)this.getElement(c.getType(), this.m_cfg.getContainerName(containerId, c));
        }
        if (this.m_cfg.useIntermediate(c) && this.m_recursiveTypes) {
            String valName = this.m_cfg.getStrings().getValueEdge();
            new AbsEdge(containerNode, typeNode, valName);
        }
        if (!this.m_cfg.useIntermediate(c)) {
            containerNode = typeNode;
        }
        this.setElement((Acceptor)c, containerNode);
    }

    @Override
    public void visit(Tuple tuple, Object param) {
        if (this.hasElement(tuple)) {
            return;
        }
        AbsNode tupleNode = new AbsNode(this.m_cfg.getName(tuple));
        this.setElement((Acceptor)tuple, tupleNode);
        int index = 1;
        if (this.m_recursiveTypes) {
            for (Type t : tuple.getTypes()) {
                AbsNode typeNode = (AbsNode)this.getElement(t);
                new AbsEdge(tupleNode, typeNode, "_" + index++);
            }
        }
    }

    @Override
    public void visit(groove.io.conceptual.value.Object object, Object param) {
        throw new IllegalArgumentException("Cannot create object node in constraints");
    }

    @Override
    public void visit(AbstractProperty abstractProperty, Object param) {
        if (this.propertyVisited(abstractProperty)) {
            return;
        }
        this.setPropertyVisited(abstractProperty);
    }

    @Override
    public void visit(ContainmentProperty containmentProperty, Object param) {
        if (this.propertyVisited(containmentProperty)) {
            return;
        }
        this.setPropertyVisited(containmentProperty);
    }

    @Override
    public void visit(IdentityProperty identityProperty, Object param) {
        if (this.propertyVisited(identityProperty)) {
            return;
        }
        this.setPropertyVisited(identityProperty);
        if (!this.m_cfg.getConfig().getTypeModel().getConstraints().isCheckIdentifier()) {
            return;
        }
        this.m_currentGraph = this.getUniqueGraph("Identity_" + identityProperty.getIdClass().getId().getName(), GraphRole.RULE, CONSTRAINT_NS);
        this.equivalencyCheck(identityProperty.getIdClass(), identityProperty.getFields(), null);
    }

    @Override
    public void visit(KeysetProperty keysetProperty, Object param) {
        if (this.propertyVisited(keysetProperty)) {
            return;
        }
        this.setPropertyVisited(keysetProperty);
        if (!this.m_cfg.getConfig().getTypeModel().getConstraints().isCheckKeyset()) {
            return;
        }
        this.m_currentGraph = this.getUniqueGraph("Keyset_" + keysetProperty.getRelField().getName(), GraphRole.RULE, CONSTRAINT_NS);
        this.equivalencyCheck(keysetProperty.getKeyClass(), keysetProperty.getKeyFields(), keysetProperty.getRelField());
    }

    private void equivalencyCheck(Class fieldsClass, Field[] fields, Field containfield) {
        String valueName = this.m_cfg.getStrings().getValueEdge();
        String indexName = this.m_cfg.getStrings().getIndexEdge();
        String nextName = this.m_cfg.getStrings().getNextEdge();
        int curQuant = 1;
        this.m_allowDuplicates = true;
        this.m_recursiveTypes = false;
        AbsNode class1Node = (AbsNode)this.getElement(fieldsClass);
        AbsNode class2Node = (AbsNode)this.getElement(fieldsClass);
        new AbsEdge(class1Node, class2Node, "!=");
        if (containfield != null) {
            AbsNode keyNode = (AbsNode)this.getElement(containfield.getDefiningClass());
            AbsNode contain1Node = class1Node;
            AbsNode contain2Node = class2Node;
            if (this.m_cfg.useIntermediate(containfield)) {
                contain1Node = (AbsNode)this.getElement(containfield);
                contain2Node = (AbsNode)this.getElement(containfield);
                new AbsEdge(contain1Node, class1Node, valueName);
                new AbsEdge(contain2Node, class2Node, valueName);
            }
            new AbsEdge(keyNode, contain1Node, containfield.getName().toString());
            new AbsEdge(keyNode, contain2Node, containfield.getName().toString());
        }
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName().toString();
            AbsNode field1CountNode = (AbsNode)this.getElement(field);
            AbsNode field2CountNode = (AbsNode)this.getElement(field);
            new AbsEdge(class1Node, field1CountNode, fieldName);
            new AbsEdge(class2Node, field2CountNode, fieldName);
            AbsNode field1CountForall = new AbsNode("forall:");
            AbsNode field2CountForall = new AbsNode("forall:");
            new AbsEdge(field1CountNode, field1CountForall, "@");
            new AbsEdge(field2CountNode, field2CountForall, "@");
            AbsNode fieldCount = new AbsNode("int:");
            new AbsEdge(field1CountForall, fieldCount, "count");
            new AbsEdge(field2CountForall, fieldCount, "count");
            boolean useIntermediate = this.m_cfg.useIntermediate(field);
            boolean isUnique = true;
            boolean isOrdered = false;
            if (field.getType() instanceof Container) {
                Container c = (Container)field.getType();
                isUnique = c.getContainerType() == Container.Kind.SET || c.getContainerType() == Container.Kind.ORD;
                boolean bl = isOrdered = c.getContainerType() == Container.Kind.ORD || c.getContainerType() == Container.Kind.SEQ;
            }
            if (!useIntermediate) {
                AbsNode fieldValueNode = (AbsNode)this.getElement(field);
                new AbsEdge(class1Node, fieldValueNode, fieldName);
                new AbsEdge(class2Node, fieldValueNode, "use=qq" + curQuant + ":" + fieldName);
                AbsNode forallNode = new AbsNode("forall:");
                new AbsEdge(fieldValueNode, forallNode, "@");
                AbsNode existsNode = new AbsNode("exists=qq" + curQuant + ":");
                new AbsEdge(existsNode, forallNode, "in");
            } else {
                AbsNode field1InterNode = (AbsNode)this.getElement(field);
                AbsNode field2InterNode = (AbsNode)this.getElement(field);
                AbsNode fieldValueNode = (AbsNode)this.getElement(field.getType() instanceof Container ? ((Container)field.getType()).getType() : field.getType(), this.m_cfg.getName(field));
                new AbsEdge(class1Node, field1InterNode, fieldName);
                new AbsEdge(class2Node, field2InterNode, fieldName);
                new AbsEdge(field1InterNode, fieldValueNode, valueName);
                new AbsEdge(field2InterNode, fieldValueNode, valueName);
                if (isOrdered) {
                    boolean indexValue;
                    boolean bl = indexValue = this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getType() == OrderType.INDEX;
                    if (indexValue) {
                        AbsNode indexNode = new AbsNode("int:");
                        new AbsEdge(field1InterNode, indexNode, "index");
                        new AbsEdge(field2InterNode, indexNode, "use=qq" + curQuant + ":" + indexName);
                        AbsNode forallNode = new AbsNode("forall:");
                        new AbsEdge(fieldValueNode, forallNode, "@");
                        new AbsEdge(field1InterNode, forallNode, "@");
                        new AbsEdge(indexNode, forallNode, "@");
                        AbsNode existsNode = new AbsNode("exists=qq" + curQuant + ":");
                        new AbsEdge(field2InterNode, existsNode, "@");
                        new AbsEdge(existsNode, forallNode, "in");
                    } else {
                        AbsNode field1Inter2Node = (AbsNode)this.getElement(field);
                        AbsNode field2Inter2Node = (AbsNode)this.getElement(field);
                        AbsNode fieldValue2Node = (AbsNode)this.getElement(field.getType() instanceof Container ? ((Container)field.getType()).getType() : field.getType(), this.m_cfg.getName(field));
                        new AbsEdge(field1Inter2Node, fieldValue2Node, valueName);
                        new AbsEdge(field2Inter2Node, fieldValue2Node, valueName);
                        new AbsEdge(field1InterNode, field1Inter2Node, nextName);
                        new AbsEdge(field2InterNode, field2Inter2Node, nextName);
                        AbsNode forallNode = new AbsNode("forall:");
                        new AbsEdge(fieldValueNode, forallNode, "@");
                        new AbsEdge(field1InterNode, forallNode, "@");
                        AbsNode existsNode = new AbsNode("exists:");
                        new AbsEdge(field2InterNode, existsNode, "@");
                        new AbsEdge(existsNode, forallNode, "in");
                        AbsNode forall2Node = new AbsNode("forall:");
                        new AbsEdge(fieldValue2Node, forall2Node, "@");
                        new AbsEdge(field1Inter2Node, forall2Node, "@");
                        AbsNode exists2Node = new AbsNode("exists:");
                        new AbsEdge(field2Inter2Node, exists2Node, "@");
                        new AbsEdge(exists2Node, forall2Node, "in");
                        new AbsEdge(forall2Node, existsNode, "in");
                    }
                } else if (isUnique) {
                    AbsNode forallNode = new AbsNode("forall:");
                    new AbsEdge(fieldValueNode, forallNode, "@");
                    new AbsEdge(field1InterNode, forallNode, "@");
                    AbsNode existsNode = new AbsNode("exists:");
                    new AbsEdge(field2InterNode, existsNode, "@");
                    new AbsEdge(existsNode, forallNode, "in");
                } else {
                    AbsNode field1Inter2Node = (AbsNode)this.getElement(field);
                    new AbsEdge(class1Node, field1Inter2Node, fieldName);
                    new AbsEdge(field1Inter2Node, fieldValueNode, valueName);
                    AbsNode countNode = new AbsNode("int:");
                    AbsNode forallInter1Node = new AbsNode("forall:");
                    AbsNode forallInter2Node = new AbsNode("forall:");
                    new AbsEdge(forallInter1Node, countNode, "count");
                    new AbsEdge(forallInter2Node, countNode, "count");
                    new AbsEdge(field1InterNode, forallInter1Node, "@");
                    new AbsEdge(field2InterNode, forallInter2Node, "@");
                    AbsNode existsCountNode = new AbsNode("exists:");
                    new AbsEdge(forallInter1Node, existsCountNode, "in");
                    new AbsEdge(forallInter2Node, existsCountNode, "in");
                    new AbsEdge(countNode, existsCountNode, "@");
                    AbsNode forallValuesNode = new AbsNode("forall:");
                    new AbsEdge(field1Inter2Node, forallValuesNode, "@");
                    new AbsEdge(fieldValueNode, forallValuesNode, "@");
                    new AbsEdge(existsCountNode, forallValuesNode, "in");
                }
            }
            ++curQuant;
            ++n2;
        }
        this.m_allowDuplicates = false;
        this.m_recursiveTypes = true;
    }

    @Override
    public void visit(OppositeProperty oppositeProperty, Object param) {
        AbsNode class2Node;
        if (this.propertyVisited(oppositeProperty)) {
            return;
        }
        this.setPropertyVisited(oppositeProperty);
        if (!this.m_cfg.getConfig().getTypeModel().getConstraints().isCheckOpposite()) {
            return;
        }
        String valueName = this.m_cfg.getStrings().getValueEdge();
        this.m_currentGraph = this.getUniqueGraph("Opposite_" + oppositeProperty.getField1().getName(), GraphRole.RULE, CONSTRAINT_NS);
        this.m_allowDuplicates = true;
        this.m_recursiveTypes = false;
        AbsNode class1Node = (AbsNode)this.getElement(oppositeProperty.getClass1());
        AbsNode field1Node = class2Node = (AbsNode)this.getElement(oppositeProperty.getClass2());
        if (this.m_cfg.useIntermediate(oppositeProperty.getField1())) {
            field1Node = (AbsNode)this.getElement(oppositeProperty.getField1());
            new AbsEdge(field1Node, class2Node, valueName);
        }
        AbsNode field2Node = class1Node;
        if (this.m_cfg.useIntermediate(oppositeProperty.getField2())) {
            field2Node = (AbsNode)this.getElement(oppositeProperty.getField2());
            field2Node.addName("not:");
            new AbsEdge(field2Node, class1Node, valueName);
        }
        new AbsEdge(class1Node, field1Node, oppositeProperty.getField1().getName().toString());
        if (this.m_cfg.useIntermediate(oppositeProperty.getField2())) {
            new AbsEdge(class2Node, field2Node, oppositeProperty.getField2().getName().toString());
        } else {
            new AbsEdge(class2Node, class1Node, "not:" + oppositeProperty.getField2().getName().toString());
        }
        this.m_allowDuplicates = false;
        this.m_recursiveTypes = true;
    }

    @Override
    public void visit(DefaultValueProperty defaultValueProperty, Object param) {
        if (this.propertyVisited(defaultValueProperty)) {
            return;
        }
        this.setPropertyVisited(defaultValueProperty);
        if (!this.m_cfg.getConfig().getTypeModel().getFields().getDefaults().isUseRule()) {
            return;
        }
        if (defaultValueProperty.getField().getType() instanceof Container && defaultValueProperty.getField().getUpperBound() > 1) {
            throw new RuntimeException("Container default value not allowed");
        }
        if (defaultValueProperty.getField().getType() instanceof Class) {
            throw new RuntimeException("Reference default value not allowed");
        }
        this.m_currentGraph = this.getUniqueGraph("Default_" + defaultValueProperty.getField().getName(), GraphRole.RULE);
        AbsNode classNode = (AbsNode)this.getElement(defaultValueProperty.getField().getDefiningClass());
        AbsNode valueNode = (AbsNode)this.getElement(defaultValueProperty.getDefaultValue());
        if (defaultValueProperty.getField().getType() instanceof CustomDataType) {
            valueNode.addName("new:");
        }
        if (this.m_cfg.useIntermediate(defaultValueProperty.getField())) {
            AbsNode interNotNode = new AbsNode("not:", this.m_cfg.getName(defaultValueProperty.getField()));
            AbsNode interNode = new AbsNode("new:", this.m_cfg.getName(defaultValueProperty.getField()));
            String valName = this.m_cfg.getStrings().getValueEdge();
            new AbsEdge(classNode, interNode, "new:" + defaultValueProperty.getField().getName().toString());
            new AbsEdge(classNode, interNotNode, defaultValueProperty.getField().getName().toString());
            new AbsEdge(interNode, valueNode, valName);
        } else {
            new AbsEdge(classNode, valueNode, "new:" + defaultValueProperty.getField().getName().toString());
            AbsNode notNode = (AbsNode)this.getElement(defaultValueProperty.getField().getType());
            notNode.addName("not:");
            new AbsEdge(classNode, notNode, defaultValueProperty.getField().getName().toString());
        }
    }

    @Override
    public void visit(RealValue realval, Object param) {
        if (this.hasElement(realval)) {
            return;
        }
        AbsNode realNode = new AbsNode("real:" + realval.getValue());
        this.setElement((Acceptor)realval, realNode);
    }

    @Override
    public void visit(StringValue stringval, Object param) {
        if (this.hasElement(stringval)) {
            return;
        }
        AbsNode stringNode = new AbsNode("string:\"" + stringval.toEscapedString() + "\"");
        this.setElement((Acceptor)stringval, stringNode);
    }

    @Override
    public void visit(IntValue intval, Object param) {
        if (this.hasElement(intval)) {
            return;
        }
        AbsNode intNode = new AbsNode("int:" + intval.getValue());
        this.setElement((Acceptor)intval, intNode);
    }

    @Override
    public void visit(BoolValue boolval, Object param) {
        if (this.hasElement(boolval)) {
            return;
        }
        AbsNode boolNode = new AbsNode("bool:" + boolval.getValue());
        this.setElement((Acceptor)boolval, boolNode);
    }

    @Override
    public void visit(EnumValue enumval, Object param) {
        if (this.hasElement(enumval)) {
            return;
        }
        if (this.m_cfg.getConfig().getTypeModel().getEnumMode() == EnumModeType.NODE) {
            String sep = this.m_cfg.getConfig().getGlobal().getIdSeparator();
            String litName = "type:" + this.m_cfg.idToName(((Enum)enumval.getType()).getId()) + sep + enumval.getValue();
            AbsNode enumNode = new AbsNode(litName);
            this.setElement((Acceptor)enumval, enumNode);
        } else {
            AbsNode enumNode = new AbsNode(this.m_cfg.getName(enumval.getType()));
            enumNode.addName("flag:" + enumval.getValue().toString());
            this.setElement((Acceptor)enumval, enumNode);
        }
    }

    @Override
    public void visit(CustomDataValue dataval, Object param) {
        if (this.hasElement(dataval)) {
            return;
        }
        String valueName = this.m_cfg.getStrings().getDataValue();
        AbsNode dataNode = new AbsNode(this.m_cfg.getName(dataval.getType()), "let:" + valueName + "=string:\"" + dataval.getValue() + "\"");
        this.setElement((Acceptor)dataval, dataNode);
    }

    private void createConstraints(Field field) {
        AbsNode classNode;
        GrammarGraph prevGraph;
        if (this.m_cfg.getConfig().getTypeModel().getConstraints().isCheckUniqueness() && this.m_cfg.useIntermediate(field) && field.getType() instanceof Container && (((Container)field.getType()).getContainerType() == Container.Kind.SET || ((Container)field.getType()).getContainerType() == Container.Kind.ORD)) {
            prevGraph = this.m_currentGraph;
            this.m_currentGraph = this.getUniqueGraph("Unique_" + field.getName(), GraphRole.RULE, CONSTRAINT_NS);
            this.m_allowDuplicates = true;
            this.m_recursiveTypes = false;
            classNode = (AbsNode)this.getElement(field.getDefiningClass());
            AbsNode interNode = (AbsNode)this.getElement(field);
            AbsNode interNode2 = (AbsNode)this.getElement(field);
            AbsNode typeNode = null;
            typeNode = ((Container)field.getType()).getType() instanceof Container ? (AbsNode)this.getElement(((Container)field.getType()).getType(), this.m_cfg.getContainerName(this.m_cfg.getName(field), (Container)field.getType())) : (AbsNode)this.getElement(((Container)field.getType()).getType());
            String valName = this.m_cfg.getStrings().getValueEdge();
            new AbsEdge(classNode, interNode, field.getName().toString());
            new AbsEdge(classNode, interNode2, field.getName().toString());
            new AbsEdge(interNode, typeNode, valName);
            new AbsEdge(interNode2, typeNode, valName);
            new AbsEdge(interNode, interNode2, "!=");
            this.m_allowDuplicates = false;
            this.m_recursiveTypes = true;
            this.m_currentGraph = prevGraph;
        }
        if (this.m_cfg.getConfig().getTypeModel().getConstraints().isCheckOrdering() && field.getType() instanceof Container && (((Container)field.getType()).getContainerType() == Container.Kind.ORD || ((Container)field.getType()).getContainerType() == Container.Kind.SEQ)) {
            prevGraph = this.m_currentGraph;
            this.m_currentGraph = this.getUniqueGraph("Ordered_" + field.getName(), GraphRole.RULE, CONSTRAINT_NS);
            this.m_allowDuplicates = true;
            this.m_recursiveTypes = false;
            classNode = (AbsNode)this.getElement(field.getDefiningClass());
            AbsNode val1Node = (AbsNode)this.getElement(field);
            AbsNode val2Node = (AbsNode)this.getElement(field);
            new AbsEdge(classNode, val1Node, field.getName().toString());
            new AbsEdge(classNode, val2Node, field.getName().toString());
            new AbsEdge(val1Node, val2Node, "!=");
            if (this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getType() == OrderType.INDEX) {
                String indexName = this.m_cfg.getStrings().getIndexEdge();
                AbsNode indexNode = new AbsNode("int:");
                new AbsEdge(val1Node, indexNode, indexName);
                new AbsEdge(val2Node, indexNode, indexName);
            } else if (this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getType() == OrderType.EDGE) {
                String nextName = this.m_cfg.getStrings().getNextEdge();
                AbsNode val3Node = (AbsNode)this.getElement(field);
                val3Node.addName("not:");
                AbsNode val4Node = (AbsNode)this.getElement(field);
                val4Node.addName("not:");
                new AbsEdge(val3Node, val1Node, nextName);
                new AbsEdge(val4Node, val2Node, nextName);
            }
            this.m_allowDuplicates = false;
            this.m_recursiveTypes = true;
            this.m_currentGraph = prevGraph;
        }
    }

    private void createConstraints(Enum e) {
        if (this.m_cfg.getConfig().getTypeModel().getEnumMode() == EnumModeType.NODE) {
            return;
        }
        if (!this.m_cfg.getConfig().getTypeModel().getConstraints().isCheckEnum()) {
            return;
        }
        GrammarGraph prevGraph = this.m_currentGraph;
        this.m_currentGraph = this.getUniqueGraph("Enum_" + e.getId().getName(), GraphRole.RULE, CONSTRAINT_NS);
        AbsNode enumNode = (AbsNode)this.getElement(e);
        if (e.getLiterals().size() > 1) {
            String flagCheck = "";
            boolean first = true;
            for (Name n : e.getLiterals()) {
                if (!first) {
                    flagCheck = String.valueOf(flagCheck) + "|";
                }
                flagCheck = String.valueOf(flagCheck) + "flag:" + n + ".(";
                boolean subfirst = true;
                for (Name n2 : e.getLiterals()) {
                    if (n2 == n) continue;
                    if (!subfirst) {
                        flagCheck = String.valueOf(flagCheck) + "|";
                    }
                    flagCheck = String.valueOf(flagCheck) + "flag:" + n2;
                    subfirst = false;
                }
                flagCheck = String.valueOf(flagCheck) + ")";
                first = false;
            }
            new AbsEdge(enumNode, enumNode, flagCheck);
        }
        this.m_currentGraph = this.getUniqueGraph("EnumNoflag_" + e.getId().getName(), GraphRole.RULE, CONSTRAINT_NS);
        enumNode = (AbsNode)this.getElement(e);
        for (Name n : e.getLiterals()) {
            new AbsEdge(enumNode, enumNode, "not:flag:" + n.toString());
        }
        this.m_currentGraph = prevGraph;
    }
}

