/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class GrammarDialog
extends JDialog {
    private Frame m_parent;
    private JComboBox m_typeList;
    private JComboBox m_metaList;
    private JComboBox m_instanceList;
    private boolean m_dialogResult;

    public GrammarDialog(Frame parent) {
        super(parent, "Select graphs to export", true);
        this.m_parent = parent;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                GrammarDialog.this.close();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GrammarDialog.this.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(actionListener, stroke, 2);
        this.buildGUI();
    }

    public boolean doDialog() {
        this.m_dialogResult = false;
        this.setLocationRelativeTo(this.m_parent);
        this.setVisible(true);
        return this.m_dialogResult;
    }

    private void buildGUI() {
        this.m_typeList = new JComboBox();
        this.m_metaList = new JComboBox();
        this.m_instanceList = new JComboBox();
        JLabel typeLabel = new JLabel("Select type graph:", 11);
        typeLabel.setLabelFor(this.m_typeList);
        JLabel metaLabel = new JLabel("Select meta graph:", 11);
        metaLabel.setLabelFor(this.m_metaList);
        JLabel instanceLabel = new JLabel("Select instance graph:", 11);
        instanceLabel.setLabelFor(this.m_instanceList);
        JPanel form = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 4, 4, 4);
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        form.add((Component)typeLabel, c);
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        form.add((Component)this.m_typeList, c);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        form.add((Component)metaLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        form.add((Component)this.m_metaList, c);
        c.gridx = 0;
        c.gridy = 2;
        form.add((Component)instanceLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        form.add((Component)this.m_instanceList, c);
        JPanel contents = new JPanel(new BorderLayout());
        contents.add((Component)form, "North");
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarDialog.this.m_dialogResult = true;
                GrammarDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(okBtn);
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrammarDialog.this.m_typeList.removeAllItems();
                GrammarDialog.this.m_metaList.removeAllItems();
                GrammarDialog.this.m_instanceList.removeAllItems();
                GrammarDialog.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(okBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(cancelBtn);
        contents.add((Component)buttonPane, "South");
        this.setContentPane(contents);
        this.setSize(350, 150);
    }

    public void setTypeModels(Set<String> typeModelNames) {
        this.m_typeList.removeAllItems();
        for (String type : typeModelNames) {
            this.m_typeList.addItem(type);
        }
    }

    public void setMetaModels(Set<String> metaModelNames) {
        this.m_metaList.removeAllItems();
        this.m_metaList.addItem("");
        for (String type : metaModelNames) {
            this.m_metaList.addItem(type);
        }
        if (metaModelNames.size() > 0) {
            this.m_metaList.setSelectedIndex(1);
        }
    }

    public void setInstanceModels(Set<String> instanceModelNames, boolean force) {
        this.m_instanceList.removeAllItems();
        if (!force) {
            this.m_instanceList.addItem("");
        }
        for (String type : instanceModelNames) {
            this.m_instanceList.addItem(type);
        }
        if (!force && instanceModelNames.size() > 0) {
            this.m_instanceList.setSelectedIndex(1);
        }
    }

    public String getTypeModel() {
        return (String)this.m_typeList.getSelectedItem();
    }

    public String getMetaModel() {
        return (String)this.m_metaList.getSelectedItem();
    }

    public String getInstanceModel() {
        return (String)this.m_instanceList.getSelectedItem();
    }

    private void close() {
        super.dispose();
    }
}

