/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.io.conceptual.type.Type;
import java.util.HashMap;
import java.util.Map;

public class GraphNodeTypes {
    private Map<String, ModelType> m_modelTypes = new HashMap<String, ModelType>();
    private Map<String, Type> m_types = new HashMap<String, Type>();

    public void addModelType(String typeName, ModelType typeString) {
        if (this.m_modelTypes.containsKey(typeName)) {
            return;
        }
        this.m_modelTypes.put(typeName, typeString);
    }

    public void addType(String typeName, Type cmType) {
        if (this.m_types.containsKey(typeName)) {
            return;
        }
        if (!this.m_modelTypes.containsKey(typeName)) {
            throw new IllegalArgumentException("Setting type without model type");
        }
        this.m_types.put(typeName, cmType);
    }

    public boolean hasModelType(String typeString) {
        return this.m_modelTypes.containsKey(typeString);
    }

    public boolean hasType(String typeString) {
        return this.m_types.containsKey(typeString);
    }

    public ModelType getModelType(String typeString) {
        if (!this.m_modelTypes.containsKey(typeString)) {
            return null;
        }
        return this.m_modelTypes.get(typeString);
    }

    public Type getType(String typeString) {
        if (!this.m_types.containsKey(typeString)) {
            return null;
        }
        return this.m_types.get(typeString);
    }

    public static enum ModelType {
        TypeClass,
        TypeClassNullable,
        TypeEnum,
        TypeEnumValue,
        TypeIntermediate,
        TypeDatatype,
        TypeContainerSet,
        TypeContainerBag,
        TypeContainerSeq,
        TypeContainerOrd,
        TypeTuple,
        TypeNone;

    }
}

