/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.model.RuleModel;
import groove.graph.GraphRole;
import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.configuration.schema.EnumModeType;
import groove.io.conceptual.configuration.schema.TypeModel;
import groove.io.conceptual.graph.AbsEdge;
import groove.io.conceptual.graph.AbsGraph;
import groove.io.conceptual.graph.AbsNode;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.lang.Messenger;
import groove.io.conceptual.lang.groove.GraphNodeTypes;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.IdentityProperty;
import groove.io.conceptual.property.KeysetProperty;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class GrooveToConstraint
implements Messenger {
    private Collection<RuleModel> m_ruleModels;
    private Config m_cfg;
    private TypeModel m_typeModel;
    List<Message> m_messages = new ArrayList<Message>();
    private GraphNodeTypes m_types;

    public GrooveToConstraint(Collection<RuleModel> ruleModels, GraphNodeTypes types, Config cfg, TypeModel typeModel) {
        this.m_ruleModels = ruleModels;
        this.m_types = types;
        this.m_cfg = cfg;
        this.m_typeModel = typeModel;
        this.parseRules();
    }

    private void parseRules() {
        TypeModel.Constraints constraints = this.m_cfg.getConfig().getTypeModel().getConstraints();
        for (RuleModel model : this.m_ruleModels) {
            if (!model.isEnabled() || model.hasErrors()) continue;
            String name = model.getFullName();
            if (constraints.isCheckUniqueness() && name.contains("Unique")) {
                if (this.m_cfg.getConfig().getTypeModel().getFields().getContainers().isUseTypeName()) continue;
                this.parseUniqueRule(model);
                continue;
            }
            if (constraints.isCheckOrdering() && name.contains("Ordered")) {
                if (this.m_cfg.getConfig().getTypeModel().getFields().getContainers().isUseTypeName()) continue;
                this.parseOrderedRule(model);
                continue;
            }
            if (constraints.isCheckIdentifier() && name.contains("Identity")) {
                if (!this.m_cfg.getConfig().getTypeModel().getProperties().isUseIdentity()) continue;
                this.parseIdentityRule(model);
                continue;
            }
            if (constraints.isCheckKeyset() && name.contains("Keyset")) {
                if (!this.m_cfg.getConfig().getTypeModel().getProperties().isUseKeyset()) continue;
                this.parseKeysetRule(model);
                continue;
            }
            if (constraints.isCheckOpposite() && name.contains("Opposite")) {
                if (!this.m_cfg.getConfig().getTypeModel().getProperties().isUseOpposite()) continue;
                this.parseOppositeRule(model);
                continue;
            }
            if (!this.m_cfg.getConfig().getTypeModel().getFields().getDefaults().isUseRule() || !name.contains("Default") || !this.m_cfg.getConfig().getTypeModel().getProperties().isUseDefaultValue()) continue;
            this.parseDefaultRule(model);
        }
    }

    @Override
    public List<Message> getMessages() {
        return this.m_messages;
    }

    @Override
    public void clearMessages() {
        this.m_messages.clear();
    }

    private void parseUniqueRule(RuleModel model) {
        AbsGraph ruleGraph = this.parseRuleModel(model);
        for (AbsNode n : ruleGraph.getNodes()) {
            Name fieldName;
            if (n.getTargetEdges().size() != 0 || this.getType(n) == null) continue;
            Class c = (Class)this.m_types.getType(this.getType(n));
            if (n.getEdges().size() <= 0 || !(c.getField(fieldName = Name.getName(n.getEdges().get(0).getName())).getType() instanceof Container)) continue;
            ((Container)c.getField(fieldName).getType()).setUnique(true);
        }
    }

    private void parseOrderedRule(RuleModel model) {
        AbsGraph ruleGraph = this.parseRuleModel(model);
        for (AbsNode n : ruleGraph.getNodes()) {
            Name fieldName;
            if (n.getTargetEdges().size() != 0 || this.isNAC(n) || this.getType(n) == null) continue;
            Class c = (Class)this.m_types.getType(this.getType(n));
            if (n.getEdges().size() <= 0 || !(c.getField(fieldName = Name.getName(n.getEdges().get(0).getName())).getType() instanceof Container)) continue;
            ((Container)c.getField(fieldName).getType()).setOrdered(true);
        }
    }

    private void parseIdentityRule(RuleModel model) {
        AbsGraph ruleGraph = this.parseRuleModel(model);
        AbsNode classNode = null;
        Class idClass = null;
        block0: for (AbsNode node : ruleGraph.getNodes()) {
            for (AbsEdge edge : node.getTargetEdges()) {
                if (!edge.getName().equals("!=")) continue;
                classNode = edge.getSource();
                idClass = (Class)this.m_types.getType(this.getType(classNode));
                break block0;
            }
        }
        if (classNode != null) {
            HashSet<Name> fieldNames = new HashSet<Name>();
            for (AbsEdge e : classNode.getEdges()) {
                Name fieldName = Name.getName(e.getName());
                if (idClass.getField(fieldName) == null) continue;
                fieldNames.add(fieldName);
            }
            if (fieldNames.size() > 0) {
                IdentityProperty ip = new IdentityProperty(idClass, fieldNames.toArray(new Name[fieldNames.size()]));
                this.m_typeModel.addProperty(ip);
            }
        }
    }

    private void parseKeysetRule(RuleModel model) {
        AbsGraph ruleGraph = this.parseRuleModel(model);
        AbsNode relClassNode = null;
        AbsNode classNode = null;
        Class relClass = null;
        Class keyClass = null;
        for (AbsNode node : ruleGraph.getNodes()) {
            if (node.getTargetEdges().size() != 0) continue;
            relClassNode = node;
            relClass = (Class)this.m_types.getType(this.getType(node));
            break;
        }
        if (relClassNode == null || relClass == null) {
            return;
        }
        Name relField = Name.getName(relClassNode.getEdges().get(0).getName());
        block1: for (AbsNode node : ruleGraph.getNodes()) {
            for (AbsEdge absEdge : node.getTargetEdges()) {
                if (!absEdge.getName().equals("!=")) continue;
                classNode = absEdge.getSource();
                keyClass = (Class)this.m_types.getType(this.getType(node));
                break block1;
            }
        }
        if (classNode == null || keyClass == null) {
            return;
        }
        HashSet<Name> fieldNames = new HashSet<Name>();
        for (AbsEdge e : classNode.getEdges()) {
            Name fieldName = Name.getName(e.getName());
            if (keyClass.getField(fieldName) == null) continue;
            fieldNames.add(fieldName);
        }
        if (fieldNames.size() > 0) {
            Class c = (Class)this.m_types.getType(this.getType(classNode));
            KeysetProperty keysetProperty = new KeysetProperty(relClass, relField, c, fieldNames.toArray(new Name[fieldNames.size()]));
            this.m_typeModel.addProperty(keysetProperty);
        }
    }

    private void parseOppositeRule(RuleModel model) {
        AbsGraph ruleGraph = this.parseRuleModel(model);
        Class class1 = null;
        Class class2 = null;
        Name field1 = null;
        Name field2 = null;
        for (AbsNode node : ruleGraph.getNodes()) {
            String type;
            if (this.isNAC(node) || (type = this.getType(node)) == null || this.m_types.getModelType(type) != GraphNodeTypes.ModelType.TypeClass) continue;
            for (AbsEdge edge : node.getEdges()) {
                AbsNode targetNode = edge.getTarget();
                String targettype = this.getType(targetNode);
                if (targettype == null || this.m_types.getModelType(targettype) == GraphNodeTypes.ModelType.TypeClass) continue;
                if (!this.isNAC(targetNode)) {
                    class1 = (Class)this.m_types.getType(type);
                    field1 = Name.getName(edge.getName());
                    continue;
                }
                class2 = (Class)this.m_types.getType(type);
                field2 = Name.getName(edge.getName());
            }
        }
        OppositeProperty op = new OppositeProperty(class1, field1, class2, field2);
        this.m_typeModel.addProperty(op);
    }

    private void parseDefaultRule(RuleModel model) {
        AbsGraph ruleGraph = this.parseRuleModel(model);
        block0: for (AbsNode node : ruleGraph.getNodes()) {
            String type;
            if (this.isNAC(node) || this.isNew(node) || (type = this.getType(node)) == null || this.m_types.getModelType(type) != GraphNodeTypes.ModelType.TypeClass) continue;
            Class cmClass = (Class)this.m_types.getType(type);
            for (AbsEdge edge : node.getEdges()) {
                AbsNode targetNode = edge.getTarget();
                String targettype = this.getType(targetNode);
                if (targettype == null || !this.isNew(targetNode)) continue;
                Name field = Name.getName(edge.getName().substring(4));
                Value value = this.getNodeValue(targetNode);
                DefaultValueProperty dp = new DefaultValueProperty(cmClass, field, value);
                this.m_typeModel.addProperty(dp);
                break block0;
            }
        }
    }

    private AbsGraph parseRuleModel(RuleModel rule) {
        AspectGraph sourceGraph = rule.getSource();
        AbsGraph resultGraph = new AbsGraph();
        HashMap<AspectNode, AbsNode> nodeMap = new HashMap<AspectNode, AbsNode>();
        for (AspectNode node : sourceGraph.nodeSet()) {
            AbsNode aNode = new AbsNode(new String[0]);
            for (AspectLabel aspectLabel : node.getNodeLabels()) {
                aNode.addName(aspectLabel.toString());
            }
            nodeMap.put(node, aNode);
            resultGraph.addNode(aNode);
        }
        for (AspectNode node : sourceGraph.nodeSet()) {
            for (AspectEdge edge : sourceGraph.edgeSet(node)) {
                if (edge.source() != node) continue;
                if (edge.getAspect().isForNode(GraphRole.RULE) && edge.source() == edge.target()) {
                    ((AbsNode)nodeMap.get(edge.source())).addName(((AspectLabel)edge.label()).toString());
                    continue;
                }
                new AbsEdge((AbsNode)nodeMap.get(edge.source()), (AbsNode)nodeMap.get(edge.target()), ((AspectLabel)edge.label()).toString());
            }
        }
        return resultGraph;
    }

    private String getType(AbsNode node) {
        String[] stringArray = node.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.startsWith("type:")) {
                return name.substring(5);
            }
            if (name.startsWith("bool:")) {
                return "bool";
            }
            if (name.startsWith("int:")) {
                return "int";
            }
            if (name.startsWith("real:")) {
                return "real";
            }
            if (name.startsWith("string:")) {
                return "string";
            }
            ++n2;
        }
        return null;
    }

    private boolean isNAC(AbsNode node) {
        String[] stringArray = node.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals("not:")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isNew(AbsNode node) {
        String[] stringArray = node.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals("new:")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Value getNodeValue(AbsNode node) {
        Type nodeType = this.m_types.getType(this.getType(node));
        if (nodeType == null) {
            if (this.m_types.getModelType(this.getType(node)) == GraphNodeTypes.ModelType.TypeIntermediate) {
                String valueEdge = this.m_cfg.getStrings().getValueEdge();
                AbsNode valueNode = null;
                for (AbsEdge e : node.getEdges()) {
                    if (!e.getName().equals(valueEdge)) continue;
                    valueNode = e.getTarget();
                }
                if (valueNode != null) {
                    return this.getNodeValue(valueNode);
                }
                return null;
            }
            return null;
        }
        Value resultValue = null;
        if (nodeType instanceof Enum) {
            Enum e = (Enum)nodeType;
            if (this.m_cfg.getConfig().getTypeModel().getEnumMode() == EnumModeType.NODE) {
                Id id = this.m_cfg.nameToId(this.getType(node));
                EnumValue ev = new EnumValue(e, id.getName());
                resultValue = ev;
            } else {
                for (AbsEdge enumEdge : node.getEdges()) {
                    if (!enumEdge.getName().startsWith("flag:")) continue;
                    EnumValue ev = new EnumValue(e, Name.getName(enumEdge.getName().substring(5)));
                    resultValue = ev;
                    break;
                }
            }
        } else if (nodeType instanceof CustomDataType) {
            CustomDataType cdt = (CustomDataType)nodeType;
            String dataValueName = this.m_cfg.getStrings().getDataValue();
            AbsNode valueNode = null;
            for (AbsEdge e : node.getEdges()) {
                if (!e.getName().equals(dataValueName)) continue;
                valueNode = e.getTarget();
            }
            if (valueNode != null) {
                String valueString = valueNode.getNames()[0].substring(nodeType.typeString().length() + 1);
                CustomDataValue dv = new CustomDataValue(cdt, valueString);
                resultValue = dv;
            }
        } else if (nodeType instanceof DataType) {
            String valueString = node.getNames()[0].substring(nodeType.typeString().length() + 1);
            resultValue = ((DataType)nodeType).valueFromString(valueString);
        }
        return resultValue;
    }
}

