/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.configuration.schema.EnumModeType;
import groove.io.conceptual.configuration.schema.ModeType;
import groove.io.conceptual.configuration.schema.NullableType;
import groove.io.conceptual.configuration.schema.OrderType;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.lang.TypeImporter;
import groove.io.conceptual.lang.groove.GraphNodeTypes;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.type.BoolType;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.IntType;
import groove.io.conceptual.type.RealType;
import groove.io.conceptual.type.StringType;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GrooveToType
extends TypeImporter {
    private TypeModel m_typeModel;
    private GraphNodeTypes m_types;
    private Config m_cfg;
    private static Map<Id, Type> g_primitiveIds = new HashMap<Id, Type>();
    private Map<TypeNode, Id> m_typeIds = new HashMap<TypeNode, Id>();
    private Map<TypeNode, Set<TypeEdge>> m_nodeEdges = new HashMap<TypeNode, Set<TypeEdge>>();
    private Map<TypeNode, Type> m_intermediateFields = new HashMap<TypeNode, Type>();

    static {
        g_primitiveIds.put(Id.getId(Id.ROOT, Name.getName("bool")), BoolType.instance());
        g_primitiveIds.put(Id.getId(Id.ROOT, Name.getName("int")), IntType.instance());
        g_primitiveIds.put(Id.getId(Id.ROOT, Name.getName("real")), RealType.instance());
        g_primitiveIds.put(Id.getId(Id.ROOT, Name.getName("string")), StringType.instance());
    }

    public GrooveToType(TypeGraph grooveTypeGraph, GraphNodeTypes types, Config cfg) throws ImportException {
        this.m_types = types;
        this.m_cfg = cfg;
        int timer = Timer.start("GROOVE to TM");
        this.buildTypeModel(grooveTypeGraph);
        Timer.stop(timer);
    }

    private void buildTypeModel(TypeGraph grooveTypeGraph) throws ImportException {
        Enum e;
        Class c;
        Id id;
        Object n;
        this.m_typeModel = new TypeModel(grooveTypeGraph.getName());
        HashSet unvisitedNodes = new HashSet(grooveTypeGraph.nodeSet());
        Set edges = grooveTypeGraph.edgeSet();
        HashMap<Id, Enum> enumIds = new HashMap<Id, Enum>();
        for (TypeNode n2 : grooveTypeGraph.nodeSet()) {
            this.m_nodeEdges.put(n2, new HashSet());
        }
        for (TypeEdge e2 : edges) {
            this.m_nodeEdges.get(e2.source()).add(e2);
        }
        Iterator it = unvisitedNodes.iterator();
        while (it.hasNext()) {
            TypeNode node = (TypeNode)it.next();
            if (!this.m_types.hasModelType(node.label().text()) || this.m_types.getModelType(node.label().text()) == GraphNodeTypes.ModelType.TypeNone) continue;
            if (this.m_types.getModelType(node.label().text()) == GraphNodeTypes.ModelType.TypeEnum) {
                enumIds.put(this.getNodeId(node), null);
            }
            it.remove();
        }
        if (!this.m_cfg.getConfig().getTypeModel().isMetaSchema()) {
            it = unvisitedNodes.iterator();
            while (it.hasNext()) {
                n = (TypeNode)it.next();
                String nameStr = ((TypeNode)n).label().text();
                Id id2 = this.getNodeId((TypeNode)n);
                if (this.m_cfg.getStrings().getEnumPostfix().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getEnumPostfix())) {
                    enumIds.put(id2, null);
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeEnum);
                } else if (this.m_cfg.getStrings().getProperPostfix().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getProperPostfix())) {
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeClass);
                } else if (this.m_cfg.getStrings().getNullablePostfix().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getNullablePostfix())) {
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeClassNullable);
                } else if (this.m_cfg.getStrings().getDataPostfix().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getDataPostfix())) {
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeDatatype);
                } else if (this.m_cfg.getStrings().getIntermediatePostfix().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getIntermediatePostfix())) {
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeIntermediate);
                } else if (this.m_cfg.getStrings().getMetaContainerSet().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getMetaContainerSet())) {
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeIntermediate);
                } else if (this.m_cfg.getStrings().getMetaContainerBag().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getMetaContainerBag())) {
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeIntermediate);
                } else if (this.m_cfg.getStrings().getMetaContainerOrd().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getMetaContainerOrd())) {
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeIntermediate);
                } else if (this.m_cfg.getStrings().getMetaContainerSeq().length() > 0 && nameStr.endsWith(this.m_cfg.getStrings().getMetaContainerSeq())) {
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeIntermediate);
                } else {
                    if (this.m_cfg.getStrings().getTuplePostfix().length() <= 0 || !nameStr.endsWith(this.m_cfg.getStrings().getTuplePostfix())) continue;
                    this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeTuple);
                }
                it.remove();
            }
        }
        for (TypeEdge e2 : edges) {
            Id sourceId = this.getNodeId((TypeNode)e2.source());
            Id targetId = this.getNodeId((TypeNode)e2.target());
            if (!unvisitedNodes.contains(e2.target())) continue;
            if (targetId == null || targetId.getName() == null) {
                System.out.println("Target null");
                continue;
            }
            if (targetId.getNamespace() != sourceId) continue;
            this.m_types.addModelType(this.getLabel((TypeNode)e2.target()), GraphNodeTypes.ModelType.TypeIntermediate);
            unvisitedNodes.remove(e2.target());
        }
        it = unvisitedNodes.iterator();
        while (it.hasNext()) {
            n = (TypeNode)it.next();
            Id id3 = this.getNodeId((TypeNode)n);
            if (((TypeNode)n).isDataType()) {
                this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeDatatype);
                it.remove();
                continue;
            }
            if (enumIds.keySet().contains(id3.getNamespace())) {
                this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeEnumValue);
                it.remove();
                continue;
            }
            if (this.getLabel((TypeNode)n).equals(this.m_cfg.getStrings().getNilName())) {
                this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeNone);
            } else {
                this.m_types.addModelType(this.getLabel((TypeNode)n), GraphNodeTypes.ModelType.TypeClass);
            }
            it.remove();
        }
        for (TypeNode n2 : unvisitedNodes) {
            this.addMessage(new Message("TypeNode unvisited: " + n2 + ": " + n2.label().text(), Message.MessageType.WARNING));
        }
        HashSet<TypeNode> tupleNodes = new HashSet<TypeNode>();
        HashSet<TypeNode> interNodes = new HashSet<TypeNode>();
        block21: for (TypeNode n3 : grooveTypeGraph.nodeSet()) {
            id = this.getNodeId(n3);
            switch (this.m_types.getModelType(this.getLabel(n3))) {
                case TypeClass: {
                    c = this.m_typeModel.getClass(id, true).getProperClass();
                    this.setNodeType(n3, c);
                    if (!n3.isAbstract() || !this.m_cfg.getConfig().getTypeModel().getProperties().isUseAbstract()) continue block21;
                    this.m_typeModel.addProperty(new AbstractProperty(c));
                    break;
                }
                case TypeClassNullable: {
                    Class cNull = this.m_typeModel.getClass(id, true).getNullableClass();
                    this.setNodeType(n3, cNull);
                    break;
                }
                case TypeEnum: {
                    e = this.m_typeModel.getEnum(id, true);
                    this.setNodeType(n3, e);
                    enumIds.put(id, e);
                    if (this.m_cfg.getConfig().getTypeModel().getEnumMode() != EnumModeType.FLAG) continue block21;
                    this.populateEnumFlags(n3, e);
                    break;
                }
                case TypeDatatype: {
                    if (n3.isDataType()) {
                        this.setNodeType(n3, g_primitiveIds.get(id));
                        break;
                    }
                    CustomDataType d = this.m_typeModel.getDatatype(id, true);
                    this.setNodeType(n3, d);
                    break;
                }
                case TypeEnumValue: {
                    break;
                }
                case TypeIntermediate: 
                case TypeContainerSet: 
                case TypeContainerBag: 
                case TypeContainerSeq: 
                case TypeContainerOrd: {
                    interNodes.add(n3);
                    break;
                }
                case TypeTuple: {
                    Tuple t = new Tuple(new Type[0]);
                    this.setNodeType(n3, t);
                    tupleNodes.add(n3);
                    break;
                }
                case TypeNone: {
                    break;
                }
                default: {
                    System.err.println("No valid type for node " + n3);
                }
            }
        }
        block22: for (TypeNode n3 : grooveTypeGraph.nodeSet()) {
            id = this.getNodeId(n3);
            switch (this.m_types.getModelType(this.getLabel(n3))) {
                case TypeClass: {
                    c = (Class)this.getNodeType(n3);
                    Set<TypeNode> superTypes = n3.getGraph().getDirectSupertypeMap().get(n3);
                    for (TypeNode superType : superTypes) {
                        Class superClass = (Class)this.getNodeType(superType);
                        if (!superClass.isProper()) continue;
                        c.addSuperClass(superClass);
                    }
                    continue block22;
                }
                case TypeEnumValue: {
                    e = null;
                    if (id.getNamespace() == Id.ROOT) {
                        Set<TypeNode> superEnumTypes = n3.getGraph().getDirectSupertypeMap().get(n3);
                        e = (Enum)this.getNodeType(superEnumTypes.iterator().next());
                    } else {
                        e = (Enum)enumIds.get(id.getNamespace());
                    }
                    e.addLiteral(id.getName());
                    this.setNodeType(n3, e);
                    break;
                }
            }
        }
        for (TypeNode interNode : interNodes) {
            this.resolveIntermediateType(interNode);
        }
        for (TypeEdge e3 : edges) {
            GraphNodeTypes.ModelType targetModelType;
            if (this.m_types.getModelType(this.getLabel((TypeNode)e3.source())) != GraphNodeTypes.ModelType.TypeClass) continue;
            Class cmClass = (Class)this.getNodeType((TypeNode)e3.source());
            Type targetType = null;
            targetType = this.m_intermediateFields.containsKey(e3.target()) ? this.m_intermediateFields.get(e3.target()) : this.getNodeType((TypeNode)e3.target());
            Name fieldName = Name.getName(((TypeLabel)e3.label()).text());
            int lower = 0;
            int upper = -1;
            if (e3.getOutMult() != null) {
                lower = (Integer)e3.getOutMult().one();
                upper = (Integer)e3.getOutMult().two();
                if (upper == Integer.MAX_VALUE) {
                    upper = -1;
                }
            }
            if (e3.isComposite() && this.m_cfg.getConfig().getTypeModel().getProperties().isUseContainment()) {
                this.m_typeModel.addProperty(new ContainmentProperty(cmClass, fieldName));
            }
            if ((targetModelType = this.m_types.getModelType(this.getLabel((TypeNode)e3.target()))) == GraphNodeTypes.ModelType.TypeIntermediate && !(targetType instanceof Container)) {
                this.setNodeType((TypeNode)e3.target(), null);
            }
            if ((upper > 1 || lower == 0 && targetType instanceof Class && this.m_cfg.getConfig().getGlobal().getNullable() != NullableType.NONE) && targetModelType != GraphNodeTypes.ModelType.TypeIntermediate && targetModelType != GraphNodeTypes.ModelType.TypeContainerSet && targetModelType != GraphNodeTypes.ModelType.TypeContainerBag && targetModelType != GraphNodeTypes.ModelType.TypeContainerOrd && targetModelType != GraphNodeTypes.ModelType.TypeContainerSeq) {
                OrderType orderType = this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getType();
                boolean isOrdered = false;
                if (this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getMode() == ModeType.PREFER_VALUE) {
                    if (orderType == OrderType.INDEX) {
                        String indexName = this.m_cfg.getStrings().getIndexEdge();
                        if (this.hasEdge((TypeNode)e3.target(), indexName)) {
                            isOrdered = true;
                        }
                    } else if (orderType == OrderType.EDGE) {
                        String nextName = this.m_cfg.getStrings().getNextEdge();
                        if (this.hasEdge((TypeNode)e3.target(), nextName)) {
                            isOrdered = true;
                        }
                    }
                }
                targetType = new Container(isOrdered ? Container.Kind.ORD : Container.Kind.SET, targetType);
            }
            Field f = new Field(fieldName, targetType, lower, upper);
            cmClass.addField(f);
        }
        for (TypeNode tupleNode : tupleNodes) {
            Tuple t = (Tuple)this.getNodeType(tupleNode);
            Set<TypeEdge> tupleEdges = this.m_nodeEdges.get(tupleNode);
            Type[] subTypes = new Type[tupleEdges.size()];
            int index = 0;
            for (TypeEdge e4 : tupleEdges) {
                subTypes[index++] = this.getNodeType((TypeNode)e4.target());
            }
            t.setTypes(subTypes);
        }
        this.m_typeModel.resolve();
        this.m_typeModels.put(this.m_typeModel.getName(), this.m_typeModel);
    }

    private void populateEnumFlags(TypeNode n, Enum e) {
        for (TypeEdge edge : this.m_nodeEdges.get(n)) {
            if (edge.getRole() != EdgeRole.FLAG) continue;
            e.addLiteral(Name.getName(((TypeLabel)edge.label()).text()));
        }
    }

    @Override
    public TypeModel getTypeModel(String modelName) throws ImportException {
        return (TypeModel)this.m_typeModels.get(modelName);
    }

    private Id getNodeId(TypeNode n) {
        if (this.m_typeIds.containsKey(n)) {
            return this.m_typeIds.get(n);
        }
        Id id = this.m_cfg.nameToId(n.label().text());
        this.m_typeIds.put(n, id);
        return id;
    }

    private String getLabel(TypeNode node) {
        return node.label().text();
    }

    private Type resolveIntermediateType(TypeNode interNode) {
        if (this.getNodeType(interNode) != null) {
            return this.getNodeType(interNode);
        }
        String valueEdge = this.m_cfg.getStrings().getValueEdge();
        TypeNode valueNode = this.getEdgeNode(interNode, valueEdge);
        Type t = this.resolveIntermediateType(valueNode);
        switch (this.m_types.getModelType(this.getLabel(interNode))) {
            case TypeContainerSet: {
                Container cSet = new Container(Container.Kind.SET, t);
                this.setNodeType(interNode, cSet);
                return cSet;
            }
            case TypeContainerBag: {
                Container cBag = new Container(Container.Kind.BAG, t);
                this.setNodeType(interNode, cBag);
                return cBag;
            }
            case TypeContainerOrd: {
                Container cOrd = new Container(Container.Kind.ORD, t);
                this.setNodeType(interNode, cOrd);
                return cOrd;
            }
            case TypeContainerSeq: {
                Container cSeq = new Container(Container.Kind.SEQ, t);
                this.setNodeType(interNode, cSeq);
                return cSeq;
            }
        }
        if (this.m_cfg.getConfig().getTypeModel().getFields().getContainers().isUseTypeName()) {
            Container.Kind ct = this.getPostfixType(interNode);
            if (ct != null) {
                Container c = new Container(ct, t);
                this.setNodeType(interNode, c);
                return c;
            }
            this.m_intermediateFields.put(interNode, t);
            return t;
        }
        boolean isOrdered = false;
        boolean isUnique = false;
        OrderType orderType = this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getType();
        if (orderType == OrderType.INDEX) {
            String indexName = this.m_cfg.getStrings().getIndexEdge();
            if (this.hasEdge(interNode, indexName)) {
                isOrdered = true;
            }
            if (!(t instanceof Container) && this.hasEdge(valueNode, indexName)) {
                isOrdered = true;
            }
        } else if (orderType == OrderType.EDGE) {
            String nextName = this.m_cfg.getStrings().getNextEdge();
            if (this.hasEdge(interNode, nextName)) {
                isOrdered = true;
            }
            if (!(t instanceof Container) && this.hasEdge(valueNode, nextName)) {
                isOrdered = true;
            }
        }
        Container.Kind type = isUnique ? (isOrdered ? Container.Kind.ORD : Container.Kind.SET) : (isOrdered ? Container.Kind.SEQ : Container.Kind.BAG);
        Container c = new Container(type, t);
        this.setNodeType(interNode, c);
        return c;
    }

    private TypeNode getEdgeNode(TypeNode node, String edge) {
        Set<TypeEdge> nodeEdges = this.m_nodeEdges.get(node);
        for (TypeEdge e : nodeEdges) {
            if (!((TypeLabel)e.label()).text().equals(edge)) continue;
            return (TypeNode)e.target();
        }
        return null;
    }

    private boolean hasEdge(TypeNode node, String edge) {
        return this.getEdgeNode(node, edge) != null;
    }

    private void setNodeType(TypeNode node, Type type) {
        this.m_types.addType(node.label().text(), type);
    }

    private Type getNodeType(TypeNode node) {
        return this.m_types.getType(node.label().text());
    }

    private Container.Kind getPostfixType(TypeNode node) {
        String typeName = node.label().text();
        if (this.m_cfg.getStrings().getMetaContainerSet().length() > 0 && typeName.endsWith(this.m_cfg.getStrings().getMetaContainerSet())) {
            return Container.Kind.SET;
        }
        if (this.m_cfg.getStrings().getMetaContainerBag().length() > 0 && typeName.endsWith(this.m_cfg.getStrings().getMetaContainerBag())) {
            return Container.Kind.BAG;
        }
        if (this.m_cfg.getStrings().getMetaContainerOrd().length() > 0 && typeName.endsWith(this.m_cfg.getStrings().getMetaContainerOrd())) {
            return Container.Kind.ORD;
        }
        if (this.m_cfg.getStrings().getMetaContainerSeq().length() > 0 && typeName.endsWith(this.m_cfg.getStrings().getMetaContainerSeq())) {
            return Container.Kind.SEQ;
        }
        return null;
    }
}

