/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.type;

import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.Type;
import java.util.Arrays;
import java.util.List;

public class Tuple
extends Type {
    private Type[] m_types;

    public Tuple(Type ... types) {
        this.m_types = types;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public String typeString() {
        return "Tuple";
    }

    @Override
    public String toString() {
        String res = String.valueOf(this.typeString()) + "<";
        boolean first = true;
        Type[] typeArray = this.m_types;
        int n = this.m_types.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            if (!first) {
                res = String.valueOf(res) + ", ";
            }
            res = t.isComplex() ? String.valueOf(res) + t.typeString() : String.valueOf(res) + t.toString();
            first = false;
            ++n2;
        }
        res = String.valueOf(res) + ">";
        return res;
    }

    public List<Type> getTypes() {
        return Arrays.asList(this.m_types);
    }

    public void setTypes(Type ... types) {
        this.m_types = types;
    }

    @Override
    public boolean doVisit(Visitor v, Object param) {
        v.visit(this, param);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple t = (Tuple)o;
        if (t.m_types.length != this.m_types.length) {
            return false;
        }
        int i = 0;
        while (i < this.m_types.length) {
            boolean eq = this.m_types[i].equals(t.m_types[i]);
            if (!eq) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

