/*
 * Decompiled with CFR 0.152.
 */
package groove.io.ecore2groove;

import groove.graph.GraphRole;
import groove.graph.plain.PlainEdge;
import groove.graph.plain.PlainFactory;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainLabel;
import groove.graph.plain.PlainNode;
import groove.io.ecore2groove.GraphLabels;
import groove.io.ecore2groove.ModelHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TypeGraphRep {
    private final ModelHandler mh;
    private final PlainGraph tg;
    private final PlainGraph ecoreTG;
    private PlainNode eClassNode;
    private PlainNode eReferenceNode;
    private PlainNode eAttributeNode;
    private PlainNode eEnumNode;
    private Map<EClass, PlainNode> eClassToNodeMap = new HashMap<EClass, PlainNode>();
    private Map<EEnum, PlainNode> eEnumToNodeMap = new HashMap<EEnum, PlainNode>();
    private Map<EReference, PlainNode> eReferenceToNodeMap = new HashMap<EReference, PlainNode>();
    private Map<EAttribute, PlainNode> eAttributeToNodeMap = new HashMap<EAttribute, PlainNode>();
    private Map<EDataType, PlainNode> eDataTypeToNodeMap = new HashMap<EDataType, PlainNode>();
    private Map<EEnumLiteral, PlainEdge> eEnumLiteralToEdgeMap = new HashMap<EEnumLiteral, PlainEdge>();
    private static final PlainFactory factory = PlainFactory.instance();
    private static final PlainLabel SUB_LABEL = factory.createLabel("sub:");
    private static final PlainLabel ROOT_LABEL = factory.createLabel("flag:root");
    private static final PlainLabel CONT_LABEL = factory.createLabel("flag:containment");
    private static final PlainLabel ABS_VAL_LABEL = factory.createLabel("abs:val");
    private static final PlainLabel ABS_WILDCARD_LABEL = factory.createLabel("abs:?");
    private static final PlainLabel NEXT_LABEL = factory.createLabel("next");
    private static final PlainLabel OPPOSITE_LABEL = factory.createLabel("opposite");
    private static final PlainLabel VAL_LABEL = factory.createLabel("val");

    public TypeGraphRep(String name, ModelHandler m) {
        this.mh = m;
        this.tg = new PlainGraph(name);
        this.tg.setRole(GraphRole.TYPE);
        this.ecoreTG = new PlainGraph("EcoreTypes");
        this.ecoreTG.setRole(GraphRole.TYPE);
        this.addEcoreTypes();
        this.addEClasses(this.mh.getEClasses());
        this.addEClassSubInfo(this.mh.getEClasses());
        this.addEReferences(this.mh.getEReferences());
        this.addEEnums(this.mh.getEEnums());
        this.addEEnumLiterals(this.mh.getEEnumLiterals());
        this.addEDataTypes(this.mh.getEDataTypes());
        this.addEAttributes(this.mh.getEAttributes());
    }

    private void addEcoreTypes() {
        PlainLabel eClassLabel = factory.createLabel(this.mh.getEClassType());
        PlainLabel eReferenceLabel = factory.createLabel(this.mh.getEReferenceType());
        PlainLabel eAttributeLabel = factory.createLabel(this.mh.getEAttributeType());
        PlainLabel eEnumLabel = factory.createLabel(this.mh.getEEnumType());
        this.eClassNode = this.addTypeNode(this.ecoreTG, eClassLabel);
        this.eReferenceNode = this.addTypeNode(this.ecoreTG, eReferenceLabel);
        this.eAttributeNode = this.addTypeNode(this.ecoreTG, eAttributeLabel);
        this.eEnumNode = this.addTypeNode(this.ecoreTG, eEnumLabel);
        this.ecoreTG.addEdge(this.eClassNode, ROOT_LABEL, this.eClassNode);
        this.ecoreTG.addEdge(this.eReferenceNode, CONT_LABEL, this.eReferenceNode);
        this.ecoreTG.addEdge(this.eAttributeNode, ABS_VAL_LABEL, this.eEnumNode);
        this.ecoreTG.addEdge(this.eReferenceNode, ABS_VAL_LABEL, this.eClassNode);
        this.ecoreTG.addEdge(this.eClassNode, ABS_WILDCARD_LABEL, this.eReferenceNode);
    }

    private void addEClasses(Vector<EClass> classes) {
        for (EClass aClass : classes) {
            String labelText = GraphLabels.getLabel((EClassifier)aClass);
            PlainLabel label = factory.createLabel(labelText);
            PlainNode node = this.addTypeNode(this.tg, label);
            this.eClassToNodeMap.put(aClass, node);
            PlainNode ecoreNode = this.addTypeNode(this.ecoreTG, label);
            this.ecoreTG.addEdge(ecoreNode, SUB_LABEL, this.eClassNode);
        }
    }

    private void addEClassSubInfo(Vector<EClass> classes) {
        for (EClass aClass : classes) {
            EList superTypes = aClass.getESuperTypes();
            for (EClass superType : superTypes) {
                PlainEdge edge = (PlainEdge)factory.createEdge(this.eClassToNodeMap.get(aClass), SUB_LABEL, this.eClassToNodeMap.get(superType));
                this.tg.addEdgeContext(edge);
            }
        }
    }

    private void addEEnums(Vector<EEnum> enums) {
        for (EEnum aEnum : enums) {
            String labelText = GraphLabels.getLabel(aEnum);
            PlainLabel label = factory.createLabel(labelText);
            PlainNode node = this.addTypeNode(this.tg, label);
            this.eEnumToNodeMap.put(aEnum, node);
            PlainNode ecoreNode = this.addTypeNode(this.ecoreTG, label);
            this.ecoreTG.addEdge(ecoreNode, SUB_LABEL, this.eEnumNode);
        }
    }

    private void addEEnumLiterals(Vector<EEnumLiteral> literals) {
        for (EEnumLiteral literal : literals) {
            String labelText = GraphLabels.getLabel(literal);
            EEnum aEnum = literal.getEEnum();
            PlainNode source = this.eEnumToNodeMap.get(aEnum);
            PlainEdge edge = (PlainEdge)factory.createEdge(source, labelText, source);
            this.tg.addEdgeContext(edge);
            this.eEnumLiteralToEdgeMap.put(literal, edge);
        }
    }

    private void addEDataTypes(Vector<EDataType> datatypes) {
        for (EDataType datatype : datatypes) {
            String labelText = GraphLabels.getLabel(datatype);
            if (labelText.isEmpty()) continue;
            boolean present = false;
            PlainNode node = null;
            for (PlainEdge plainEdge : this.tg.edgeSet()) {
                if (!((PlainLabel)plainEdge.label()).text().equals(labelText)) continue;
                present = true;
                node = (PlainNode)plainEdge.source();
                break;
            }
            if (!present) {
                PlainLabel plainLabel = factory.createLabel(labelText);
                node = this.addTypeNode(this.tg, plainLabel);
            }
            this.eDataTypeToNodeMap.put(datatype, node);
        }
    }

    private void addEReferences(Vector<EReference> references) {
        for (EReference aReference : references) {
            EReference opposite;
            String labelText = GraphLabels.getLabel((EStructuralFeature)aReference);
            PlainLabel label = factory.createLabel(labelText);
            PlainNode node = this.addTypeNode(this.tg, label);
            PlainLabel sourceLabel = factory.createLabel(aReference.getName());
            PlainNode source = this.eClassToNodeMap.get(aReference.getEContainingClass());
            PlainNode target = this.eClassToNodeMap.get(aReference.getEReferenceType());
            this.tg.addEdge(source, sourceLabel, node);
            this.tg.addEdge(node, VAL_LABEL, target);
            if (aReference.isOrdered() && aReference.isMany()) {
                this.tg.addEdge(node, NEXT_LABEL, node);
            }
            if (aReference.getEOpposite() != null && this.eReferenceToNodeMap.containsKey(opposite = aReference.getEOpposite())) {
                PlainNode oppositeNode = this.eReferenceToNodeMap.get(opposite);
                this.tg.addEdge(node, OPPOSITE_LABEL, oppositeNode);
                this.tg.addEdge(oppositeNode, OPPOSITE_LABEL, node);
            }
            PlainNode ecoreNode = this.addTypeNode(this.ecoreTG, label);
            this.ecoreTG.addEdge(ecoreNode, SUB_LABEL, this.eReferenceNode);
            this.eReferenceToNodeMap.put(aReference, node);
        }
    }

    private void addEAttributes(Vector<EAttribute> attributes) {
        for (EAttribute aAttribute : attributes) {
            String labelText = GraphLabels.getLabel((EStructuralFeature)aAttribute);
            PlainLabel label = factory.createLabel(labelText);
            PlainNode node = this.addTypeNode(this.tg, label);
            PlainNode ecoreNode = this.addTypeNode(this.ecoreTG, label);
            this.ecoreTG.addEdge(ecoreNode, SUB_LABEL, this.eAttributeNode);
            PlainNode source = this.eClassToNodeMap.get(aAttribute.getEContainingClass());
            PlainLabel sourceLabel = factory.createLabel(aAttribute.getName());
            this.tg.addEdge(source, sourceLabel, node);
            if (aAttribute.isOrdered() && aAttribute.isMany()) {
                this.tg.addEdge(node, NEXT_LABEL, node);
            }
            if (aAttribute.getEAttributeType().eClass().getName().equals("EEnum")) {
                PlainNode target = this.eEnumToNodeMap.get(aAttribute.getEAttributeType());
                this.tg.addEdge(node, VAL_LABEL, target);
            } else {
                EDataType type = aAttribute.getEAttributeType();
                if (this.eDataTypeToNodeMap.containsKey(type)) {
                    PlainNode target = this.eDataTypeToNodeMap.get(type);
                    this.tg.addEdge(node, VAL_LABEL, target);
                }
            }
            this.eAttributeToNodeMap.put(aAttribute, node);
        }
    }

    private PlainNode addTypeNode(PlainGraph graph, PlainLabel label) {
        PlainNode node = (PlainNode)graph.addNode();
        graph.addEdge(node, label, node);
        return node;
    }

    public PlainGraph getTypeGraph() {
        return this.tg;
    }

    public PlainGraph getEcoreTypeGraph() {
        return this.ecoreTG;
    }
}

