/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external;

import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.graph.Graph;
import groove.gui.Simulator;
import groove.gui.dialog.ErrorDialog;
import groove.gui.dialog.SaveDialog;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.JGraph;
import groove.io.ExtensionFilter;
import groove.io.GrooveFileChooser;
import groove.io.external.Format;
import groove.io.external.FormatExporter;
import groove.io.external.FormatFilter;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.io.external.format.AutPorter;
import groove.io.external.format.DotPorter;
import groove.io.external.format.EcorePorter;
import groove.io.external.format.FsmExporter;
import groove.io.external.format.GxlPorter;
import groove.io.external.format.KthExporter;
import groove.io.external.format.NativePorter;
import groove.io.external.format.RasterExporter;
import groove.io.external.format.TikzExporter;
import groove.io.external.format.VectorExporter;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class Exporter {
    private static final Exporter instance = new Exporter();
    private static final List<FormatExporter> exporters = new ArrayList<FormatExporter>();

    static {
        exporters.add(NativePorter.getInstance());
        exporters.add(RasterExporter.getInstance());
        exporters.add(VectorExporter.getInstance());
        exporters.add(AutPorter.getInstance());
        exporters.add(KthExporter.getInstance());
        exporters.add(FsmExporter.getInstance());
        exporters.add(TikzExporter.getInstance());
        exporters.add(EcorePorter.instance());
        exporters.add(GxlPorter.instance());
        exporters.add(DotPorter.getInstance());
    }

    public static Exporter instance() {
        return instance;
    }

    private Exporter() {
    }

    public void doExport(Simulator simulator, Exportable exportable) {
        ArrayList<Format> formats = new ArrayList<Format>();
        for (FormatExporter rf : Exporter.getExporters()) {
            if (!exportable.containsKind(rf.getFormatKind())) continue;
            formats.addAll(rf.getSupportedFormats());
        }
        if (formats.size() == 0) {
            return;
        }
        GrooveFileChooser chooser = this.getChooser(formats);
        chooser.setSelectedFile(new File(exportable.getName()));
        File selectedFile = SaveDialog.show(chooser, simulator.getFrame(), null);
        if (selectedFile != null) {
            try {
                FormatFilter filter = (FormatFilter)chooser.getFileFilter();
                Format format = filter.getFormat();
                FormatPorter e = filter.getFormat().getFormatter();
                e.setSimulator(simulator);
                ((FormatExporter)e).doExport(selectedFile, format, exportable);
            }
            catch (PortException e) {
                this.showErrorDialog(simulator.getFrame(), e, "Error while exporting to " + selectedFile, new Object[0]);
            }
        }
    }

    private GrooveFileChooser getChooser(List<Format> formats) {
        GrooveFileChooser result = null;
        ArrayList<ExtensionFilter> filters = new ArrayList<ExtensionFilter>();
        for (Format f : formats) {
            filters.add(f.getFilter());
        }
        result = GrooveFileChooser.getFileChooser(filters);
        return result;
    }

    private void showErrorDialog(Component parent, Throwable exc, String message, Object ... args) {
        new ErrorDialog(parent, String.format(message, args), exc).setVisible(true);
    }

    public static Format getAcceptingFormat(Graph graph, File file) {
        Format result = null;
        block0: for (FormatExporter rf : exporters) {
            if (rf.getFormatKind() != FormatPorter.Kind.GRAPH) continue;
            for (Format format : rf.getSupportedFormats()) {
                for (String ext : format.getExtensions()) {
                    if (!file.getName().endsWith(ext)) continue;
                    result = format;
                    break block0;
                }
            }
        }
        return result;
    }

    public static List<FormatExporter> getExporters() {
        return Collections.unmodifiableList(exporters);
    }

    public static class Exportable {
        private final EnumSet<FormatPorter.Kind> porterKinds;
        private final String name;
        private final Graph graph;
        private final JGraph<?> jGraph;
        private final ResourceModel<?> model;

        public Exportable(Graph graph) {
            this.porterKinds = EnumSet.of(FormatPorter.Kind.GRAPH);
            this.name = graph.getName();
            this.jGraph = null;
            this.graph = graph;
            this.model = null;
        }

        public Exportable(JGraph<?> jGraph) {
            this.porterKinds = EnumSet.of(FormatPorter.Kind.GRAPH, FormatPorter.Kind.JGRAPH);
            this.jGraph = jGraph;
            this.graph = jGraph.getModel().getGraph();
            ResourceModel resourceModel = this.model = jGraph instanceof AspectJGraph ? ((AspectJGraph)jGraph).getModel().getResourceModel() : null;
            if (this.model != null) {
                this.porterKinds.add(FormatPorter.Kind.RESOURCE);
            }
            this.name = this.graph.getName();
        }

        public Exportable(ResourceModel<?> model) {
            this.porterKinds = EnumSet.of(FormatPorter.Kind.RESOURCE);
            if (model.getKind().isGraphBased()) {
                this.porterKinds.add(FormatPorter.Kind.GRAPH);
                this.graph = ((GraphBasedModel)model).getSource();
            } else {
                this.graph = null;
            }
            this.name = model.getFullName();
            this.model = model;
            this.jGraph = null;
        }

        public Exportable(JGraph<?> jGraph, ResourceModel<?> model) {
            this.porterKinds = EnumSet.of(FormatPorter.Kind.GRAPH, FormatPorter.Kind.JGRAPH, FormatPorter.Kind.RESOURCE);
            this.name = model.getFullName();
            this.jGraph = jGraph;
            this.graph = jGraph.getModel().getGraph();
            this.model = model;
        }

        public boolean containsKind(FormatPorter.Kind kind) {
            return this.porterKinds.contains((Object)kind);
        }

        public String getName() {
            return this.name;
        }

        public Graph getGraph() {
            return this.graph;
        }

        public JGraph<?> getJGraph() {
            return this.jGraph;
        }

        public ResourceKind getKind() {
            return this.getModel() == null ? null : this.getModel().getKind();
        }

        public ResourceModel<?> getModel() {
            return this.model;
        }
    }
}

