/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.grammar.model.GrammarModel;
import groove.io.GrooveFileChooser;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.ecore.EcoreResource;
import groove.io.conceptual.lang.ecore.EcoreToInstance;
import groove.io.conceptual.lang.ecore.EcoreToType;
import groove.io.conceptual.lang.ecore.InstanceToEcore;
import groove.io.conceptual.lang.ecore.TypeToEcore;
import groove.io.external.ConceptualPorter;
import groove.io.external.FormatFilter;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.util.Pair;
import java.io.File;

public class EcorePorter
extends ConceptualPorter {
    private final GrooveFileChooser typemodelChooser;
    private static final EcorePorter instance = new EcorePorter();

    private EcorePorter() {
        super("Ecore ", ".ecore", ".xmi");
        FormatFilter typeFilter = this.getTypeFormat().getFilter();
        this.typemodelChooser = GrooveFileChooser.getFileChooser(typeFilter);
        this.typemodelChooser.setFileFilter(typeFilter);
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.RESOURCE;
    }

    @Override
    protected Pair<TypeModel, InstanceModel> importTypeModel(File file, GrammarModel grammar) throws ImportException {
        EcoreToType ett = new EcoreToType(file.toString());
        TypeModel tm = ett.getTypeModel();
        return Pair.newPair(tm, null);
    }

    @Override
    protected Pair<TypeModel, InstanceModel> importInstanceModel(File file, GrammarModel grammar) throws ImportException {
        int approve = this.typemodelChooser.showDialog(null, "Import Ecore type model");
        if (approve != 0) {
            return null;
        }
        File typeFile = this.typemodelChooser.getSelectedFile();
        EcoreToType ett = new EcoreToType(typeFile.toString());
        EcoreToInstance eti = new EcoreToInstance(ett, file.toString());
        TypeModel tm = ett.getTypeModel();
        InstanceModel im = eti.getInstanceModel();
        return Pair.newPair(tm, im);
    }

    @Override
    protected ExportableResource getResource(File file, boolean isHost, TypeModel tm, InstanceModel im) throws PortException {
        File typeFile = file;
        File instanceFile = file;
        if (isHost) {
            int approve = this.typemodelChooser.showDialog(null, "Pick Ecore model");
            typeFile = approve == 0 ? this.typemodelChooser.getSelectedFile() : null;
        } else {
            instanceFile = null;
        }
        EcoreResource result = new EcoreResource(typeFile, instanceFile);
        TypeToEcore tte = new TypeToEcore(result);
        tte.addTypeModel(tm);
        if (isHost) {
            InstanceToEcore ite = new InstanceToEcore(tte);
            ite.addInstanceModel(im);
        }
        return result;
    }

    public static final EcorePorter instance() {
        return instance;
    }
}

