/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Node;
import groove.io.external.AbstractFormatExporter;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public final class FsmExporter
extends AbstractFormatExporter {
    private final Format fsmformat = new Format((FormatPorter)this, "FSM layout files", ".fsm");
    private static final FsmExporter instance = new FsmExporter();

    private FsmExporter() {
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.GRAPH;
    }

    @Override
    public Collection<? extends Format> getSupportedFormats() {
        return Collections.singletonList(this.fsmformat);
    }

    @Override
    public void doExport(File file, Format format, Exporter.Exportable exportable) throws PortException {
        Graph graph = exportable.getGraph();
        try {
            PrintWriter writer = new PrintWriter(file);
            this.save(graph, writer);
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new PortException(e);
        }
    }

    private void save(Graph graph, PrintWriter writer) {
        HashMap<Node, Integer> nodeMap = new HashMap<Node, Integer>();
        writer.println("NodeNumber(0)");
        writer.println("---");
        int nr = 1;
        for (Node node : graph.nodeSet()) {
            nodeMap.put(node, nr);
            writer.println(nr);
            ++nr;
        }
        writer.println("---");
        for (Edge edge : graph.edgeSet()) {
            writer.println(nodeMap.get(edge.source()) + " " + nodeMap.get(edge.target()) + " " + "\"" + edge.label() + "\"");
        }
    }

    public static final FsmExporter getInstance() {
        return instance;
    }
}

