/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.grammar.model.GrammarModel;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.gxl.GxlResource;
import groove.io.conceptual.lang.gxl.GxlToInstance;
import groove.io.conceptual.lang.gxl.GxlToType;
import groove.io.conceptual.lang.gxl.InstanceToGxl;
import groove.io.conceptual.lang.gxl.TypeToGxl;
import groove.io.external.ConceptualPorter;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.util.Pair;
import java.io.File;

public class GxlPorter
extends ConceptualPorter {
    private static final GxlPorter instance = new GxlPorter();

    private GxlPorter() {
        super("GXL", ".gxl");
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.RESOURCE;
    }

    @Override
    protected Pair<TypeModel, InstanceModel> importTypeModel(File file, GrammarModel grammar) throws ImportException {
        GxlToType gtt = new GxlToType(file.toString(), false);
        TypeModel tm = gtt.getTypeModel();
        return Pair.newPair(tm, null);
    }

    @Override
    protected Pair<TypeModel, InstanceModel> importInstanceModel(File file, GrammarModel grammar) throws ImportException {
        GxlToType gtt = new GxlToType(file.toString(), false);
        GxlToInstance gti = new GxlToInstance(gtt, file.toString());
        TypeModel tm = gtt.getTypeModel();
        InstanceModel im = gti.getInstanceModel();
        return Pair.newPair(tm, im);
    }

    @Override
    protected ExportableResource getResource(File file, boolean isHost, TypeModel tm, InstanceModel im) throws PortException {
        GxlResource result = new GxlResource(file, file);
        TypeToGxl ttg = new TypeToGxl(result);
        ttg.addTypeModel(tm);
        if (isHost) {
            InstanceToGxl itg = new InstanceToGxl(ttg);
            itg.addInstanceModel(im);
        }
        return result;
    }

    public static final GxlPorter instance() {
        return instance;
    }
}

