/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.util;

import groove.gui.look.Line;
import groove.gui.look.LineFormat;
import groove.util.Duo;
import groove.util.Pair;
import java.awt.Color;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class TeXLineFormat
extends LineFormat<TeXBuilder> {
    private static final TeXLineFormat instance = new TeXLineFormat();
    private static final Map<Line.Style, Pair<Duo<String>, Mode>> styleMap;
    private static final Map<Line.ColorType, String> colorMap;
    private static Map<Character, Pair<String, Mode>> charMap;
    private static /* synthetic */ int[] $SWITCH_TABLE$groove$gui$look$Line$ColorType;

    static {
        EnumMap<Enum, Pair<Duo<String>, Mode>> result = new EnumMap<Line.Style, Pair<Duo<String>, Mode>>(Line.Style.class);
        Enum[] enumArray = Line.Style.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mode mode;
            String end;
            String start;
            Line.Style style = enumArray[n2];
            switch (style) {
                case BOLD: {
                    start = "\\textbf{";
                    end = "}";
                    mode = Mode.TEXT;
                    break;
                }
                case ITALIC: {
                    start = "\\textit{";
                    end = "}";
                    mode = Mode.TEXT;
                    break;
                }
                case STRIKE: {
                    start = "\\sout{";
                    end = "}";
                    mode = Mode.TEXT;
                    break;
                }
                case SUPER: {
                    start = "^{";
                    end = "}";
                    mode = Mode.MATH;
                    break;
                }
                default: {
                    end = null;
                    start = null;
                    mode = null;
                    assert (false);
                    break;
                }
            }
            result.put(style, Pair.newPair(Duo.newDuo(start, end), mode));
            ++n2;
        }
        styleMap = result;
        result = new EnumMap(Line.ColorType.class);
        enumArray = Line.ColorType.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            String color;
            Enum type = enumArray[n2];
            switch (TeXLineFormat.$SWITCH_TABLE$groove$gui$look$Line$ColorType()[type.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    color = String.valueOf(type.name().toLowerCase()) + "_c";
                    break;
                }
                default: {
                    color = null;
                }
            }
            result.put(type, (Pair<Duo<String>, Mode>)((Object)("\\color{" + color + "}")));
            ++n2;
        }
        colorMap = result;
        charMap = new HashMap<Character, Pair<String, Mode>>();
        TeXLineFormat.addChar('\u2203', "\\exists", Mode.MATH);
        TeXLineFormat.addChar('\u2200', "\\forall", Mode.MATH);
        TeXLineFormat.addChar('\u03c0', "\\pi", Mode.MATH);
        TeXLineFormat.addChar('\u2009', "\\;", Mode.MATH);
        TeXLineFormat.addChar('\u25be', "{\\blacktriangledown}", Mode.MATH);
        TeXLineFormat.addChar('\u25b4', "{\\blacktriangle}", Mode.MATH);
        TeXLineFormat.addChar('\u25c2', "{\\blacktriangleleft}", Mode.MATH);
        TeXLineFormat.addChar('\u25b8', "{\\blacktriangleright}", Mode.MATH);
        TeXLineFormat.addChar("\u03a9".charAt(0), "\\Omega", Mode.MATH);
        TeXLineFormat.addChar('<', "<", Mode.MATH);
        TeXLineFormat.addChar('>', ">", Mode.MATH);
        TeXLineFormat.addChar('{', "\\{", Mode.BOTH);
        TeXLineFormat.addChar('}', "\\}", Mode.BOTH);
        TeXLineFormat.addChar('[', "{[}", Mode.BOTH);
        TeXLineFormat.addChar(']', "{]}", Mode.BOTH);
        TeXLineFormat.addChar('-', "-", Mode.MATH);
        TeXLineFormat.addChar('+', "+", Mode.BOTH);
        TeXLineFormat.addChar('|', "|", Mode.MATH);
        TeXLineFormat.addChar('\\', "\\backslash", Mode.MATH);
        TeXLineFormat.addChar('~', "\\~{}", Mode.BOTH);
        TeXLineFormat.addChar('&', "\\&", Mode.BOTH);
        TeXLineFormat.addChar('%', "\\%", Mode.BOTH);
        TeXLineFormat.addChar('_', "\\_", Mode.BOTH);
        TeXLineFormat.addChar('#', "\\#", Mode.BOTH);
        TeXLineFormat.addChar('$', "\\$", Mode.BOTH);
        TeXLineFormat.addChar('^', "\\^{}", Mode.TEXT);
        TeXLineFormat.addChar('\n', "\\\\", Mode.BOTH);
        char c = '0';
        while (c <= '9') {
            TeXLineFormat.addChar(c, "" + c, Mode.BOTH);
            c = (char)(c + '\u0001');
        }
    }

    private TeXLineFormat() {
    }

    @Override
    public TeXBuilder applyColored(Line.ColorType type, Color color, TeXBuilder subline) {
        Duo<String> marker = TeXLineFormat.getColorMarker(type, color);
        subline.surround(marker, Mode.TEXT);
        return subline;
    }

    @Override
    public TeXBuilder applyStyled(Line.Style style, TeXBuilder subline) {
        Pair<Duo<String>, Mode> marker = TeXLineFormat.getStyleMarker(style);
        subline.surround(marker.one(), marker.two());
        return subline;
    }

    @Override
    public TeXBuilder applyAtomic(String text) {
        TeXBuilder result = this.createResult();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Pair<String, Mode> spec = TeXLineFormat.getCharSpec(c);
            if (spec == null) {
                result.append("" + c, Mode.TEXT);
            } else {
                result.append(spec.one(), spec.two());
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected TeXBuilder createResult() {
        return new TeXBuilder();
    }

    public static TeXLineFormat instance() {
        return instance;
    }

    private static Pair<Duo<String>, Mode> getStyleMarker(Line.Style style) {
        return styleMap.get((Object)style);
    }

    private static Duo<String> getColorMarker(Line.ColorType type, Color color) {
        String colorString = type == Line.ColorType.RGB ? "\\color[RGB]{" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "}" : colorMap.get((Object)type);
        return Duo.newDuo("{" + colorString, "}");
    }

    private static Pair<String, Mode> getCharSpec(char c) {
        return charMap.get(Character.valueOf(c));
    }

    private static void addChar(char c, String s, Mode mode) {
        charMap.put(Character.valueOf(c), Pair.newPair(s, mode));
    }

    static /* synthetic */ int[] $SWITCH_TABLE$groove$gui$look$Line$ColorType() {
        if ($SWITCH_TABLE$groove$gui$look$Line$ColorType != null) {
            return $SWITCH_TABLE$groove$gui$look$Line$ColorType;
        }
        int[] nArray = new int[Line.ColorType.values().length];
        try {
            nArray[Line.ColorType.CREATOR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Line.ColorType.EMBARGO.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Line.ColorType.ERASER.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Line.ColorType.REMARK.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Line.ColorType.RGB.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$groove$gui$look$Line$ColorType = nArray;
        return nArray;
    }

    private static enum Mode {
        MATH,
        TEXT,
        BOTH;

    }

    static class TeXBuilder
    implements LineFormat.Builder<TeXBuilder> {
        private final StringBuilder content = new StringBuilder();
        private boolean requiresMath;
        private boolean providesMath;
        private boolean mathOnly;
        private static final String TEX_LINEBREAK = "\\\\";

        TeXBuilder() {
        }

        @Override
        public StringBuilder getResult() {
            this.setTextMode();
            return this.content;
        }

        @Override
        public boolean isEmpty() {
            return this.content.length() == 0;
        }

        @Override
        public void append(TeXBuilder other) {
            if (this.isEmpty()) {
                this.content.append((CharSequence)other.content);
                this.requiresMath = other.requiresMath;
                this.providesMath = other.providesMath;
                this.mathOnly = other.mathOnly;
            } else {
                if (this.providesMath != other.requiresMath) {
                    this.content.append("$");
                }
                this.content.append((CharSequence)other.content);
                this.providesMath = other.providesMath;
                this.mathOnly &= other.mathOnly;
            }
        }

        @Override
        public void appendLineBreak() {
            this.append(TEX_LINEBREAK, Mode.TEXT);
        }

        void append(String text, Mode mode) {
            if (this.isEmpty()) {
                this.mathOnly = mode == Mode.MATH;
                this.providesMath = this.mathOnly;
                this.requiresMath = this.mathOnly;
            } else if (this.providesMath ? mode == Mode.TEXT : mode == Mode.MATH) {
                this.content.append("$");
                this.providesMath = !this.providesMath;
                this.mathOnly = false;
            }
            this.content.append(text);
        }

        void surround(Duo<String> marker, Mode mode) {
            boolean math;
            boolean bl = math = mode == Mode.MATH;
            if (!this.isEmpty()) {
                if (math) {
                    if (!this.mathOnly) {
                        this.setTextMode();
                        this.content.insert(0, "\\text{");
                        this.content.append("}");
                    }
                } else {
                    this.setTextMode();
                }
            }
            this.content.insert(0, (String)marker.one());
            this.content.append((String)marker.two());
            this.providesMath = this.mathOnly = math;
            this.requiresMath = this.mathOnly;
        }

        private void setTextMode() {
            if (this.requiresMath) {
                this.content.insert(0, "$");
                this.requiresMath = false;
            }
            if (this.providesMath) {
                this.content.append("$");
                this.providesMath = false;
            }
            this.mathOnly = false;
        }
    }
}

