/*
 * Decompiled with CFR 0.152.
 */
package groove.io.graph;

import groove.graph.ElementFactory;
import groove.graph.Label;
import groove.graph.Morphism;
import groove.graph.plain.PlainLabel;
import groove.io.graph.AttrEdge;
import groove.io.graph.AttrNode;

public class AttrFactory
implements ElementFactory<AttrNode, AttrEdge> {
    private int maxNodeNr;
    private static AttrFactory instance = new AttrFactory();

    private AttrFactory() {
    }

    @Override
    public AttrNode createNode(int nr) {
        this.maxNodeNr = Math.max(this.maxNodeNr, nr);
        return new AttrNode(nr);
    }

    @Override
    public Label createLabel(String text) {
        return PlainLabel.createLabel(text);
    }

    @Override
    public AttrEdge createEdge(AttrNode source, String text, AttrNode target) {
        return this.createEdge(source, this.createLabel(text), target);
    }

    @Override
    public AttrEdge createEdge(AttrNode source, Label label, AttrNode target) {
        return new AttrEdge(source, (PlainLabel)label, target);
    }

    @Override
    public Morphism<AttrNode, AttrEdge> createMorphism() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxNodeNr() {
        return this.maxNodeNr;
    }

    public static AttrFactory instance() {
        return instance;
    }
}

