/*
 * Decompiled with CFR 0.152.
 */
package groove.io.store;

import groove.grammar.GrammarProperties;
import groove.grammar.QualName;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.FormatException;
import groove.grammar.model.ResourceKind;
import groove.grammar.type.TypeLabel;
import groove.graph.GraphInfo;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.io.Util;
import groove.io.graph.AttrGraph;
import groove.io.graph.GxlIO;
import groove.io.graph.LayoutIO;
import groove.io.store.EditType;
import groove.io.store.SystemStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.undo.AbstractUndoableEdit;

public class DefaultArchiveSystemStore
extends SystemStore {
    private GrammarProperties properties;
    private final Map<String, ZipEntry> layoutEntryMap;
    private final URL url;
    private final File file;
    private final String location;
    private final String entryName;
    private final String grammarName;
    private boolean initialised;
    private final Observable observable;
    private boolean hasSystemPropertiesFile;
    private static final String JAR_PROTOCOL = FileType.JAR.getExtensionName();
    public static final String NO_JAR_OR_ZIP_SUFFIX = "is not a JAR or ZIP file";

    public DefaultArchiveSystemStore(File file) throws IllegalArgumentException {
        String extendedName;
        this.layoutEntryMap = new HashMap<String, ZipEntry>();
        this.observable = new Observable();
        this.hasSystemPropertiesFile = false;
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File '%s' does not exist", file));
        }
        if (!file.isDirectory() && FileType.JAR_FILTER.accept(file)) {
            extendedName = FileType.JAR_FILTER.stripExtension(file.getName());
        } else if (!file.isDirectory() && FileType.ZIP_FILTER.accept(file)) {
            extendedName = FileType.ZIP_FILTER.stripExtension(file.getName());
        } else {
            throw new IllegalArgumentException(String.format("File '%s' is not a JAR or ZIP file", file));
        }
        this.location = file.toString();
        this.file = file;
        this.entryName = extendedName;
        this.grammarName = FileType.GRAMMAR_FILTER.stripExtension(extendedName);
        this.url = null;
    }

    public DefaultArchiveSystemStore(URL url) throws IllegalArgumentException, IOException {
        block4: {
            this.layoutEntryMap = new HashMap<String, ZipEntry>();
            this.observable = new Observable();
            this.hasSystemPropertiesFile = false;
            try {
                url = new URL(url.getProtocol(), url.getAuthority(), url.getPath());
            }
            catch (MalformedURLException exc) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)String.format("Stripping URL '%s' throws exception: %s", url, exc));
            }
        }
        this.location = url.toString();
        if (!url.getProtocol().equals(JAR_PROTOCOL)) {
            if (!FileType.JAR_FILTER.hasExtension(url.getPath()) && !FileType.ZIP_FILTER.hasExtension(url.getPath())) {
                throw new IllegalArgumentException(String.format("URL '%s' is not a JAR or ZIP file", url));
            }
            url = new URL(JAR_PROTOCOL, null, String.valueOf(url.toString()) + "!/");
        }
        this.entryName = this.extractEntryName(url);
        File fileFromEntry = new File(this.entryName);
        this.grammarName = FileType.GRAMMAR_FILTER.stripExtension(fileFromEntry.getName());
        this.url = url;
        this.file = null;
    }

    private String extractEntryName(URL url) throws IOException {
        JarURLConnection connection = (JarURLConnection)url.openConnection();
        String result = connection.getEntryName();
        if (result == null) {
            result = ExtensionFilter.getPureName(new File(connection.getJarFileURL().getPath()));
        }
        return result;
    }

    @Override
    public String getName() {
        return this.grammarName;
    }

    @Override
    public Map<String, AspectGraph> getGraphs(ResourceKind kind) {
        this.testInit();
        return Collections.unmodifiableMap(this.getGraphMap(kind));
    }

    @Override
    public Collection<AspectGraph> putGraphs(ResourceKind kind, Collection<AspectGraph> graphs, boolean layout) throws IOException {
        throw this.createImmutable();
    }

    @Override
    public Collection<AspectGraph> deleteGraphs(ResourceKind kind, Collection<String> names) throws IOException {
        throw this.createImmutable();
    }

    @Override
    public Map<String, String> getTexts(ResourceKind kind) {
        this.testInit();
        return Collections.unmodifiableMap(this.getTextMap(kind));
    }

    @Override
    public Map<String, String> putTexts(ResourceKind kind, Map<String, String> texts) throws IOException {
        throw this.createImmutable();
    }

    @Override
    public Map<String, String> deleteTexts(ResourceKind kind, Collection<String> names) throws IOException {
        throw this.createImmutable();
    }

    @Override
    public void rename(ResourceKind kind, String oldName, String newName) throws IOException {
        throw this.createImmutable();
    }

    @Override
    public GrammarProperties getProperties() {
        this.testInit();
        return this.properties;
    }

    @Override
    public void putProperties(GrammarProperties properties) throws IOException {
        throw this.createImmutable();
    }

    @Override
    public void relabel(TypeLabel oldLabel, TypeLabel newLabel) throws IOException {
        throw this.createImmutable();
    }

    private IOException createImmutable() {
        return new IOException(String.format("Archived grammar '%s' is immutable.%nSave locally to allow changes.", this.getName()));
    }

    @Override
    public void reload() throws IOException {
        ZipFile zipFile = this.file == null ? ((JarURLConnection)this.url.openConnection()).getJarFile() : new ZipFile(this.file);
        EnumMap zipEntryMap = new EnumMap(ResourceKind.class);
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            zipEntryMap.put(kind, new HashMap());
            ++n2;
        }
        ZipEntry properties = null;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            int entryPrefixLength = this.entryName.length() + 1;
            if (!entryName.startsWith(this.entryName) || entryName.length() <= entryPrefixLength) continue;
            String restName = entryName.substring(entryPrefixLength);
            ResourceKind kind = null;
            ResourceKind[] resourceKindArray2 = ResourceKind.values();
            int n3 = resourceKindArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ResourceKind tryKind = resourceKindArray2[n4];
                if (restName.endsWith(tryKind.getFilter().getExtension())) {
                    kind = tryKind;
                    break;
                }
                ++n4;
            }
            if (kind == ResourceKind.PROPERTIES) {
                String propertiesName = FileType.PROPERTIES_FILTER.stripExtension(restName);
                if (propertiesName.equals("system")) {
                    properties = entry;
                    continue;
                }
                if (properties != null || !propertiesName.equals(this.grammarName)) continue;
                properties = entry;
                continue;
            }
            if (kind == null) {
                if (!restName.endsWith(FileType.LAYOUT_FILTER.getExtension())) continue;
                String objectName = FileType.LAYOUT_FILTER.stripExtension(restName);
                this.layoutEntryMap.put(objectName, entry);
                continue;
            }
            ZipEntry oldEntry = ((Map)zipEntryMap.get((Object)kind)).put(restName, entry);
            assert (oldEntry == null) : String.format("Duplicate %s name '%s'", kind.getName(), restName);
        }
        this.loadProperties(zipFile, properties);
        ResourceKind[] resourceKindArray3 = ResourceKind.values();
        int n5 = resourceKindArray3.length;
        n = 0;
        while (n < n5) {
            ResourceKind kind = resourceKindArray3[n];
            if (kind.isTextBased()) {
                this.loadTexts(kind, zipFile, (Map)zipEntryMap.get((Object)kind));
            } else if (kind.isGraphBased()) {
                this.loadGraphs(kind, zipFile, (Map)zipEntryMap.get((Object)kind));
            }
            ++n;
        }
        zipFile.close();
        this.notify(EnumSet.allOf(ResourceKind.class));
        this.initialised = true;
    }

    @Override
    public Object getLocation() {
        return this.location;
    }

    @Override
    public SystemStore save(File file, boolean clearDir) throws IOException {
        return SystemStore.save(file, this, clearDir);
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultArchiveSystemStore && ((DefaultArchiveSystemStore)obj).getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " - " + this.getLocation();
    }

    private void loadTexts(ResourceKind kind, ZipFile file, Map<String, ZipEntry> texts) throws IOException {
        this.getTextMap(kind).clear();
        for (Map.Entry<String, ZipEntry> textEntry : texts.entrySet()) {
            String controlName = kind.getFilter().stripExtension(textEntry.getKey());
            InputStream in = file.getInputStream(textEntry.getValue());
            String program = Util.readInputStreamToString(in);
            this.getTextMap(kind).put(controlName, program);
        }
    }

    private void loadGraphs(ResourceKind kind, ZipFile file, Map<String, ZipEntry> graphs) throws IOException {
        Map<String, AspectGraph> graphMap = this.getGraphMap(kind);
        graphMap.clear();
        for (Map.Entry<String, AspectGraph> entry : this.loadObjects(kind, file, graphs).entrySet()) {
            String name = this.createQualName(entry.getKey()).toString();
            graphMap.put(name, entry.getValue());
        }
        if (kind == ResourceKind.TYPE && this.properties != null) {
            Set<String> enabledTypes = this.properties.getActiveNames(kind);
            for (String enabledType : enabledTypes) {
                GraphInfo.setEnabled(graphMap.get(enabledType), true);
            }
        }
    }

    private void loadProperties(ZipFile file, ZipEntry entry) throws IOException {
        this.properties = new GrammarProperties();
        if (entry != null) {
            Properties grammarProperties = new Properties();
            InputStream s = file.getInputStream(entry);
            grammarProperties.load(s);
            s.close();
            this.properties.putAll((Map<?, ?>)grammarProperties);
            this.hasSystemPropertiesFile = true;
        } else {
            this.hasSystemPropertiesFile = false;
        }
    }

    private Map<String, AspectGraph> loadObjects(ResourceKind kind, ZipFile file, Map<String, ZipEntry> graphs) throws IOException {
        ExtensionFilter filter = kind.getFilter();
        HashMap<String, AspectGraph> result = new HashMap<String, AspectGraph>();
        for (Map.Entry<String, ZipEntry> graphEntry : graphs.entrySet()) {
            String graphName = filter.stripExtension(graphEntry.getKey());
            InputStream in = file.getInputStream(graphEntry.getValue());
            try {
                AttrGraph xmlGraph = GxlIO.getInstance().loadGraph(in);
                xmlGraph.setRole(kind.getGraphRole());
                xmlGraph.setName(this.createQualName(graphName).toString());
                this.addLayout(file, graphEntry.getKey(), xmlGraph);
                AspectGraph graph = xmlGraph.toAspectGraph();
                result.put(graphName, graph);
            }
            catch (FormatException exc) {
                throw new IOException(String.format("Format error while loading '%s':\n%s", graphName, exc.getMessage()), exc);
            }
            catch (IOException exc) {
                throw new IOException(String.format("Error while loading '%s':\n%s", graphName, exc.getMessage()), exc);
            }
        }
        return result;
    }

    private void addLayout(ZipFile file, String entryName, AttrGraph xmlGraph) throws IOException {
        ZipEntry layoutEntry = this.layoutEntryMap.get(entryName);
        if (layoutEntry != null) {
            LayoutIO.getInstance().loadLayout(xmlGraph, file.getInputStream(layoutEntry));
        }
    }

    private QualName createQualName(String restName) throws IOException {
        StringBuilder result = new StringBuilder();
        File nameAsFile = new File(FileType.RULE_FILTER.stripExtension(restName));
        result.append(nameAsFile.getName());
        while (nameAsFile.getParent() != null) {
            nameAsFile = nameAsFile.getParentFile();
            result.insert(0, ".");
            result.insert(0, nameAsFile.getName());
        }
        try {
            return new QualName(result.toString());
        }
        catch (FormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void notify(Set<ResourceKind> property) {
        this.observable.hasChanged();
        this.observable.notifyObservers(new MyEdit(property));
    }

    private void testInit() throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Operation should only be called after initialisation");
        }
    }

    @Override
    protected boolean hasSystemProperties() {
        return this.hasSystemPropertiesFile;
    }

    private static class MyEdit
    extends AbstractUndoableEdit
    implements SystemStore.Edit {
        private final Set<ResourceKind> change;

        public MyEdit(Set<ResourceKind> change) {
            this.change = change;
        }

        @Override
        public EditType getType() {
            return EditType.CREATE;
        }

        @Override
        public Set<ResourceKind> getChange() {
            return this.change;
        }
    }
}

