/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlCall;
import groove.control.CtrlPar;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.grammar.Rule;
import groove.grammar.host.AnchorValue;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.RuleToHostMap;
import groove.lts.GraphNextState;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.GraphTransitionKey;
import groove.lts.MatchResult;
import groove.lts.MatchResultSet;
import groove.lts.RuleTransition;
import groove.transform.CompositeEvent;
import groove.transform.Proof;
import groove.transform.Record;
import groove.transform.RuleEvent;
import groove.util.Visitor;
import groove.util.collect.KeySet;
import java.util.Set;

public class MatchCollector {
    private final GraphState state;
    private final CtrlState ctrlState;
    private final Record record;
    private final KeySet<GraphTransitionKey, GraphTransition> parentTransMap;
    private final Set<Rule> enabledRules;
    private final Set<Rule> disabledRules;
    private static int parentOutReuse;
    private static final boolean DEBUG = false;

    public MatchCollector(GraphState state) {
        this.state = state;
        this.ctrlState = state.getCtrlState();
        assert (this.ctrlState != null);
        this.record = state.getGTS().getRecord();
        boolean checkDiamonds = state.getGTS().checkDiamonds();
        GraphState parent = null;
        if (state instanceof GraphNextState) {
            parent = ((GraphNextState)state).source();
        }
        if (parent != null && parent.isClosed() && checkDiamonds) {
            this.parentTransMap = parent.getCache().getTransitionMap();
            Rule lastRule = ((GraphNextState)state).getEvent().getRule();
            this.enabledRules = this.record.getEnabledRules(lastRule);
            this.disabledRules = this.record.getDisabledRules(lastRule);
        } else {
            this.parentTransMap = null;
            this.enabledRules = null;
            this.disabledRules = null;
        }
    }

    public MatchResultSet computeMatches(final CtrlTransition ct) {
        RuleToHostMap boundMap;
        final MatchResultSet result = new MatchResultSet();
        assert (ct != null);
        final boolean isDisabled = this.isDisabled(ct.getCall());
        if (!isDisabled) {
            for (GraphTransition trans : this.parentTransMap) {
                RuleTransition ruleTrans;
                if (!(trans instanceof RuleTransition) || !(ruleTrans = (RuleTransition)trans).getEvent().getRule().equals(ct.getRule())) continue;
                result.add(ruleTrans.getKey());
            }
        }
        if ((isDisabled || this.isEnabled(ct.getCall())) && (boundMap = this.extractBinding(ct)) != null) {
            final Record record = this.record;
            Visitor<Proof, Boolean> eventCollector = new Visitor<Proof, Boolean>(Boolean.valueOf(false)){

                @Override
                protected boolean process(Proof object) {
                    RuleEvent event = record.getEvent(object);
                    MatchResult match = null;
                    if (isDisabled) {
                        match = MatchCollector.this.getParentTrans(event, ct);
                    }
                    if (match == null) {
                        match = new MatchResult(event, ct);
                    }
                    result.add(match);
                    this.setResult(true);
                    return true;
                }
            };
            ct.getRule().traverseMatches(this.state.getGraph(), boundMap, eventCollector);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void checkEvent(RuleEvent event) {
        if (event instanceof CompositeEvent) {
            for (RuleEvent ruleEvent : ((CompositeEvent)event).getEventSet()) {
                this.checkEvent(ruleEvent);
            }
        } else {
            void var2_6;
            boolean bl = false;
            while (var2_6 < event.getRule().getAnchor().size()) {
                AnchorValue anchorImage = event.getAnchorImage((int)var2_6);
                HostGraph host = this.state.getGraph();
                switch (anchorImage.getAnchorKind()) {
                    case EDGE: {
                        if (!host.containsEdge((HostEdge)anchorImage)) assert (false) : String.format("Edge %s does not occur in graph %s", anchorImage, host);
                        break;
                    }
                    case NODE: {
                        if (!(anchorImage instanceof ValueNode) && !host.containsNode((HostNode)anchorImage)) assert (false) : String.format("Node %s does not occur in graph %s", anchorImage, host);
                        break;
                    }
                }
                ++var2_6;
            }
        }
    }

    private boolean isEnabled(CtrlCall call) {
        if (this.enabledRules == null || this.enabledRules.contains(call.getRule())) {
            return true;
        }
        GraphNextState state = (GraphNextState)this.state;
        if (state.getCtrlTransition().isModifying()) {
            return true;
        }
        Set<CtrlCall> triedCalls = state.source().getSchedule().getTriedCalls();
        return triedCalls == null || !triedCalls.contains(call);
    }

    private boolean isDisabled(CtrlCall call) {
        if (this.disabledRules == null || this.disabledRules.contains(call.getRule())) {
            return true;
        }
        GraphNextState state = (GraphNextState)this.state;
        return state.getCtrlTransition().isModifying();
    }

    /*
     * Unable to fully structure code
     */
    private RuleToHostMap extractBinding(CtrlTransition ctrlTrans) {
        block4: {
            result = this.state.getGraph().getFactory().createRuleToHostMap();
            args = ctrlTrans.getCall().getArgs();
            if (args == null || args.size() <= 0) break block4;
            parBinding = ctrlTrans.getParBinding();
            ruleSig = ctrlTrans.getRule().getSignature();
            boundNodes = this.state.getBoundNodes();
            i = 0;
            while (i < args.size()) {
                block7: {
                    block6: {
                        block5: {
                            arg = args.get(i);
                            image = null;
                            if (!(arg instanceof CtrlPar.Const)) break block5;
                            constArg = (CtrlPar.Const)arg;
                            image = this.state.getGraph().getFactory().createValueNode(constArg.getAlgebra(), constArg.getValue());
                            if (!MatchCollector.$assertionsDisabled && image == null) {
                                throw new AssertionError((Object)String.format("Constant argument %s not initialised properly", new Object[]{arg}));
                            }
                            break block6;
                        }
                        if (arg.isInOnly()) {
                            image = boundNodes[parBinding[i]];
                            if (image == null) {
                                result = null;
                                break;
                            } else {
                                ** GOTO lbl24
                            }
                        }
                        break block7;
                    }
                    result.putNode(ruleSig.get(i).getRuleNode(), image);
                }
                ++i;
            }
        }
        return result;
    }

    private MatchResult getParentTrans(RuleEvent event, CtrlTransition ct) {
        MatchResult result = null;
        if (this.parentTransMap != null) {
            RuleTransition trans = (RuleTransition)this.parentTransMap.get(new MatchResult(event, ct));
            return trans == null ? null : trans.getKey();
        }
        return result;
    }

    public static int getEventReuse() {
        return parentOutReuse;
    }
}

