/*
 * Decompiled with CFR 0.152.
 */
package groove.match;

import groove.algebra.SignatureKind;
import groove.grammar.Condition;
import groove.grammar.rule.VariableNode;
import groove.match.ValueOracle;
import java.util.Collections;

public class RandomValueOracle
implements ValueOracle {
    private static final RandomValueOracle instance = new RandomValueOracle();

    private RandomValueOracle() {
    }

    @Override
    public Iterable<String> getValues(Condition condition, VariableNode var) {
        String result;
        SignatureKind sig = var.getSignature();
        switch (sig) {
            case BOOL: {
                result = Math.random() < 0.5 ? "true" : "false";
                break;
            }
            case INT: {
                result = "" + (int)(Math.random() * 100.0);
                break;
            }
            case REAL: {
                result = "" + Math.random() * 100.0;
                break;
            }
            case STRING: {
                StringBuffer text = new StringBuffer();
                int length = (int)(Math.random() * 10.0);
                int i = 0;
                while (i < length) {
                    text.append((char)(48.0 + Math.random() * 36.0));
                    ++i;
                }
                result = text.toString();
                break;
            }
            default: {
                result = null;
                assert (false);
                break;
            }
        }
        return Collections.singleton(result);
    }

    public static final RandomValueOracle instance() {
        return instance;
    }
}

