/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.algebra.SignatureKind;
import groove.grammar.Condition;
import groove.grammar.host.DefaultHostNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeElement;
import groove.graph.Element;
import groove.match.SearchEngine;
import groove.match.SearchStrategy;
import groove.match.TreeMatch;
import groove.match.ValueOracle;
import groove.match.plan.PlanSearchEngine;
import groove.match.plan.SearchItem;
import groove.match.plan.SearchPlan;
import groove.util.Reporter;
import groove.util.Visitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PlanSearchStrategy
implements SearchStrategy {
    private Search search;
    private final ValueOracle oracle;
    private final PlanSearchEngine engine;
    final SearchPlan plan;
    final boolean injective;
    private final Map<RuleNode, Integer> nodeIxMap = new HashMap<RuleNode, Integer>();
    private final Map<RuleEdge, Integer> edgeIxMap = new HashMap<RuleEdge, Integer>();
    private final Map<LabelVar, Integer> varIxMap = new HashMap<LabelVar, Integer>();
    private final Map<Condition, Integer> condIxMap = new HashMap<Condition, Integer>();
    RuleNode[] nodeKeys;
    RuleEdge[] edgeKeys;
    LabelVar[] varKeys;
    private boolean fixed;
    private static final Reporter reporter = Reporter.register(PlanSearchStrategy.class);
    public static final Reporter searchFindReporter = reporter.register("Search.find()");

    public PlanSearchStrategy(PlanSearchEngine engine, SearchPlan plan, ValueOracle oracle) {
        this.engine = engine;
        this.oracle = oracle;
        this.plan = plan;
        this.injective = plan.isInjective();
    }

    @Override
    public SearchEngine getEngine() {
        return this.engine;
    }

    @Override
    public ValueOracle getOracle() {
        return this.oracle;
    }

    @Override
    public <T> T traverse(HostGraph host, RuleToHostMap seedMap, Visitor<TreeMatch, T> visitor) {
        Search search = this.getSearch(host, seedMap);
        while (search.find() && visitor.visit(search.getMatch())) {
        }
        return visitor.getResult();
    }

    protected final boolean isInjective() {
        return this.injective;
    }

    protected final SearchPlan getPlan() {
        return this.plan;
    }

    public String toString() {
        return String.valueOf(this.plan.toString()) + (this.isInjective() ? " (injective)" : " (non-injective)");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isInjective() ? 1231 : 1237);
        result = 31 * result + this.getOracle().hashCode();
        result = 31 * result + this.getPlan().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlanSearchStrategy other = (PlanSearchStrategy)obj;
        if (this.isInjective() != other.isInjective()) {
            return false;
        }
        if (!this.getOracle().equals(other.getOracle())) {
            return false;
        }
        return this.getPlan().equals(other.getPlan());
    }

    private Search getSearch(HostGraph host, RuleToHostMap seedMap) {
        this.search = this.createSearch();
        this.search.initialise(host, seedMap);
        return this.search;
    }

    private Search createSearch() {
        this.testFixed(true);
        return new Search();
    }

    boolean isNodeFound(RuleNode node) {
        return this.nodeIxMap.get(node) != null;
    }

    boolean isEdgeFound(RuleEdge edge) {
        return this.edgeIxMap.get(edge) != null;
    }

    boolean isVarFound(LabelVar var) {
        return this.varIxMap.get(var) != null;
    }

    int getNodeIx(RuleNode node) {
        Integer result = this.nodeIxMap.get(node);
        if (result == null) {
            this.testFixed(false);
            result = this.nodeIxMap.size();
            this.nodeIxMap.put(node, result);
        }
        return result;
    }

    int getEdgeIx(RuleEdge edge) {
        Integer value = this.edgeIxMap.get(edge);
        if (value == null) {
            this.testFixed(false);
            value = this.edgeIxMap.size();
            this.edgeIxMap.put(edge, value);
        }
        return value;
    }

    int getVarIx(LabelVar var) {
        Integer value = this.varIxMap.get(var);
        if (value == null) {
            this.testFixed(false);
            value = this.varIxMap.size();
            this.varIxMap.put(var, value);
        }
        return value;
    }

    int getCondIx(Condition cond) {
        Integer value = this.condIxMap.get(cond);
        if (value == null) {
            this.testFixed(false);
            value = this.condIxMap.size();
            this.condIxMap.put(cond, value);
        }
        return value;
    }

    public void setFixed() {
        if (!this.fixed) {
            for (SearchItem searchItem : this.plan) {
                searchItem.activate(this);
            }
            this.nodeKeys = new RuleNode[this.nodeIxMap.size()];
            for (Map.Entry entry : this.nodeIxMap.entrySet()) {
                this.nodeKeys[((Integer)entry.getValue()).intValue()] = (RuleNode)entry.getKey();
            }
            this.edgeKeys = new RuleEdge[this.edgeIxMap.size()];
            for (Map.Entry entry : this.edgeIxMap.entrySet()) {
                this.edgeKeys[((Integer)entry.getValue()).intValue()] = (RuleEdge)entry.getKey();
            }
            this.varKeys = new LabelVar[this.varIxMap.size()];
            for (Map.Entry entry : this.varIxMap.entrySet()) {
                this.varKeys[((Integer)entry.getValue()).intValue()] = (LabelVar)entry.getKey();
            }
            this.fixed = true;
        }
    }

    private void testFixed(boolean fixed) {
        if (this.fixed != fixed) {
            throw new IllegalStateException(String.format("Search plan is %s fixed", fixed ? "not yet" : ""));
        }
    }

    public class Search {
        private final HostNode[] nodeImages;
        private final HostEdge[] edgeImages;
        private final TypeElement[] varImages;
        private final TreeMatch[] subMatches;
        private final HostNode[] nodeSeeds;
        private final HostEdge[] edgeSeeds;
        private final TypeElement[] varSeeds;
        private boolean found;
        private int lastSingular;
        private HostGraph host;
        private HostNodeSet usedNodes;
        private final SearchItem.Record[] records;
        private final SearchItem.Record[][] influence;
        private final int[] influenceCount;
        private static final boolean PRINT_MATCHES = false;
        private static final boolean CHECK_IMAGES = true;

        public Search() {
            int planSize = PlanSearchStrategy.this.plan.size();
            this.records = new SearchItem.Record[planSize];
            this.influence = new SearchItem.Record[planSize][];
            this.influenceCount = new int[planSize];
            this.nodeImages = new HostNode[PlanSearchStrategy.this.nodeKeys.length];
            this.edgeImages = new HostEdge[PlanSearchStrategy.this.edgeKeys.length];
            this.varImages = new TypeElement[PlanSearchStrategy.this.varKeys.length];
            this.nodeSeeds = new HostNode[PlanSearchStrategy.this.nodeKeys.length];
            this.edgeSeeds = new HostEdge[PlanSearchStrategy.this.edgeKeys.length];
            this.varSeeds = new TypeElement[PlanSearchStrategy.this.varKeys.length];
            this.subMatches = new TreeMatch[PlanSearchStrategy.this.condIxMap.size()];
        }

        /*
         * WARNING - void declaration
         */
        public void initialise(HostGraph host, RuleToHostMap seedMap) {
            void var3_10;
            this.host = host;
            if (PlanSearchStrategy.this.isInjective()) {
                this.getUsedNodes().clear();
            }
            if (seedMap != null) {
                int i;
                for (Map.Entry entry : seedMap.nodeMap().entrySet()) {
                    assert (PlanSearchStrategy.this.isNodeFound((RuleNode)entry.getKey()));
                    i = PlanSearchStrategy.this.getNodeIx((RuleNode)entry.getKey());
                    this.nodeImages[i] = this.nodeSeeds[i] = (HostNode)entry.getValue();
                    if (!PlanSearchStrategy.this.isInjective()) continue;
                    this.getUsedNodes().add((HostNode)entry.getValue());
                }
                for (Map.Entry<Object, Object> entry : seedMap.edgeMap().entrySet()) {
                    assert (PlanSearchStrategy.this.isEdgeFound((RuleEdge)entry.getKey()));
                    i = PlanSearchStrategy.this.getEdgeIx((RuleEdge)entry.getKey());
                    this.edgeImages[i] = this.edgeSeeds[i] = (HostEdge)entry.getValue();
                }
                for (Map.Entry<Object, Object> entry : seedMap.getValuation().entrySet()) {
                    assert (PlanSearchStrategy.this.isVarFound((LabelVar)entry.getKey()));
                    i = PlanSearchStrategy.this.getVarIx((LabelVar)entry.getKey());
                    this.varImages[i] = this.varSeeds[i] = (TypeElement)entry.getValue();
                }
            }
            boolean bl = false;
            while (var3_10 < this.records.length && this.records[var3_10] != null) {
                this.records[var3_10].initialise(host);
                ++var3_10;
            }
            this.found = false;
            this.lastSingular = -1;
        }

        public String toString() {
            return Arrays.toString(this.records);
        }

        public boolean find() {
            int current;
            searchFindReporter.start();
            int planSize = PlanSearchStrategy.this.plan.size();
            boolean found = this.found;
            if (found) {
                SearchItem.Record currentRecord;
                current = planSize - 1;
                while (current >= 0 && !(currentRecord = this.getRecord(current)).isRelevant()) {
                    currentRecord.repeat();
                    --current;
                }
            } else {
                current = 0;
            }
            while (current > this.lastSingular && current < planSize) {
                boolean success = this.getRecord(current).next();
                if (success) {
                    int i = 0;
                    while (i < this.influenceCount[current]) {
                        this.influence[current][i].reset();
                        ++i;
                    }
                    ++current;
                    continue;
                }
                if (this.getRecord(current).isEmpty()) {
                    int dependency = PlanSearchStrategy.this.plan.getDependency(current);
                    --current;
                    while (current > dependency) {
                        this.getRecord(current).repeat();
                        --current;
                    }
                    continue;
                }
                --current;
            }
            found = current == planSize;
            boolean oldFound = this.found;
            this.found = found;
            searchFindReporter.stop();
            return found;
        }

        private SearchItem.Record getRecord(int current) {
            SearchItem.Record result = this.records[current];
            if (result == null) {
                SearchItem item = (SearchItem)PlanSearchStrategy.this.plan.get(current);
                result = item.createRecord(this);
                result.initialise(this.host);
                this.records[current] = result;
                this.influence[current] = new SearchItem.Record[this.influence.length - current];
                int dependency = PlanSearchStrategy.this.plan.getDependency(current);
                assert (dependency < current);
                if (dependency >= 0) {
                    this.influence[dependency][this.influenceCount[dependency]] = result;
                    int n = dependency;
                    this.influenceCount[n] = this.influenceCount[n] + 1;
                }
                if (this.lastSingular == current - 1 && result.isSingular()) {
                    ++this.lastSingular;
                }
            }
            return result;
        }

        final boolean putNode(int index, HostNode image) {
            if (image instanceof DefaultHostNode && !this.host.containsNode(image)) assert (false) : String.format("Node %s does not occur in graph %s", image, this.host);
            RuleNode nodeKey = PlanSearchStrategy.this.nodeKeys[index];
            assert (image == null || this.nodeSeeds[index] == null) : String.format("Assignment %s=%s replaces pre-matched image %s", nodeKey, image, this.nodeSeeds[index]);
            boolean keyIsVariableNode = nodeKey instanceof VariableNode;
            if (image instanceof ValueNode) {
                if (!keyIsVariableNode) {
                    return false;
                }
                SignatureKind keySignature = ((VariableNode)nodeKey).getSignature();
                if (((ValueNode)image).getSignature() != keySignature) {
                    return false;
                }
            } else {
                if (keyIsVariableNode) {
                    return false;
                }
                if (PlanSearchStrategy.this.isInjective()) {
                    HostNode oldImage = this.nodeImages[index];
                    if (oldImage != null) {
                        boolean removed = this.getUsedNodes().remove(oldImage);
                        assert (removed) : String.format("Node image %s not in used nodes %s", oldImage, this.getUsedNodes());
                    }
                    if (image != null && !this.getUsedNodes().add(image)) {
                        this.nodeImages[index] = null;
                        return false;
                    }
                }
            }
            this.nodeImages[index] = image;
            return true;
        }

        final boolean putEdge(int index, HostEdge image) {
            if (image != null && !this.host.containsEdge(image)) assert (false) : String.format("Edge %s does not occur in graph %s", image, this.host);
            this.edgeImages[index] = image;
            return true;
        }

        final boolean putVar(int index, TypeElement image) {
            this.varImages[index] = image;
            return true;
        }

        final boolean putSubMatch(int index, TreeMatch match) {
            this.subMatches[index] = match;
            return true;
        }

        final HostNode getNode(int index) {
            return this.nodeImages[index];
        }

        final HostEdge getEdge(int index) {
            return this.edgeImages[index];
        }

        final TypeElement getVar(int index) {
            return this.varImages[index];
        }

        final TreeMatch getSubMatch(int index) {
            return this.subMatches[index];
        }

        final HostNode getNodeSeed(int index) {
            return this.nodeSeeds[index];
        }

        final HostEdge getEdgeSeed(int index) {
            return this.edgeSeeds[index];
        }

        final TypeElement getVarSeed(int index) {
            return this.varSeeds[index];
        }

        public TreeMatch getMatch() {
            TreeMatch result = null;
            if (this.found) {
                Element image;
                RuleToHostMap patternMap = this.host.getFactory().createRuleToHostMap();
                int i = 0;
                while (i < this.nodeImages.length) {
                    image = this.nodeImages[i];
                    if (image != null) {
                        patternMap.putNode(PlanSearchStrategy.this.nodeKeys[i], (HostNode)image);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.edgeImages.length) {
                    image = this.edgeImages[i];
                    if (image != null) {
                        patternMap.putEdge(PlanSearchStrategy.this.edgeKeys[i], image);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.varImages.length) {
                    image = this.varImages[i];
                    if (image != null) {
                        patternMap.putVar(PlanSearchStrategy.this.varKeys[i], (TypeElement)image);
                    }
                    ++i;
                }
                result = new TreeMatch(PlanSearchStrategy.this.plan.getCondition(), patternMap);
                i = 0;
                while (i < this.subMatches.length) {
                    result.addSubMatch(this.subMatches[i]);
                    ++i;
                }
            }
            return result;
        }

        private HostNodeSet getUsedNodes() {
            if (this.usedNodes == null) {
                this.usedNodes = new HostNodeSet();
            }
            return this.usedNodes;
        }
    }
}

