/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.grammar.rule.Anchor;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleNode;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SeedSearchItem
extends AbstractSearchItem {
    private final Anchor seed;
    private final List<RuleNode> boundNodes;
    private final List<RuleEdge> boundEdges;
    private final List<LabelVar> boundVars;
    private Map<RuleNode, Integer> nodeIxMap;
    private Map<RuleEdge, Integer> edgeIxMap;
    private Map<LabelVar, Integer> varIxMap;
    private Set<Object> unmatched;

    SeedSearchItem(Anchor seed) {
        this.seed = seed;
        this.boundNodes = Arrays.asList(seed.nodeSet().toArray(new RuleNode[0]));
        this.boundEdges = Arrays.asList(seed.edgeSet().toArray(new RuleEdge[0]));
        this.boundVars = Arrays.asList(seed.varSet().toArray(new LabelVar[0]));
    }

    @Override
    public Collection<? extends RuleEdge> bindsEdges() {
        return this.boundEdges;
    }

    @Override
    public Collection<? extends RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    @Override
    public Collection<LabelVar> bindsVars() {
        return this.boundVars;
    }

    @Override
    public int compareTo(SearchItem item) {
        int result = super.compareTo(item);
        if (result != 0) {
            return result;
        }
        SeedSearchItem other = (SeedSearchItem)item;
        result = this.seed.compareTo(other.seed);
        return result;
    }

    @Override
    int computeHashCode() {
        return super.computeHashCode() + 31 * this.seed.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SeedSearchItem other = (SeedSearchItem)obj;
        return this.seed.equals(other.seed);
    }

    @Override
    int getRating() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        this.nodeIxMap = new HashMap<RuleNode, Integer>();
        for (RuleNode node : this.boundNodes) {
            assert (!strategy.isNodeFound(node)) : String.format("Node %s is not fresh", node);
            this.nodeIxMap.put(node, strategy.getNodeIx(node));
        }
        this.edgeIxMap = new HashMap<RuleEdge, Integer>();
        for (RuleEdge edge : this.boundEdges) {
            assert (!strategy.isEdgeFound(edge)) : String.format("Edge %s is not fresh", edge);
            this.edgeIxMap.put(edge, strategy.getEdgeIx(edge));
        }
        this.varIxMap = new HashMap<LabelVar, Integer>();
        for (LabelVar var : this.boundVars) {
            assert (!strategy.isVarFound(var)) : String.format("Variable %s is not fresh", var);
            this.varIxMap.put(var, strategy.getVarIx(var));
        }
    }

    public String toString() {
        return String.format("Check %s", this.seed);
    }

    @Override
    public SearchItem.Record createRecord(PlanSearchStrategy.Search search) {
        assert (this.allElementsMatched(search)) : String.format("Elements %s not pre-matched", this.unmatched);
        return new AbstractSearchItem.DummyRecord();
    }

    private boolean allElementsMatched(PlanSearchStrategy.Search search) {
        if (this.unmatched == null) {
            this.unmatched = new HashSet<Object>();
            for (Map.Entry<RuleNode, Integer> entry : this.nodeIxMap.entrySet()) {
                if (search.getNode(entry.getValue()) != null) continue;
                this.unmatched.add(entry.getKey());
            }
            for (Map.Entry<RuleElement, Integer> entry : this.edgeIxMap.entrySet()) {
                if (search.getEdge(entry.getValue()) != null) continue;
                this.unmatched.add(entry.getKey());
            }
            for (Map.Entry<AnchorKey, Integer> entry : this.varIxMap.entrySet()) {
                if (search.getVar(entry.getValue()) != null) continue;
                this.unmatched.add(entry.getKey());
            }
        }
        return this.unmatched.isEmpty();
    }
}

