/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.graph.Edge;
import groove.graph.Node;
import groove.match.rete.RetePathMatch;

public final class LookupEntry {
    private final int pos;
    private final Role role;

    public LookupEntry(int pos, Role role) {
        this.pos = pos;
        this.role = role;
    }

    public int getPos() {
        return this.pos;
    }

    public Role getRole() {
        return this.role;
    }

    public Node lookup(Object[] units) {
        return this.extract(units[this.pos]);
    }

    private Node extract(Object unit) {
        Node result = null;
        switch (this.role) {
            case NODE: {
                result = (Node)unit;
                break;
            }
            case SOURCE: {
                if (unit instanceof Edge) {
                    result = ((Edge)unit).source();
                    break;
                }
                if (!(unit instanceof RetePathMatch)) break;
                result = ((RetePathMatch)unit).start();
                break;
            }
            case TARGET: {
                if (unit instanceof Edge) {
                    result = ((Edge)unit).target();
                    break;
                }
                if (!(unit instanceof RetePathMatch)) break;
                result = ((RetePathMatch)unit).end();
            }
        }
        return result;
    }

    public static enum Role {
        NODE,
        SOURCE,
        TARGET;

    }
}

