/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.match.rete.ReteSearchEngine;
import groove.util.CommandLineOption;
import groove.util.CommandLineTool;
import java.io.IOException;
import java.util.List;

public class ReteTool
extends CommandLineTool {
    private SaveNetworkOption saveNetworkOption = new SaveNetworkOption();
    private GrammarModel grammarView;

    public ReteTool(String ... args) {
        super(args);
        this.addOption(this.saveNetworkOption);
    }

    @Override
    public void processArguments() {
        super.processArguments();
        List<String> argsList = this.getArgs();
        if (argsList.size() > 0) {
            this.grammarView = this.loadGrammar(argsList.get(0));
        } else {
            this.printError("No grammar location specified", true);
        }
    }

    private void start() {
        try {
            this.processArguments();
            this.doSaveReteNetwork();
            this.print("RETE network shape was successuflly saved to " + this.saveNetworkOption.outputFilePath);
        }
        catch (FormatException ex) {
            this.print("Could not load the grammar due to some formatting errors in it:" + ex.getMessage());
        }
    }

    private void doSaveReteNetwork() throws FormatException {
        String name = "RETE-" + this.getGrammarView().getName();
        String filePath = this.saveNetworkOption.outputFilePath != null ? this.saveNetworkOption.outputFilePath : name;
        new ReteSearchEngine(this.getGrammarView().toGrammar()).getNetwork().save(filePath, name);
    }

    private GrammarModel loadGrammar(String path) {
        GrammarModel result = null;
        try {
            result = GrammarModel.newInstance(path);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        return result;
    }

    public static void main(String[] args) {
        new ReteTool(args).start();
    }

    @Override
    protected String getUsageMessage() {
        return "Usage: ReteTool [options] grammar-location";
    }

    @Override
    protected boolean supportsVerbosityOption() {
        return false;
    }

    @Override
    protected boolean supportsOutputOption() {
        return false;
    }

    @Override
    protected boolean supportsLogOption() {
        return false;
    }

    private GrammarModel getGrammarView() {
        return this.grammarView;
    }

    static class SaveNetworkOption
    implements CommandLineOption {
        protected String outputFilePath;
        public static final String NAME = "f";
        public static final String DESCRIPTION = "Save a the shape of the RETE network for the given grammar.";

        SaveNetworkOption() {
        }

        @Override
        public String[] getDescription() {
            return new String[]{DESCRIPTION};
        }

        @Override
        public String getName() {
            return "s";
        }

        @Override
        public String getParameterName() {
            return "graph-file-path";
        }

        @Override
        public boolean hasParameter() {
            return true;
        }

        @Override
        public void parse(String parameter) throws IllegalArgumentException {
            if (parameter.trim().length() == 0) {
                throw new IllegalArgumentException("An output graph file path should be specified.");
            }
            this.outputFilePath = parameter;
        }

        public String getOutputFilePath() {
            return this.outputFilePath;
        }
    }
}

