/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.automaton.RegExpr;
import groove.grammar.host.HostEdge;
import groove.match.rete.AbstractPathChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.RetePathMatch;
import groove.match.rete.ReteStateSubscriber;
import groove.util.collect.TreeHashSet;
import java.util.List;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class SingleEdgePathChecker
extends AbstractPathChecker
implements ReteStateSubscriber {
    private TreeHashSet<RetePathMatch> memory = new TreeHashSet();

    public SingleEdgePathChecker(ReteNetwork network, RegExpr expression, boolean isLoop) {
        super(network, expression, isLoop);
        this.getOwner().getState().subscribe(this);
        assert (expression instanceof RegExpr.Atom || expression instanceof RegExpr.Wildcard);
    }

    public void receive(ReteNetworkNode source, HostEdge gEdge, ReteNetworkNode.Action action) {
        if (this.loop && gEdge.source() != gEdge.target()) {
            return;
        }
        RetePathMatch m = this.makeMatch(gEdge);
        if (action == ReteNetworkNode.Action.ADD) {
            assert (!this.memory.contains(m));
            this.memory.add(m);
            this.passDownMatchToSuccessors(m);
        } else if (this.memory.contains(m)) {
            RetePathMatch m1 = m;
            m = this.memory.put(m);
            this.memory.remove(m1);
            m.dominoDelete(null);
        }
    }

    protected abstract RetePathMatch makeMatch(HostEdge var1);

    @Override
    public int demandOneMatch() {
        return 0;
    }

    @Override
    public boolean demandUpdate() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatedIndex, RetePathMatch newMatch) {
        throw new NotImplementedException();
    }

    @Override
    public List<? extends Object> initialize() {
        super.initialize();
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.memory.clear();
    }
}

